/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;

public class TriremeNativeSupport
implements InternalNodeModule {
    public String getModuleName() {
        return "trireme-native-support";
    }

    public Scriptable registerExports(Context cx, Scriptable global, NodeRuntime runtime) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)global, NativeSupportImpl.class);
        NativeSupportImpl sup = (NativeSupportImpl)cx.newObject(global, "_triremeNativeSupportClass");
        sup.initialize(runtime);
        return sup;
    }

    public static class NativeSupportImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_triremeNativeSupportClass";
        public static final String INTERFACE_VERSION = "1.0.0";
        private ScriptRunner runtime;

        public String getClassName() {
            return CLASS_NAME;
        }

        public void initialize(NodeRuntime runtime) {
            this.runtime = (ScriptRunner)runtime;
        }

        @JSGetter(value="interfaceVersion")
        public String getInterfaceVersion() {
            return INTERFACE_VERSION;
        }

        @JSFunction
        public static Object loadJars(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Object[] jarNames;
            Scriptable jars = ArgUtils.objArg(args, 0, Scriptable.class, true);
            if (!ScriptRuntime.isArrayObject((Object)jars)) {
                throw Utils.makeError(cx, thisObj, "JAR list is not an array");
            }
            NativeSupportImpl self = (NativeSupportImpl)thisObj;
            if (self.runtime.getSandbox() != null && !self.runtime.getSandbox().isAllowJarLoading()) {
                throw Utils.makeError(cx, thisObj, "JAR loading is not allowed due to the sandbox policy");
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object jn : jarNames = ScriptRuntime.getArrayElements((Scriptable)jars)) {
                if (!(jn instanceof CharSequence)) {
                    throw Utils.makeError(cx, thisObj, "JAR list must consist of String objects");
                }
                File jarFile = self.runtime.translatePath(jn.toString());
                if (!(jarFile.exists() && jarFile.canRead() && jarFile.isFile())) {
                    throw Utils.makeError(cx, thisObj, "Cannot read JAR file " + jarFile.getPath());
                }
                try {
                    urls.add(new URL("file:" + jarFile.getPath()));
                }
                catch (MalformedURLException e) {
                    throw Utils.makeError(cx, thisObj, "Cannot get URL for JAR file :" + e);
                }
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
            self.runtime.getRegistry().load(cx, loader);
            return loader;
        }
    }
}

