/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.util.ByteString$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity;
import play.api.http.HttpProtocol$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookies$;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.Flash;
import play.api.mvc.Flash$;
import play.api.mvc.RequestHeader;
import play.api.mvc.ResponseHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.server.common.ServerResultUtils;
import play.core.server.common.ServerResultUtils$DefaultClose$;
import play.core.server.common.ServerResultUtils$DefaultKeepAlive$;
import play.core.server.common.ServerResultUtils$SendClose$;
import play.core.server.common.ServerResultUtils$SendKeepAlive$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class ServerResultUtils$ {
    public static final ServerResultUtils$ MODULE$;
    private final String play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    private final String play$core$server$common$ServerResultUtils$$CLOSE;

    static {
        new ServerResultUtils$();
    }

    public ServerResultUtils.ConnectionHeader determineConnectionHeader(RequestHeader request, Result result) {
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_1();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : (result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$SendClose$.MODULE$ : ServerResultUtils$DefaultKeepAlive$.MODULE$)) : (result.header().headers().get((Object)HeaderNames$.MODULE$.CONNECTION()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return x$3.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$CLOSE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : (result.body() instanceof HttpEntity.Streamed && result.body().contentLength().isEmpty() || request.headers().get(HeaderNames$.MODULE$.CONNECTION()).forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return !x$4.equalsIgnoreCase(ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$KEEP_ALIVE());
            }
        }) ? ServerResultUtils$DefaultClose$.MODULE$ : ServerResultUtils$SendKeepAlive$.MODULE$));
    }

    public Result validateResult(RequestHeader request, Result result, Materializer mat) {
        Result result2;
        String string = request.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_0();
        if (!(string != null ? !string.equals(string2) : string2 != null) && result.body() instanceof HttpEntity.Chunked) {
            this.cancelEntity(result.body(), mat);
            result2 = Results$.MODULE$.Status(Status$.MODULE$.HTTP_VERSION_NOT_SUPPORTED()).apply((Object)"The response to this request is chunked and hence requires HTTP 1.1 to be sent, but this is a HTTP 1.0 request.", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())).withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION()), (Object)this.play$core$server$common$ServerResultUtils$$CLOSE())}));
        } else if (this.mayHaveEntity(result.header().status()) || result.body().isKnownEmpty()) {
            result2 = result;
        } else {
            this.cancelEntity(result.body(), mat);
            HttpEntity.Strict x$6 = new HttpEntity.Strict(ByteString$.MODULE$.empty(), result.body().contentType());
            ResponseHeader x$7 = result.copy$default$1();
            result2 = result.copy(x$7, (HttpEntity)x$6);
        }
        return result2;
    }

    private boolean mayHaveEntity(int status) {
        return status != Status$.MODULE$.NO_CONTENT() && status != Status$.MODULE$.NOT_MODIFIED();
    }

    public Object cancelEntity(HttpEntity entity, Materializer mat) {
        Object object;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.Chunked) {
            HttpEntity.Chunked chunked = (HttpEntity.Chunked)httpEntity;
            Source chunks = chunked.chunks();
            object = chunks.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        } else if (httpEntity instanceof HttpEntity.Streamed) {
            HttpEntity.Streamed streamed = (HttpEntity.Streamed)httpEntity;
            Source data = streamed.data();
            object = data.runWith((Graph)Sink$.MODULE$.cancelled(), mat);
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    public String play$core$server$common$ServerResultUtils$$KEEP_ALIVE() {
        return this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    }

    public String play$core$server$common$ServerResultUtils$$CLOSE() {
        return this.play$core$server$common$ServerResultUtils$$CLOSE;
    }

    public Result cleanFlashCookie(RequestHeader requestHeader, Result result) {
        Flash requestFlash;
        Option optResultFlashCookies = result.header().headers().get((Object)HeaderNames$.MODULE$.SET_COOKIE()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Cookie> apply(String setCookieValue) {
                return Cookies$.MODULE$.decodeSetCookieHeader(setCookieValue).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Cookie x$5) {
                        String string = x$5.name();
                        String string2 = Flash$.MODULE$.COOKIE_NAME();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
        });
        return optResultFlashCookies.isDefined() ? result : ((requestFlash = requestHeader.flash()).isEmpty() ? result : result.discardingCookies((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DiscardingCookie[]{Flash$.MODULE$.discard()})));
    }

    public Iterable<Tuple2<String, String>> splitSetCookieHeaders(Map<String, String> headers) {
        return headers.contains((Object)HeaderNames$.MODULE$.SET_COOKIE()) ? (Iterable)((TraversableLike)headers.to(Predef$.MODULE$.fallbackStringCanBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SeqLike<Tuple2<String, String>, Object> apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2;
                block4: {
                    SeqLike seqLike;
                    block3: {
                        block2: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block2;
                            String string = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            String string2 = HeaderNames$.MODULE$.SET_COOKIE();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            String[] cookieParts = Cookies$.MODULE$.SetCookieHeaderSeparatorRegex().split((CharSequence)value);
                            seqLike = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cookieParts).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, String> apply(String cookiePart) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE()), (Object)cookiePart);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)name, (Object)value)}));
                    }
                    return seqLike;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()) : headers;
    }

    private ServerResultUtils$() {
        MODULE$ = this;
        this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE = "keep-alive";
        this.play$core$server$common$ServerResultUtils$$CLOSE = "close";
    }
}

