/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import play.core.ApplicationProvider;
import play.core.server.ServerConfig;
import play.core.server.ssl.DefaultSSLEngineProvider$;
import play.core.server.ssl.FakeKeyStore$;
import play.core.server.ssl.noCATrustManager$;
import play.server.api.SSLEngineProvider;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u0017\tAB)\u001a4bk2$8k\u0015'F]\u001eLg.\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011aA:tY*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T\u0011!C\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0012$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!\u0002\u0005\n\u0005i1\"!E*T\u0019\u0016sw-\u001b8f!J|g/\u001b3fe\"AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0007tKJ4XM]\"p]\u001aLw\r\u0005\u0002\u001f?5\tA!\u0003\u0002!\t\ta1+\u001a:wKJ\u001cuN\u001c4jO\"A!\u0005\u0001B\u0001B\u0003%1%A\u0006baB\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u0013&\u001b\u00051\u0011B\u0001\u0014\u0007\u0005M\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\u0019!\u0006L\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000bq9\u0003\u0019A\u000f\t\u000b\t:\u0003\u0019A\u0012\t\u000f=\u0002!\u0019!C\u0001a\u0005Q1o\u001d7D_:$X\r\u001f;\u0016\u0003E\u0002\"A\r\u001d\u000e\u0003MR!a\u0001\u001b\u000b\u0005U2\u0014a\u00018fi*\tq'A\u0003kCZ\f\u00070\u0003\u0002:g\tQ1k\u0015'D_:$X\r\u001f;\t\rm\u0002\u0001\u0015!\u00032\u0003-\u00198\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u000bu\u0002A\u0011\t \u0002\u001f\r\u0014X-\u0019;f'NcUI\\4j]\u0016$\u0012a\u0010\t\u0003e\u0001K!!Q\u001a\u0003\u0013M\u001bF*\u00128hS:,\u0007\"B\"\u0001\t\u0003!\u0015\u0001E2sK\u0006$XmU*M\u0007>tG/\u001a=u)\t\tT\tC\u0003G\u0005\u0002\u00071%A\nbaBd\u0017nY1uS>t\u0007K]8wS\u0012,'oB\u0003I\u0005!\u0005\u0011*\u0001\rEK\u001a\fW\u000f\u001c;T'2+enZ5oKB\u0013xN^5eKJ\u0004\"a\u000b&\u0007\u000b\u0005\u0011\u0001\u0012A&\u0014\u0005)c\u0005CA'Q\u001b\u0005q%\"A(\u0002\u000bM\u001c\u0017\r\\1\n\u0005Es%AB!osJ+g\rC\u0003)\u0015\u0012\u00051\u000bF\u0001J\u0011\u001d)&J1A\u0005\nY\u000ba\u0001\\8hO\u0016\u0014X#A,\u0011\u0005aSV\"A-\u000b\u0005]A\u0011BA.Z\u0005\u0019aunZ4fe\"1QL\u0013Q\u0001\n]\u000bq\u0001\\8hO\u0016\u0014\b\u0005")
public class DefaultSSLEngineProvider
implements SSLEngineProvider {
    private final ServerConfig serverConfig;
    private final SSLContext sslContext;

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public SSLEngine createSSLEngine() {
        return this.sslContext().createSSLEngine();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SSLContext createSSLContext(ApplicationProvider applicationProvider) {
        TrustManager[] trustManagerArray;
        KeyManagerFactory keyManagerFactory2;
        Config httpsConfig = this.serverConfig.configuration().underlying().getConfig("play.server.https");
        Config keyStoreConfig = httpsConfig.getConfig("keyStore");
        if (keyStoreConfig.hasPath("path")) {
            String path = keyStoreConfig.getString("path");
            KeyStore keyStore = KeyStore.getInstance(keyStoreConfig.getString("type"));
            char[] password = keyStoreConfig.getString("password").toCharArray();
            String algorithm = keyStoreConfig.hasPath("algorithm") ? keyStoreConfig.getString("algorithm") : KeyManagerFactory.getDefaultAlgorithm();
            File file = new File(path);
            if (!file.isFile()) {
                throw new Exception(new StringBuilder().append((Object)"Unable to find HTTPS keystore at \"").append((Object)file.getAbsolutePath()).append((Object)"\"").toString());
            }
            FileInputStream in = new FileInputStream(file);
            try {
                keyStore.load(in, password);
                DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().debug((Function0)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Using HTTPS keystore at ").append((Object)this.file$1.getAbsolutePath()).toString();
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                kmf.init(keyStore, password);
                keyManagerFactory2 = kmf;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new Exception(new StringBuilder().append((Object)"Error loading HTTPS keystore from ").append((Object)file.getAbsolutePath()).toString(), e);
                }
                catch (Throwable throwable3) {
                    void var10_9;
                    PlayIO$.MODULE$.closeQuietly((Closeable)var10_9);
                    throw throwable3;
                }
            }
            PlayIO$.MODULE$.closeQuietly((Closeable)in);
        } else {
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().warn((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using generated key with self signed certificate for HTTPS. This should not be used in production.";
                }
            });
            keyManagerFactory2 = FakeKeyStore$.MODULE$.keyManagerFactory(this.serverConfig.rootDir());
        }
        KeyManagerFactory keyManagerFactory3 = keyManagerFactory2;
        Config trustStoreConfig = httpsConfig.getConfig("trustStore");
        if (trustStoreConfig.getBoolean("noCaVerification")) {
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().warn((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "HTTPS configured with no client side CA verification. Requires http://webid.info/ for client certificate verification.";
                }
            });
            trustManagerArray = (TrustManager[])((Object[])new TrustManager[]{noCATrustManager$.MODULE$});
        } else {
            DefaultSSLEngineProvider$.MODULE$.play$core$server$ssl$DefaultSSLEngineProvider$$logger().debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Using default trust store for client side CA verification";
                }
            });
            trustManagerArray = null;
        }
        TrustManager[] tm = trustManagerArray;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory3.getKeyManagers(), tm, null);
        return sslContext;
    }

    public DefaultSSLEngineProvider(ServerConfig serverConfig, ApplicationProvider appProvider) {
        this.serverConfig = serverConfig;
        this.sslContext = this.createSSLContext(appProvider);
    }
}

