/*
 * Decompiled with CFR 0.152.
 */
package play.server;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import play.Mode;
import play.core.j.JavaModeConverter;
import play.core.server.JavaServerHelper;
import play.routing.Router;
import scala.Int;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class Server {
    private final play.core.server.Server server;

    public Server(play.core.server.Server server) {
        this.server = server;
    }

    public void stop() {
        this.server.stop();
    }

    public int httpPort() {
        if (this.server.httpPort().isDefined()) {
            return Int.unbox((Object)this.server.httpPort().get());
        }
        throw new IllegalStateException("Server has no HTTP port. Try starting it with \"new Server.Builder().http(<port num>)\"?");
    }

    public int httpsPort() {
        if (this.server.httpsPort().isDefined()) {
            return Int.unbox((Object)this.server.httpsPort().get());
        }
        throw new IllegalStateException("Server has no HTTPS port. Try starting it with \"new Server.Builder.https(<port num>)\"?");
    }

    public InetSocketAddress mainAddress() {
        return this.server.mainAddress();
    }

    public static Server forRouter(Router router) {
        return Server.forRouter(router, Mode.TEST, 0);
    }

    public static Server forRouter(Router router, Mode mode) {
        return Server.forRouter(router, mode, 0);
    }

    public static Server forRouter(Router router, int n) {
        return Server.forRouter(router, Mode.TEST, n);
    }

    public static Server forRouter(Router router, Mode mode, int n) {
        return new Builder().mode(mode).http(n).build(router);
    }

    public static class Builder {
        private Config _config = new Config(new HashMap<Protocol, Integer>(), Mode.TEST);

        public Builder http(int n) {
            return this._protocol(Protocol.HTTP, n);
        }

        public Builder https(int n) {
            return this._protocol(Protocol.HTTPS, n);
        }

        public Builder mode(Mode mode) {
            this._config = new Config(this._config.ports(), mode);
            return this;
        }

        public Server build(Router router) {
            Config config = this._buildConfig();
            return new Server(JavaServerHelper.forRouter(router.asScala(), JavaModeConverter.asScalaMode((Mode)config.mode()), (Option<Integer>)OptionConverters.toScala(config.maybeHttpPort()), (Option<Integer>)OptionConverters.toScala(config.maybeHttpsPort())));
        }

        private Config _buildConfig() {
            Builder builder = this;
            if (this._config.ports().isEmpty()) {
                builder = this._protocol(Protocol.HTTP, 0);
            }
            return builder._config;
        }

        private Builder _protocol(Protocol protocol, int n) {
            HashMap<Protocol, Integer> hashMap = new HashMap<Protocol, Integer>();
            hashMap.putAll(this._config.ports());
            hashMap.put(protocol, n);
            this._config = new Config(hashMap, this._config.mode());
            return this;
        }
    }

    private static class Config {
        private final Map<Protocol, Integer> _ports;
        private final Mode _mode;

        Config(Map<Protocol, Integer> map, Mode mode) {
            this._ports = map;
            this._mode = mode;
        }

        public Optional<Integer> maybeHttpPort() {
            return Optional.ofNullable(this._ports.get((Object)Protocol.HTTP));
        }

        public Optional<Integer> maybeHttpsPort() {
            return Optional.ofNullable(this._ports.get((Object)Protocol.HTTPS));
        }

        public Map<Protocol, Integer> ports() {
            return this._ports;
        }

        public Mode mode() {
            return this._mode;
        }
    }

    public static enum Protocol {
        HTTP,
        HTTPS;

    }
}

