/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.Attributes;
import java.util.Vector;

public class Vertex
implements Comparable {
    private final Vector _heads = new Vector();
    private final Vector _tails = new Vector();
    private final Attributes _attributes;
    private boolean _visited;

    public Vertex(Attributes attributes) {
        this._attributes = attributes;
    }

    public Attributes getAttributes() {
        return this._attributes;
    }

    public int getNumberOfOutgoingArcs() {
        return this._heads.size();
    }

    public Vertex getHeadVertex(int index) {
        return (Vertex)this._heads.elementAt(index);
    }

    public void addOutgoingArcTo(Vertex headVertex) {
        if (!this._heads.contains(headVertex)) {
            this._heads.addElement(headVertex);
            headVertex.addIncomingArcTo(this);
        }
    }

    public int getNumberOfIncomingArcs() {
        return this._tails.size();
    }

    public Vertex getTailVertex(int index) {
        return (Vertex)this._tails.elementAt(index);
    }

    public void addIncomingArcTo(Vertex tailVertex) {
        if (!this._tails.contains(tailVertex)) {
            this._tails.addElement(tailVertex);
            tailVertex.addOutgoingArcTo(this);
        }
    }

    public void reset() {
        this._visited = false;
    }

    public void visit() {
        this._visited = true;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getAttributes() == null ? super.toString() : this.getAttributes().toString()).append(": ").append(this.getNumberOfIncomingArcs()).append(" incoming arc(s), ").append(this.getNumberOfOutgoingArcs()).append(" outgoing arc(s).");
        return new String(result);
    }

    public int compareTo(Object object) {
        int result = 1;
        if (object instanceof Vertex && this._attributes != null) {
            result = this._attributes.compareTo(((Vertex)object)._attributes);
        }
        return result;
    }
}

