/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.BasicURLHandler;
import org.apache.ivy.util.url.URLHandler;

public final class URLHandlerRegistry {
    private static URLHandler defaultHandler = new BasicURLHandler();

    private URLHandlerRegistry() {
    }

    public static URLHandler getDefault() {
        return defaultHandler;
    }

    public static void setDefault(URLHandler uRLHandler) {
        defaultHandler = uRLHandler;
    }

    public static URLHandler getHttp() {
        try {
            Class.forName("org.apache.commons.httpclient.HttpClient");
            Class.forName("org.apache.commons.httpclient.params.HttpClientParams");
            Class<?> clazz = Class.forName("org.apache.ivy.util.url.HttpClientHandler");
            Message.verbose("jakarta commons httpclient detected: using it for http downloading");
            return (URLHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Message.verbose("jakarta commons httpclient not found: using jdk url handling");
            return new BasicURLHandler();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Message.verbose("error occurred while loading jakarta commons httpclient: " + noClassDefFoundError.getMessage());
            Message.verbose("Using jdk url handling instead.");
            return new BasicURLHandler();
        }
        catch (InstantiationException instantiationException) {
            Message.verbose("couldn't instantiate HttpClientHandler: using jdk url handling");
            return new BasicURLHandler();
        }
        catch (IllegalAccessException illegalAccessException) {
            Message.verbose("couldn't instantiate HttpClientHandler: using jdk url handling");
            return new BasicURLHandler();
        }
    }
}

