/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import org.parboiled.common.StringUtils;
import org.pegdown.Printer;
import org.pegdown.VerbatimSerializer;
import org.pegdown.ast.VerbatimNode;

public class DefaultVerbatimSerializer
implements VerbatimSerializer {
    public static final DefaultVerbatimSerializer INSTANCE = new DefaultVerbatimSerializer();

    public void serialize(VerbatimNode node, Printer printer) {
        printer.println().print("<pre><code");
        if (!StringUtils.isEmpty((String)node.getType())) {
            this.printAttribute(printer, "class", node.getType());
        }
        printer.print(">");
        String text = node.getText();
        while (text.charAt(0) == '\n') {
            printer.print("<br/>");
            text = text.substring(1);
        }
        printer.printEncoded(text);
        printer.print("</code></pre>");
    }

    private void printAttribute(Printer printer, String name, String value) {
        printer.print(' ').print(name).print('=').print('\"').print(value).print('\"');
    }
}

