/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import java.io.NotSerializableException;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r%t!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d)AAF\u0005\u0001/\ty1\t\\1tgN+'/[1mSj,'\u000f\u0005\u0003\u000e1ii\u0013BA\r\u000f\u0005\u0019!V\u000f\u001d7feA\u00121\u0004\n\t\u00049}\u0011cBA\u0007\u001e\u0013\tqb\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0005\u0012Qa\u00117bgNT!A\b\b\u0011\u0005\r\"C\u0002\u0001\u0003\nKU\t\t\u0011!A\u0003\u0002\u0019\u00121a\u0018\u00132#\t9#\u0006\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u001d>$\b.\u001b8h!\ti1&\u0003\u0002-\u001d\t\u0019\u0011I\\=\u0011\u0005!q\u0013BA\u0018\u0003\u0005)\u0019VM]5bY&TXM\u001d\u0005\tc%\u0011\r\u0011\"\u0001\u0005e\u0005Y2-\u001e:sK:$HK]1ogB|'\u000f^%oM>\u0014X.\u0019;j_:,\u0012a\r\t\u0004i]JT\"A\u001b\u000b\u0005Yr\u0011\u0001B;uS2L!\u0001O\u001b\u0003\u001f\u0011Kh.Y7jGZ\u000b'/[1cY\u0016\u0004\"AO\u001e\u000e\u0003%1Q\u0001P\u0005C\tu\u00121\"\u00138g_Jl\u0017\r^5p]N!1\b\u0004 B!\tiq(\u0003\u0002A\u001d\t9\u0001K]8ek\u000e$\bCA\u0007C\u0013\t\u0019eB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005Fw\tU\r\u0011\"\u0001G\u0003\u001d\tG\r\u001a:fgN,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0012\tQ!Y2u_JL!\u0001T%\u0003\u000f\u0005#GM]3tg\"Aaj\u000fB\tB\u0003%q)\u0001\u0005bI\u0012\u0014Xm]:!\u0011!\u00016H!f\u0001\n\u0003\t\u0016AB:zgR,W.F\u0001S!\tA5+\u0003\u0002U\u0013\nY\u0011i\u0019;peNK8\u000f^3n\u0011!16H!E!\u0002\u0013\u0011\u0016aB:zgR,W\u000e\t\u0005\u0006'm\"\t\u0001\u0017\u000b\u0004seS\u0006\"B#X\u0001\u00049\u0005\"\u0002)X\u0001\u0004\u0011\u0006b\u0002/<\u0003\u0003%\t!X\u0001\u0005G>\u0004\u0018\u0010F\u0002:=~Cq!R.\u0011\u0002\u0003\u0007q\tC\u0004Q7B\u0005\t\u0019\u0001*\t\u000f\u0005\\\u0014\u0013!C\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A2+\u0005\u001d#7&A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017!C;oG\",7m[3e\u0015\tQg\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001\\4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004owE\u0005I\u0011A8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\t\u0001O\u000b\u0002SI\"9!oOA\u0001\n\u0003\u001a\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070F\u0001u!\t)(0D\u0001w\u0015\t9\b0\u0001\u0003mC:<'\"A=\u0002\t)\fg/Y\u0005\u0003wZ\u0014aa\u0015;sS:<\u0007bB?<\u0003\u0003%\tA`\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002\u007fB\u0019Q\"!\u0001\n\u0007\u0005\raBA\u0002J]RD\u0011\"a\u0002<\u0003\u0003%\t!!\u0003\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!&a\u0003\t\u0013\u00055\u0011QAA\u0001\u0002\u0004y\u0018a\u0001=%c!I\u0011\u0011C\u001e\u0002\u0002\u0013\u0005\u00131C\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0003\t\u0006\u0003/\tiBK\u0007\u0003\u00033Q1!a\u0007\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003?\tIB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019cOA\u0001\n\u0003\t)#\u0001\u0005dC:,\u0015/^1m)\u0011\t9#!\f\u0011\u00075\tI#C\u0002\u0002,9\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u000e\u0005\u0005\u0012\u0011!a\u0001U!I\u0011\u0011G\u001e\u0002\u0002\u0013\u0005\u00131G\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0010C\u0005\u00028m\n\t\u0011\"\u0011\u0002:\u0005AAo\\*ue&tw\rF\u0001u\u0011%\tidOA\u0001\n\u0003\ny$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003O\t\t\u0005C\u0005\u0002\u000e\u0005m\u0012\u0011!a\u0001U!9\u0011QI\u0005!\u0002\u0013\u0019\u0014\u0001H2veJ,g\u000e\u001e+sC:\u001c\bo\u001c:u\u0013:4wN]7bi&|g\u000e\t\u0004\u0007\u0003\u0013J\u0001!a\u0013\u0003\u0011M+G\u000f^5oON\u001c2!a\u0012\r\u0011-\ty%a\u0012\u0003\u0006\u0004%\t!!\u0015\u0002\r\r|gNZ5h+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005\u0005TBAA,\u0015\u0011\ty%!\u0017\u000b\t\u0005m\u0013QL\u0001\tif\u0004Xm]1gK*\u0011\u0011qL\u0001\u0004G>l\u0017\u0002BA2\u0003/\u0012aaQ8oM&<\u0007bCA4\u0003\u000f\u0012\t\u0011)A\u0005\u0003'\nqaY8oM&<\u0007\u0005C\u0004\u0014\u0003\u000f\"\t!a\u001b\u0015\t\u00055\u0014q\u000e\t\u0004u\u0005\u001d\u0003\u0002CA(\u0003S\u0002\r!a\u0015\t\u0015\u0005M\u0014q\tb\u0001\n\u0003\t)(A\u0006TKJL\u0017\r\\5{KJ\u001cXCAA<!\u001da\u0012\u0011PA?\u0003{J1!a\u001f\"\u0005\ri\u0015\r\u001d\t\u00049\u0005}\u0014BA>\"\u0011%\t\u0019)a\u0012!\u0002\u0013\t9(\u0001\u0007TKJL\u0017\r\\5{KJ\u001c\b\u0005\u0003\u0006\u0002\b\u0006\u001d#\u0019!C\u0001\u0003k\nQcU3sS\u0006d\u0017N_1uS>t')\u001b8eS:<7\u000fC\u0005\u0002\f\u0006\u001d\u0003\u0015!\u0003\u0002x\u000512+\u001a:jC2L'0\u0019;j_:\u0014\u0015N\u001c3j]\u001e\u001c\b\u0005\u0003\u0005\u0002\u0010\u0006\u001dCQBAI\u0003-\u0019wN\u001c4jOR{W*\u00199\u0015\t\u0005]\u00141\u0013\u0005\t\u0003+\u000bi\t1\u0001\u0002~\u0005!\u0001/\u0019;i\u000f)\tI*CA\u0001\u0012\u0003!\u00111T\u0001\f\u0013:4wN]7bi&|g\u000eE\u0002;\u0003;3\u0011\u0002P\u0005\u0002\u0002#\u0005A!a(\u0014\u000b\u0005u\u0015\u0011U!\u0011\u000f\u0005\r\u0016\u0011V$Ss5\u0011\u0011Q\u0015\u0006\u0004\u0003Os\u0011a\u0002:v]RLW.Z\u0005\u0005\u0003W\u000b)KA\tBEN$(/Y2u\rVt7\r^5p]JBqaEAO\t\u0003\ty\u000b\u0006\u0002\u0002\u001c\"Q\u0011qGAO\u0003\u0003%)%!\u000f\t\u0015\u0005U\u0016QTA\u0001\n\u0003\u000b9,A\u0003baBd\u0017\u0010F\u0003:\u0003s\u000bY\f\u0003\u0004F\u0003g\u0003\ra\u0012\u0005\u0007!\u0006M\u0006\u0019\u0001*\t\u0015\u0005}\u0016QTA\u0001\n\u0003\u000b\t-A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u00171\u001a\t\u0006\u001b\u0005\u0015\u0017\u0011Z\u0005\u0004\u0003\u000ft!AB(qi&|g\u000e\u0005\u0003\u000e1\u001d\u0013\u0006\"CAg\u0003{\u000b\t\u00111\u0001:\u0003\rAH\u0005\r\u0005\u000b\u0003#\fi*!A\u0005\n\u0005M\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!6\u0011\u0007U\f9.C\u0002\u0002ZZ\u0014aa\u00142kK\u000e$\bbBAo\u0013\u0011\u0005\u0011q\\\u0001\u0014g\u0016\u0014\u0018.\u00197ju\u0016$\u0017i\u0019;peB\u000bG\u000f\u001b\u000b\u0005\u0003{\n\t\u000f\u0003\u0005\u0002d\u0006m\u0007\u0019AAs\u0003!\t7\r^8s%\u00164\u0007c\u0001%\u0002h&\u0019\u0011\u0011^%\u0003\u0011\u0005\u001bGo\u001c:SK\u001a4QA\u0003\u0002\u0001\u0003[\u001cR!a;\r\u0003_\u00042\u0001SAy\u0013\r\t\u00190\u0013\u0002\n\u000bb$XM\\:j_:D!\u0002UAv\u0005\u000b\u0007I\u0011AA|+\t\tI\u0010E\u0002I\u0003wL1!!@J\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011)1\u00161\u001eB\u0001B\u0003%\u0011\u0011 \u0005\b'\u0005-H\u0011\u0001B\u0002)\u0011\u0011)Aa\u0002\u0011\u0007!\tY\u000fC\u0004Q\u0005\u0003\u0001\r!!?\t\u0015\t-\u00111\u001eb\u0001\n\u0003\u0011i!\u0001\u0005tKR$\u0018N\\4t+\t\u0011y\u0001\u0005\u0003\u0003\u0012\u0005\u001dcB\u0001\u0005\u0001\u0011%\u0011)\"a;!\u0002\u0013\u0011y!A\u0005tKR$\u0018N\\4tA!Q!\u0011DAv\u0005\u0004%\tAa\u0007\u0002\u00071|w-\u0006\u0002\u0003\u001eA!!q\u0004B\u0013\u001b\t\u0011\tCC\u0002\u0003$\u0011\tQ!\u001a<f]RLAAa\n\u0003\"\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\"\u0003B\u0016\u0003W\u0004\u000b\u0011\u0002B\u000f\u0003\u0011awn\u001a\u0011\t\u0011\t=\u00121\u001eC\u0001\u0005c\t\u0011b]3sS\u0006d\u0017N_3\u0015\t\tM\"Q\t\t\u0006i\tU\"\u0011H\u0005\u0004\u0005o)$a\u0001+ssB)QBa\u000f\u0003@%\u0019!Q\b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\u0011\t%C\u0002\u0003D9\u0011AAQ=uK\"9!q\tB\u0017\u0001\u0004a\u0011!A8\t\u0011\t-\u00131\u001eC\u0001\u0005\u001b\n1\u0002Z3tKJL\u0017\r\\5{KV!!q\nB+)!\u0011\tF!\u0017\u0003^\t\u0005\u0004#\u0002\u001b\u00036\tM\u0003cA\u0012\u0003V\u00119!q\u000bB%\u0005\u00041#!\u0001+\t\u0011\tm#\u0011\na\u0001\u0005s\tQAY=uKNDqAa\u0018\u0003J\u0001\u0007q0\u0001\u0007tKJL\u0017\r\\5{KJLE\r\u0003\u0005\u0003d\t%\u0003\u0019\u0001B3\u0003\u0015\u0019G.\u0019>{!\u0015i\u0011Q\u0019B4a\u0011\u0011IG!\u001c\u0011\tqy\"1\u000e\t\u0004G\t5D\u0001\u0004B8\u0005c\n\t\u0011!A\u0003\u0002\t\u0005%aA0%e!A!1\rB%\u0001\u0004\u0011\u0019\bE\u0003\u000e\u0003\u000b\u0014)\b\r\u0003\u0003x\tm\u0004\u0003\u0002\u000f \u0005s\u00022a\tB>\t1\u0011yG!\u001d\u0002\u0002\u0003\u0005)\u0011\u0001B?#\r9#q\u0010\t\u0004G\tU\u0013cA\u0014\u0003T!A!1JAv\t\u0003\u0011)\t\u0006\u0005\u0003\b\n%%1\u0012BG!\u0011!$Q\u0007\u0007\t\u0011\tm#1\u0011a\u0001\u0005sAqAa\u0018\u0003\u0004\u0002\u0007q\u0010\u0003\u0005\u0003\u0010\n\r\u0005\u0019AA?\u0003!i\u0017M\\5gKN$\b\u0002\u0003B&\u0003W$\tAa%\u0016\t\tU%1\u0014\u000b\u0007\u0005/\u0013iJa(\u0011\u000bQ\u0012)D!'\u0011\u0007\r\u0012Y\nB\u0004\u0003X\tE%\u0019\u0001\u0014\t\u0011\tm#\u0011\u0013a\u0001\u0005sA\u0001Ba\u0019\u0003\u0012\u0002\u0007!\u0011\u0015\t\u00059}\u0011I\n\u0003\u0005\u0003&\u0006-H\u0011\u0001BT\u0003E1\u0017N\u001c3TKJL\u0017\r\\5{KJ4uN\u001d\u000b\u0004[\t%\u0006b\u0002B$\u0005G\u0003\r\u0001\u0004\u0005\t\u0005[\u000bY\u000f\"\u0001\u00030\u0006i1/\u001a:jC2L'0\u001a:G_J$2!\fBY\u0011!\u0011\u0019Ga+A\u0002\tM\u0006\u0007\u0002B[\u0005s\u0003B\u0001H\u0010\u00038B\u00191E!/\u0005\u0017\tm&\u0011WA\u0001\u0002\u0003\u0015\tA\n\u0002\u0004?\u0012\u001a\u0004\u0002\u0003B`\u0003W$\tA!1\u0002\u0019M,'/[1mSj,'o\u00144\u0015\t\t\r'Q\u0019\t\u0005i\tUR\u0006\u0003\u0005\u0003H\nu\u0006\u0019AA?\u00035\u0019XM]5bY&TXM\u001d$R\u001d\"Q!1ZAv\u0005\u0004%IA!4\u0002\u0017M,'/[1mSj,'o]\u000b\u0003\u0005\u001f\u0004b\u0001HA=\u0003{j\u0003\"\u0003Bj\u0003W\u0004\u000b\u0011\u0002Bh\u00031\u0019XM]5bY&TXM]:!\u0011-\u00119.a;C\u0002\u0013\u0005AA!7\u0002\u0011\tLg\u000eZ5oON,\"Aa7\u0011\r\tu'1\u001dBt\u001b\t\u0011yN\u0003\u0003\u0003b\u0006e\u0011!C5n[V$\u0018M\u00197f\u0013\u0011\u0011)Oa8\u0003\u0007M+\u0017\u000fE\u0002\u0003\u0012UA\u0011Ba;\u0002l\u0002\u0006IAa7\u0002\u0013\tLg\u000eZ5oON\u0004\u0003\u0002\u0003Bx\u0003W$IA!=\u0002'\rDWmY6H_><G.\u001a)s_R|'-\u001e4\u0015\t\u0005\u001d\"1\u001f\u0005\t\u0005k\u0014i\u000f1\u0001\u0002~\u0005I1\r\\1tg:\u000bW.\u001a\u0005\t\u0005s\fY\u000f\"\u0003\u0003|\u0006!1o\u001c:u)\u0011\u0011YN!@\t\u0011\t}(q\u001fa\u0001\u0007\u0003\t!!\u001b8\u0011\r\r\r11\u0003Bt\u001d\u0011\u0019)aa\u0004\u000f\t\r\u001d1QB\u0007\u0003\u0007\u0013Q1aa\u0003\u0007\u0003\u0019a$o\\8u}%\tq\"C\u0002\u0004\u00129\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u0016\r]!\u0001C%uKJ\f'\r\\3\u000b\u0007\rEa\u0002\u0003\u0006\u0004\u001c\u0005-(\u0019!C\u0005\u0007;\tQb]3sS\u0006d\u0017N_3s\u001b\u0006\u0004XCAB\u0010!\u001d\u0019\tc!\u000b\u0004.5j!aa\t\u000b\t\r\u00152qE\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001cy\u0013\u0011\u0019Yca\t\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\r\u0003\u00040\rM\u0002\u0003\u0002\u000f \u0007c\u00012aIB\u001a\t-\u0019)da\u000e\u0002\u0002\u0003\u0005)\u0011\u0001\u0014\u0003\u0007}#S\u0007C\u0005\u0004:\u0005-\b\u0015!\u0003\u0004<\u0005q1/\u001a:jC2L'0\u001a:NCB\u0004\u0003cBB\u0011\u0007S\u0019i$\f\u0019\u0005\u0007\u007f\u0019\u0019\u0005\u0005\u0003\u001d?\r\u0005\u0003cA\u0012\u0004D\u0011Y1QGB\u001c\u0003\u0003\u0005\tQ!\u0001'\u0011)\u00199%a;C\u0002\u0013\u00051\u0011J\u0001\u0015g\u0016\u0014\u0018.\u00197ju\u0016\u0014()_%eK:$\u0018\u000e^=\u0016\u0005\r-\u0003#\u0002\u000f\u0002z}l\u0003\"CB(\u0003W\u0004\u000b\u0011BB&\u0003U\u0019XM]5bY&TXM\u001d\"z\u0013\u0012,g\u000e^5us\u0002B\u0001ba\u0015\u0002l\u0012%1QK\u0001\u001eg\"|W\u000f\u001c3XCJt\u0017IY8vi*\u000bg/Y*fe&\fG.\u001b>feR1\u0011qEB,\u0007KB\u0001b!\u0017\u0004R\u0001\u000711L\u0001\u0010g\u0016\u0014\u0018.\u00197ju\u0016$7\t\\1tgB\"1QLB1!\u0011arda\u0018\u0011\u0007\r\u001a\t\u0007B\u0006\u0004d\r]\u0013\u0011!A\u0001\u0006\u00031#aA0%o!91qMB)\u0001\u0004i\u0013AC:fe&\fG.\u001b>fe\u0002")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final LoggingAdapter log;
    private final Map<String, Serializer> akka$serialization$Serialization$$serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public Try<byte[]> serialize(Object o) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, o){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final Object o$1;

            public final byte[] apply() {
                return this.$outer.findSerializerFor(this.o$1).toBinary(this.o$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.o$1 = o$1;
            }
        });
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, serializerId, clazz){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$3;
            private final int serializerId$2;
            private final Option clazz$2;

            public final T apply() {
                Serializer serializer;
                try {
                    serializer = (Serializer)this.$outer.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)this.serializerId$2));
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new NotSerializableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.serializerId$2)}))).append((Object)"akka.actor.serializers is not in synch between the two systems.").toString());
                }
                return (T)serializer.fromBinary(this.bytes$3, this.clazz$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$3 = bytes$3;
                this.serializerId$2 = serializerId$2;
                this.clazz$2 = clazz$2;
            }
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, serializerId, manifest){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$2;
            private final int serializerId$1;
            private final String manifest$1;

            public final Object apply() {
                Try<Class<T>> try_;
                block10: {
                    Object object;
                    block7: {
                        Object object2;
                        block9: {
                            Object object3;
                            Serializer serializer;
                            block8: {
                                block6: {
                                    try {
                                        Serializer serializer2;
                                        serializer = serializer2 = (Serializer)this.$outer.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)this.serializerId$1));
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        throw new NotSerializableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.serializerId$1)}))).append((Object)"akka.actor.serializers is not in synch between the two systems.").toString());
                                    }
                                    if (!(serializer instanceof SerializerWithStringManifest)) break block6;
                                    SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer;
                                    object = serializerWithStringManifest.fromBinary(this.bytes$2, this.manifest$1);
                                    break block7;
                                }
                                String string = this.manifest$1;
                                String string2 = "";
                                if (string != null ? !string.equals(string2) : string2 != null) break block8;
                                object2 = serializer.fromBinary(this.bytes$2, (Option<Class<?>>)None$.MODULE$);
                                break block9;
                            }
                            try_ = this.$outer.system().dynamicAccess().getClassFor(this.manifest$1, ClassTag$.MODULE$.AnyRef());
                            if (!(try_ instanceof Success)) break block10;
                            Success success = (Success)try_;
                            Class classManifest = (Class)success.value();
                            object2 = object3 = serializer.fromBinary(this.bytes$2, (Option<Class<?>>)new Some((Object)classManifest));
                        }
                        object = object2;
                    }
                    return object;
                }
                if (try_ instanceof Failure) {
                    throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find manifest class [", "] for serializer with id [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.manifest$1, BoxesRunTime.boxToInteger((int)this.serializerId$1)})));
                }
                throw new MatchError(try_);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$2 = bytes$2;
                this.serializerId$1 = serializerId$1;
                this.manifest$1 = manifest$1;
            }
        });
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, bytes, clazz){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final byte[] bytes$1;
            private final Class clazz$1;

            public final T apply() {
                return (T)this.$outer.serializerFor(this.clazz$1).fromBinary(this.bytes$1, (Option<Class<?>>)new Some((Object)this.clazz$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bytes$1 = bytes$1;
                this.clazz$1 = clazz$1;
            }
        });
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            Seq seq = (Seq)this.bindings().filter((Function1)new Serializable(this, clazz){
                public static final long serialVersionUID = 0L;
                private final Class clazz$3;

                public final boolean apply(Tuple2<Class<?>, Serializer> x$3) {
                    return ((Class)x$3._1()).isAssignableFrom(this.clazz$3);
                }
                {
                    this.clazz$3 = clazz$3;
                }
            });
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringOps(Predef$.MODULE$.augmentString("No configured serialization-bindings for class [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()})));
            }
            if (!this.unique$1((scala.collection.immutable.Seq)seq)) {
                this.log().warning(new StringBuilder().append((Object)"Multiple serializers found for ").append(clazz).append((Object)", choosing first: ").append((Object)seq).toString());
            }
            Serializer ser = serializer4 = (Serializer)((Tuple2)seq.apply(0))._2();
            Serializer serializer5 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer5 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this.log().warning("Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", clazz.getName());
                }
                this.log().debug("Using serializer[{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer5;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    public Try<Serializer> serializerOf(String serializerFQN) {
        return this.system().dynamicAccess().createInstanceFor(serializerFQN, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new Serializable(this, serializerFQN){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String serializerFQN$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.serializerFQN$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : function1.apply(x1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serializerFQN$1 = serializerFQN$1;
            }
        });
    }

    public Map<String, Serializer> akka$serialization$Serialization$$serializers() {
        return this.akka$serialization$Serialization$$serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    public boolean akka$serialization$Serialization$$checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (scala.collection.immutable.Seq)((TraversableLike)in.$div$colon((Object)arrayBuffer, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<Tuple2<Class<?>, Serializer>> apply(ArrayBuffer<Tuple2<Class<?>, Serializer>> buf, Tuple2<Class<?>, Serializer> ca) {
                int n = buf.indexWhere((Function1)new Serializable(this, ca){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 ca$1;

                    public final boolean apply(Tuple2<Class<?>, Serializer> x$8) {
                        return ((Class)x$8._1()).isAssignableFrom((Class)this.ca$1._1());
                    }
                    {
                        this.ca$1 = ca$1;
                    }
                });
                switch (n) {
                    default: {
                        buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                        break;
                    }
                    case -1: {
                        buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    }
                }
                return buf;
            }
        })).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage") && serializer instanceof JavaSerializer && !serializedClass.getName().startsWith("akka.");
    }

    private final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Seq possibilities$1;

            public final boolean apply(Tuple2<Class<?>, Serializer> x$1) {
                return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)this.possibilities$1.apply(0))._1());
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        }) || possibilities.forall((Function1)new Serializable(this, possibilities){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Seq possibilities$1;

            public final boolean apply(Tuple2<Class<?>, Serializer> x$2) {
                return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)this.possibilities$1.apply(0))._2());
            }
            {
                this.possibilities$1 = possibilities$1;
            }
        });
    }

    public Serialization(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.log = Logging$.MODULE$.apply(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.akka$serialization$Serialization$$serializers = (Map)this.settings().Serializers().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k == null) return false;
                if (v == null) return false;
                return true;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final Tuple2<String, Serializer> apply(Tuple2<String, String> x$4) {
                Tuple2<String, String> tuple2 = x$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    if (k != null) {
                        String string = k;
                        if (v != null) {
                            String string2 = v;
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.$outer.serializerOf(string2).get());
                            return tuple22;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
        this.bindings = (scala.collection.immutable.Seq)this.sort((Iterable)this.settings().SerializationBindings().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<String, String> check$ifrefutable$2) {
                Tuple2<String, String> tuple2 = check$ifrefutable$2;
                if (tuple2 == null) return false;
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k == null) return false;
                if (v == null) return false;
                return true;
            }
        }).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final boolean apply(Tuple2<String, String> x$5) {
                Tuple2<String, String> tuple2 = x$5;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    if (k != null) {
                        String string = k;
                        if (v != null) {
                            String string2;
                            String string3 = string2 = v;
                            String string4 = "none";
                            boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && this.$outer.akka$serialization$Serialization$$checkGoogleProtobuf(string);
                            return bl;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final Tuple2<Class<Object>, Serializer> apply(Tuple2<String, String> x$6) {
                Tuple2<String, String> tuple2 = x$6;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    if (k != null) {
                        String string = k;
                        if (v != null) {
                            String string2 = v;
                            Tuple2 tuple22 = new Tuple2(this.$outer.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.$outer.akka$serialization$Serialization$$serializers().apply((Object)string2));
                            return tuple22;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom())).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ConcurrentHashMap<Class<?>, Serializer> apply(ConcurrentHashMap<Class<?>, Serializer> x0$2, Tuple2<Class<?>, Serializer> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    ConcurrentHashMap map = (ConcurrentHashMap)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Class c = (Class)tuple22._1();
                        Serializer s = (Serializer)tuple22._2();
                        map.put(c, s);
                        ConcurrentHashMap concurrentHashMap = map;
                        return concurrentHashMap;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        this.serializerByIdentity = (Map)((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus(this.akka$serialization$Serialization$$serializers(), Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Serializer> apply(Tuple2<Object, Serializer> x0$3) {
                Tuple2<Object, Serializer> tuple2 = x0$3;
                if (tuple2 != null) {
                    Serializer v = (Serializer)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(String path) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.config().getConfig(path).root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(Tuple2<String, Object> x0$1) {
                    Tuple2<String, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        Object v = tuple2._2();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap("akka.actor.serializers");
            this.SerializationBindings = this.configToMap("akka.actor.serialization-bindings");
        }
    }

    public static final class Information
    implements Product,
    Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.system();
                    break;
                }
                case 0: {
                    object = this.address();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.class.$init$((Product)this);
        }
    }
}

