/*
 * Decompiled with CFR 0.152.
 */
package play.api.db;

import com.typesafe.config.Config;
import javax.sql.DataSource;
import org.jdbcdslog.LogSqlDataSource;
import play.api.Environment;
import play.api.Mode$;
import play.api.db.BoneConnectionPool;
import play.api.db.ConnectionPool;
import play.api.db.HikariCPConnectionPool;
import play.api.inject.Injector;
import play.utils.Reflect$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.util.matching.Regex;

public final class ConnectionPool$ {
    public static final ConnectionPool$ MODULE$;
    private final Regex PostgresFullUrl;
    private final Regex MysqlFullUrl;
    private final Regex MysqlCustomProperties;
    private final Regex H2DefaultUrl;

    static {
        new ConnectionPool$();
    }

    public ConnectionPool fromConfig(String config, Injector injector, Environment environment, ConnectionPool connectionPool) {
        String string = config;
        ConnectionPool connectionPool2 = "default".equals(string) ? connectionPool : ("bonecp".equals(string) ? new BoneConnectionPool(environment) : ("hikaricp".equals(string) ? new HikariCPConnectionPool(environment) : (ConnectionPool)injector.instanceOf(Reflect$.MODULE$.getClass(string, environment.classLoader(), ClassTag$.MODULE$.apply(ConnectionPool.class)))));
        return connectionPool2;
    }

    private Regex PostgresFullUrl() {
        return this.PostgresFullUrl;
    }

    private Regex MysqlFullUrl() {
        return this.MysqlFullUrl;
    }

    private Regex MysqlCustomProperties() {
        return this.MysqlCustomProperties;
    }

    private Regex H2DefaultUrl() {
        return this.H2DefaultUrl;
    }

    public Tuple2<Option<String>, Option<Tuple2<String, String>>> extractUrl(Option<String> maybeUrl, Enumeration.Value mode) {
        Option<String> option;
        block7: {
            Tuple2 tuple2;
            block3: {
                block6: {
                    Some some;
                    boolean bl;
                    block5: {
                        block4: {
                            block2: {
                                bl = false;
                                some = null;
                                option = maybeUrl;
                                if (!(option instanceof Some)) break block2;
                                bl = true;
                                some = (Some)option;
                                CharSequence charSequence = (CharSequence)some.x();
                                Option option2 = this.PostgresFullUrl().unapplySeq(charSequence);
                                if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(4) != 0) break block2;
                                String username = (String)((LinearSeqOptimized)option2.get()).apply(0);
                                String password = (String)((LinearSeqOptimized)option2.get()).apply(1);
                                String host = (String)((LinearSeqOptimized)option2.get()).apply(2);
                                String dbname = (String)((LinearSeqOptimized)option2.get()).apply(3);
                                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:postgresql://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, dbname})))), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
                                break block3;
                            }
                            if (!bl) break block4;
                            CharSequence url = (CharSequence)some.x();
                            Option option3 = this.MysqlFullUrl().unapplySeq(url);
                            if (option3.isEmpty() || option3.get() == null || ((LinearSeqOptimized)option3.get()).lengthCompare(4) != 0) break block4;
                            String username = (String)((LinearSeqOptimized)option3.get()).apply(0);
                            String password = (String)((LinearSeqOptimized)option3.get()).apply(1);
                            String host = (String)((LinearSeqOptimized)option3.get()).apply(2);
                            String dbname = (String)((LinearSeqOptimized)option3.get()).apply(3);
                            String defaultProperties = "?useUnicode=yes&characterEncoding=UTF-8&connectionCollation=utf8_general_ci";
                            String addDefaultPropertiesIfNeeded = (String)this.MysqlCustomProperties().findFirstMatchIn(url).map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Regex.Match x$1) {
                                    return "";
                                }
                            }).getOrElse((Function0)new Serializable(defaultProperties){
                                public static final long serialVersionUID = 0L;
                                private final String defaultProperties$1;

                                public final String apply() {
                                    return this.defaultProperties$1;
                                }
                                {
                                    this.defaultProperties$1 = defaultProperties$1;
                                }
                            });
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"jdbc:mysql://", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, new StringBuilder().append((Object)dbname).append((Object)addDefaultPropertiesIfNeeded).toString()})))), (Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)username), (Object)password)));
                            break block3;
                        }
                        if (!bl) break block5;
                        CharSequence url = (CharSequence)some.x();
                        Option option4 = this.H2DefaultUrl().unapplySeq(url);
                        if (option4.isEmpty() || option4.get() == null || ((LinearSeqOptimized)option4.get()).lengthCompare(0) != 0 || ((String)url).contains("DB_CLOSE_DELAY")) break block5;
                        Enumeration.Value value = mode;
                        Enumeration.Value value2 = Mode$.MODULE$.Dev();
                        if (value != null ? !value.equals(value2) : value2 != null) break block5;
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ";DB_CLOSE_DELAY=-1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})))), (Object)None$.MODULE$);
                        break block3;
                    }
                    if (!bl) break block6;
                    String url = (String)some.x();
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Some((Object)url)), (Object)None$.MODULE$);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)None$.MODULE$);
            }
            return tuple2;
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    public DataSource wrapToLogSql(DataSource dataSource, Config configuration) {
        DataSource dataSource2;
        if (configuration.getBoolean("logSql")) {
            void var3_3;
            LogSqlDataSource proxyDataSource = new LogSqlDataSource();
            proxyDataSource.setTargetDSDirect(dataSource);
            dataSource2 = var3_3;
        } else {
            dataSource2 = dataSource;
        }
        return dataSource2;
    }

    public DataSource unwrap(DataSource dataSource) {
        DataSource dataSource2;
        DataSource dataSource3 = dataSource;
        if (dataSource3 instanceof LogSqlDataSource) {
            LogSqlDataSource logSqlDataSource = (LogSqlDataSource)((Object)dataSource3);
            dataSource2 = logSqlDataSource.getTargetDatasource();
        } else {
            dataSource2 = dataSource;
        }
        return dataSource2;
    }

    private ConnectionPool$() {
        MODULE$ = this;
        this.PostgresFullUrl = new StringOps(Predef$.MODULE$.augmentString("^postgres://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$")).r();
        this.MysqlFullUrl = new StringOps(Predef$.MODULE$.augmentString("^mysql://([a-zA-Z0-9_]+):([^@]+)@([^/]+)/([^\\s]+)$")).r();
        this.MysqlCustomProperties = new StringOps(Predef$.MODULE$.augmentString(".*\\?(.*)")).r();
        this.H2DefaultUrl = new StringOps(Predef$.MODULE$.augmentString("^jdbc:h2:mem:.+")).r();
    }
}

