/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger$;
import play.api.Mode$;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.ContentTypeOf$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandler$class;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.routing.Router;
import play.core.SourceMapper;
import play.twirl.api.Html;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import views.html.defaultpages.badRequest$;
import views.html.defaultpages.devError$;
import views.html.defaultpages.devNotFound$;
import views.html.defaultpages.error$;
import views.html.defaultpages.notFound$;
import views.html.defaultpages.unauthorized$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001%\u0011q\u0003R3gCVdG\u000f\u0013;ua\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\u0005\r!\u0011\u0001\u00025uiBT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001A\u0003\t\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tIiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0006f]ZL'o\u001c8nK:$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005-)eN^5s_:lWM\u001c;\t\u0011m\u0001!\u0011!Q\u0001\nq\tQbY8oM&<WO]1uS>t\u0007CA\f\u001e\u0013\tqBAA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005a1o\\;sG\u0016l\u0015\r\u001d9feB\u00191B\t\u0013\n\u0005\rb!AB(qi&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\r\u0005!1m\u001c:f\u0013\tIcE\u0001\u0007T_V\u00148-Z'baB,'\u000f\u0003\u0005,\u0001\t\u0005I\u0015!\u0003-\u0003\u0019\u0011x.\u001e;feB\u00191\"L\u0018\n\u00059b!\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007-\u0011\u0003\u0007\u0005\u00022i5\t!G\u0003\u00024\t\u00059!o\\;uS:<\u0017BA\u001b3\u0005\u0019\u0011v.\u001e;fe\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"R!\u000f\u001e<yu\u0002\"!\u0005\u0001\t\u000bU1\u0004\u0019\u0001\f\t\u000bm1\u0004\u0019\u0001\u000f\t\u000f\u00012\u0004\u0013!a\u0001C!91F\u000eI\u0005\u0002\u0004a\u0003\"B\u001c\u0001\t\u0003yD#B\u001dA\u0003\n3\u0005\"B\u000b?\u0001\u00041\u0002\"B\u000e?\u0001\u0004a\u0002\"\u0002\u0011?\u0001\u0004\u0019\u0005CA\fE\u0013\t)EA\u0001\u000bPaRLwN\\1m'>,(oY3NCB\u0004XM\u001d\u0005\u0006Wy\u0002\ra\u0012\t\u0004\u00116\u0003T\"A%\u000b\u0005)[\u0015AB5oU\u0016\u001cGOC\u0001M\u0003\u0015Q\u0017M^1y\u0013\tq\u0015J\u0001\u0005Qe>4\u0018\u000eZ3sQ\tq\u0004\u000b\u0005\u0002I#&\u0011!+\u0013\u0002\u0007\u0013:TWm\u0019;\t\u000fQ\u0003!\u0019!C\u0005+\u0006Q\u0001\u000f\\1z\u000b\u0012LGo\u001c:\u0016\u0003Y\u00032a\u0003\u0012X!\tA6L\u0004\u0002\f3&\u0011!\fD\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[\u0019!1q\f\u0001Q\u0001\nY\u000b1\u0002\u001d7bs\u0016#\u0017\u000e^8sA!)\u0011\r\u0001C\u0001E\u0006iqN\\\"mS\u0016tG/\u0012:s_J$BaY8usB\u0019AmZ5\u000e\u0003\u0015T!A\u001a\u0007\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002iK\n1a)\u001e;ve\u0016\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0003\u0002\u0007548-\u0003\u0002oW\n1!+Z:vYRDQ\u0001\u001d1A\u0002E\fqA]3rk\u0016\u001cH\u000f\u0005\u0002ke&\u00111o\u001b\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000bU\u0004\u0007\u0019\u0001<\u0002\u0015M$\u0018\r^;t\u0007>$W\r\u0005\u0002\fo&\u0011\u0001\u0010\u0004\u0002\u0004\u0013:$\bb\u0002>a!\u0003\u0005\raV\u0001\b[\u0016\u001c8/Y4f\u0011\u0015a\b\u0001\"\u0005~\u00031ygNQ1e%\u0016\fX/Z:u)\r\u0019gp \u0005\u0006an\u0004\r!\u001d\u0005\u0006un\u0004\ra\u0016\u0005\b\u0003\u0007\u0001A\u0011CA\u0003\u0003-ygNR8sE&$G-\u001a8\u0015\u000b\r\f9!!\u0003\t\rA\f\t\u00011\u0001r\u0011\u0019Q\u0018\u0011\u0001a\u0001/\"9\u0011Q\u0002\u0001\u0005\u0012\u0005=\u0011AC8o\u001d>$hi\\;oIR)1-!\u0005\u0002\u0014!1\u0001/a\u0003A\u0002EDaA_A\u0006\u0001\u00049\u0006bBA\f\u0001\u0011E\u0011\u0011D\u0001\u0013_:|E\u000f[3s\u00072LWM\u001c;FeJ|'\u000fF\u0004d\u00037\ti\"a\b\t\rA\f)\u00021\u0001r\u0011\u0019)\u0018Q\u0003a\u0001m\"1!0!\u0006A\u0002]Cq!a\t\u0001\t\u0003\t)#A\u0007p]N+'O^3s\u000bJ\u0014xN\u001d\u000b\u0006G\u0006\u001d\u0012\u0011\u0006\u0005\u0007a\u0006\u0005\u0002\u0019A9\t\u0011\u0005-\u0012\u0011\u0005a\u0001\u0003[\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\u0005=\u0012q\b\b\u0005\u0003c\tYD\u0004\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004C\u0001\u0007yI|w\u000e\u001e \n\u00035I1!!\u0010\r\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0011\u0002D\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003{a\u0001bBA$\u0001\u0011E\u0011\u0011J\u0001\u000fY><7+\u001a:wKJ,%O]8s)\u0019\tY%!\u0015\u0002TA\u00191\"!\u0014\n\u0007\u0005=CB\u0001\u0003V]&$\bB\u00029\u0002F\u0001\u0007\u0011\u000f\u0003\u0005\u0002V\u0005\u0015\u0003\u0019AA,\u0003=)8/\u001a4vY\u0016C8-\u001a9uS>t\u0007cA\f\u0002Z%\u0019\u00111\f\u0003\u0003\u001fU\u001bXMZ;m\u000bb\u001cW\r\u001d;j_:Dq!a\u0018\u0001\t#\t\t'\u0001\tp]\u0012+goU3sm\u0016\u0014XI\u001d:peR)1-a\u0019\u0002f!1\u0001/!\u0018A\u0002ED\u0001\"a\u000b\u0002^\u0001\u0007\u0011q\u000b\u0005\b\u0003S\u0002A\u0011CA6\u0003Eyg\u000e\u0015:pIN+'O^3s\u000bJ\u0014xN\u001d\u000b\u0006G\u00065\u0014q\u000e\u0005\u0007a\u0006\u001d\u0004\u0019A9\t\u0011\u0005-\u0012q\ra\u0001\u0003/B3\u0001AA:!\rA\u0015QO\u0005\u0004\u0003oJ%!C*j]\u001edW\r^8o\u000f\u001d\tYH\u0001E\u0001\u0003{\nq\u0003R3gCVdG\u000f\u0013;ua\u0016\u0013(o\u001c:IC:$G.\u001a:\u0011\u0007E\tyH\u0002\u0004\u0002\u0005!\u0005\u0011\u0011Q\n\u0004\u0003\u007fJ\u0004bB\u001c\u0002\u0000\u0011\u0005\u0011Q\u0011\u000b\u0003\u0003{B!\"!#\u0002\u0000E\u0005I\u0011AAF\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0012\u0016\u0004C\u0005=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005mE\"\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\r\u0016qPI\u0001\n\u0003\t)+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003OS3aLAH\u0001")
public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final Environment environment;
    private final Option<SourceMapper> sourceMapper;
    private final Function0<Option<Router>> router;
    private final Option<String> playEditor;

    public static Option<Router> $lessinit$greater$default$4() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<SourceMapper> $lessinit$greater$default$3() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler$class.onClientError$default$3(this);
    }

    private Option<String> playEditor() {
        return this.playEditor;
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        block6: {
            Future<Result> future;
            block3: {
                block5: {
                    int n;
                    block4: {
                        block2: {
                            n = statusCode;
                            if (Status$.MODULE$.BAD_REQUEST() != n) break block2;
                            future = this.onBadRequest(request, message);
                            break block3;
                        }
                        if (Status$.MODULE$.FORBIDDEN() != n) break block4;
                        future = this.onForbidden(request, message);
                        break block3;
                    }
                    if (Status$.MODULE$.NOT_FOUND() != n) break block5;
                    future = this.onNotFound(request, message);
                    break block3;
                }
                if (statusCode < 400 || statusCode >= 500) break block6;
                future = this.onOtherClientError(request, statusCode, message);
            }
            return future;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onClientError invoked with non client error status code ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)statusCode), message})));
    }

    public Future<Result> onBadRequest(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.BadRequest().apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onForbidden(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden().apply(unauthorized$.MODULE$.apply(), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onNotFound(RequestHeader request, String message) {
        Enumeration.Value value = this.environment.mode();
        Enumeration.Value value2 = Mode$.MODULE$.Prod();
        Enumeration.Value value3 = value;
        Html html = !(value2 != null ? !value2.equals(value3) : value3 != null) ? notFound$.MODULE$.apply(request.method(), request.uri()) : devNotFound$.MODULE$.apply(request.method(), request.uri(), (Option<Router>)((Option)this.router.apply()));
        return Future$.MODULE$.successful((Object)Results$.MODULE$.NotFound().apply(html, Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onOtherClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Future<Result> future;
        try {
            Enumeration.Value value = this.environment.mode();
            Enumeration.Value value2 = Mode$.MODULE$.Prod();
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, !(value != null ? !value.equals(value2) : value2 != null), exception);
            this.logServerError(request, usefulException);
            Enumeration.Value value3 = this.environment.mode();
            Enumeration.Value value4 = Mode$.MODULE$.Prod();
            Enumeration.Value value5 = value3;
            Future<Result> future2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.onProdServerError(request, usefulException) : this.onDevServerError(request, usefulException);
            future = future2;
        }
        catch (Throwable throwable) {
            Future<Result> future3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Logger$.MODULE$.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while handling error";
                }
            }, (Function0<Throwable>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            future = future3 = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError());
        }
        return future;
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        Logger$.MODULE$.error((Function0<String>)new Serializable(this, request, usefulException){
            public static final long serialVersionUID = 0L;
            private final RequestHeader request$1;
            private final UsefulException usefulException$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n                    |\n                    |! @%s - Internal server error, for (%s) [%s] ->\n                    | ")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.usefulException$1.id, this.request$1.method(), this.request$1.uri()}));
            }
            {
                this.request$1 = request$1;
                this.usefulException$1 = usefulException$1;
            }
        }, (Function0<Throwable>)new Serializable(this, usefulException){
            public static final long serialVersionUID = 0L;
            private final UsefulException usefulException$1;

            public final UsefulException apply() {
                return this.usefulException$1;
            }
            {
                this.usefulException$1 = usefulException$1;
            }
        });
    }

    public Future<Result> onDevServerError(RequestHeader request, UsefulException exception) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(devError$.MODULE$.apply(this.playEditor(), exception), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onProdServerError(RequestHeader request, UsefulException exception) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(error$.MODULE$.apply(exception), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        this.router = router;
        HttpErrorHandler$class.$init$(this);
        this.playEditor = configuration.getString("play.editor", configuration.getString$default$2());
    }

    @Inject
    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        this(environment, configuration, sourceMapper.sourceMapper(), (Function0<Option<Router>>)new Serializable(router){
            public static final long serialVersionUID = 0L;
            private final Provider router$1;

            public final Some<Router> apply() {
                return new Some(this.router$1.get());
            }
            {
                this.router$1 = router$1;
            }
        });
    }
}

