/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.http.Writeable;
import play.api.libs.iteratee.Concurrent;
import play.api.libs.iteratee.Enumerator;
import play.api.mvc.Codec;
import play.core.j.JavaResults;
import play.http.HttpEntity;
import play.libs.F;
import play.mvc.Call;
import play.mvc.Result;
import play.mvc.StatusHeader;
import play.twirl.api.Content;
import views.html.defaultpages.todo;

public class Results {
    private static final String UTF8 = "utf-8";
    private static final int defaultChunkSize = 8192;
    public static final Result TODO = Results.status(501, (Content)todo.render());

    public static StatusHeader status(int n) {
        return new StatusHeader(n);
    }

    public static Result status(int n, Content content) {
        return Results.status(n, content, UTF8);
    }

    public static Result status(int n, Content content, String string2) {
        if (content == null) {
            throw new NullPointerException("Null content");
        }
        return new Result(n, HttpEntity.fromContent(content, string2));
    }

    public static Result status(int n, String string2) {
        return Results.status(n, string2, UTF8);
    }

    public static Result status(int n, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException("Null content");
        }
        return new Result(n, HttpEntity.fromString(string2, string3));
    }

    public static Result status(int n, JsonNode jsonNode) {
        return Results.status(n, jsonNode, UTF8);
    }

    public static Result status(int n, JsonNode jsonNode, String string2) {
        if (jsonNode == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendJson(jsonNode, string2);
    }

    public static Result status(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Null content");
        }
        return new Result(n, (HttpEntity)new HttpEntity.Strict(ByteString.fromArray((byte[])byArray), Optional.empty()));
    }

    public static Result status(int n, ByteString byteString) {
        if (byteString == null) {
            throw new NullPointerException("Null content");
        }
        return new Result(n, (HttpEntity)new HttpEntity.Strict(byteString, Optional.empty()));
    }

    public static Result status(int n, InputStream inputStream) {
        return Results.status(n).sendInputStream(inputStream);
    }

    public static Result status(int n, InputStream inputStream, long l) {
        return Results.status(n).sendInputStream(inputStream, l);
    }

    public static Result status(int n, File file2) {
        return Results.status(n, file2, true);
    }

    public static Result status(int n, File file2, boolean bl) {
        return Results.status(n).sendFile(file2, bl);
    }

    public static Result status(int n, File file2, String string2) {
        return Results.status(n).sendFile(file2, string2);
    }

    public static Result status(int n, Chunks<?> chunks) {
        return Results.status(n).chunked(chunks);
    }

    public static StatusHeader noContent() {
        return new StatusHeader(204);
    }

    public static StatusHeader ok() {
        return new StatusHeader(200);
    }

    public static Result ok(Content content) {
        return Results.status(200, content);
    }

    public static Result ok(Content content, String string2) {
        return Results.status(200, content, string2);
    }

    public static Result ok(String string2) {
        return Results.status(200, string2);
    }

    public static Result ok(String string2, String string3) {
        return Results.status(200, string2, string3);
    }

    public static Result ok(JsonNode jsonNode) {
        return Results.status(200, jsonNode);
    }

    public static Result ok(JsonNode jsonNode, String string2) {
        return Results.status(200, jsonNode, string2);
    }

    public static Result ok(byte[] byArray) {
        return Results.status(200, byArray);
    }

    public static Result ok(InputStream inputStream) {
        return Results.status(200, inputStream);
    }

    public static Result ok(InputStream inputStream, long l) {
        return Results.status(200, inputStream, l);
    }

    public static Result ok(File file2) {
        return Results.status(200, file2);
    }

    public static Result ok(File file2, boolean bl) {
        return Results.status(200, file2, bl);
    }

    public static Result ok(File file2, String string2) {
        return Results.status(200, file2, string2);
    }

    @Deprecated
    public static Result ok(Chunks<?> chunks) {
        return Results.status(200, chunks);
    }

    public static StatusHeader created() {
        return new StatusHeader(201);
    }

    public static Result created(Content content) {
        return Results.status(201, content);
    }

    public static Result created(Content content, String string2) {
        return Results.status(201, content, string2);
    }

    public static Result created(String string2) {
        return Results.status(201, string2);
    }

    public static Result created(String string2, String string3) {
        return Results.status(201, string2, string3);
    }

    public static Result created(JsonNode jsonNode) {
        return Results.status(201, jsonNode);
    }

    public static Result created(JsonNode jsonNode, String string2) {
        return Results.status(201, jsonNode, string2);
    }

    public static Result created(byte[] byArray) {
        return Results.status(201, byArray);
    }

    public static Result created(InputStream inputStream) {
        return Results.status(201, inputStream);
    }

    public static Result created(InputStream inputStream, long l) {
        return Results.status(201, inputStream, l);
    }

    public static Result created(File file2) {
        return Results.status(201, file2);
    }

    public static Result created(File file2, boolean bl) {
        return Results.status(201, file2, bl);
    }

    public static Result created(File file2, String string2) {
        return Results.status(201, file2, string2);
    }

    @Deprecated
    public static Result created(Chunks<?> chunks) {
        return Results.status(201, chunks);
    }

    public static StatusHeader badRequest() {
        return new StatusHeader(400);
    }

    public static Result badRequest(Content content) {
        return Results.status(400, content);
    }

    public static Result badRequest(Content content, String string2) {
        return Results.status(400, content, string2);
    }

    public static Result badRequest(String string2) {
        return Results.status(400, string2);
    }

    public static Result badRequest(String string2, String string3) {
        return Results.status(400, string2, string3);
    }

    public static Result badRequest(JsonNode jsonNode) {
        return Results.status(400, jsonNode);
    }

    public static Result badRequest(JsonNode jsonNode, String string2) {
        return Results.status(400, jsonNode, string2);
    }

    public static Result badRequest(byte[] byArray) {
        return Results.status(400, byArray);
    }

    public static Result badRequest(InputStream inputStream) {
        return Results.status(400, inputStream);
    }

    public static Result badRequest(InputStream inputStream, long l) {
        return Results.status(400, inputStream, l);
    }

    public static Result badRequest(File file2) {
        return Results.status(400, file2);
    }

    public static Result badRequest(File file2, boolean bl) {
        return Results.status(400, file2, bl);
    }

    public static Result badRequest(File file2, String string2) {
        return Results.status(400, file2, string2);
    }

    @Deprecated
    public static Result badRequest(Chunks<?> chunks) {
        return Results.status(400, chunks);
    }

    public static StatusHeader unauthorized() {
        return new StatusHeader(401);
    }

    public static Result unauthorized(Content content) {
        return Results.status(401, content);
    }

    public static Result unauthorized(Content content, String string2) {
        return Results.status(401, content, string2);
    }

    public static Result unauthorized(String string2) {
        return Results.status(401, string2);
    }

    public static Result unauthorized(String string2, String string3) {
        return Results.status(401, string2, string3);
    }

    public static Result unauthorized(JsonNode jsonNode) {
        return Results.status(401, jsonNode);
    }

    public static Result unauthorized(JsonNode jsonNode, String string2) {
        return Results.status(401, jsonNode, string2);
    }

    public static Result unauthorized(byte[] byArray) {
        return Results.status(401, byArray);
    }

    public static Result unauthorized(InputStream inputStream) {
        return Results.status(401, inputStream);
    }

    public static Result unauthorized(InputStream inputStream, long l) {
        return Results.status(401, inputStream, l);
    }

    public static Result unauthorized(File file2) {
        return Results.status(401, file2);
    }

    public static Result unauthorized(File file2, boolean bl) {
        return Results.status(401, file2, bl);
    }

    public static Result unauthorized(File file2, String string2) {
        return Results.status(401, file2, string2);
    }

    @Deprecated
    public static Result unauthorized(Chunks<?> chunks) {
        return Results.status(401, chunks);
    }

    public static StatusHeader paymentRequired() {
        return new StatusHeader(402);
    }

    public static Result paymentRequired(Content content) {
        return Results.status(402, content);
    }

    public static Result paymentRequired(Content content, String string2) {
        return Results.status(402, content, string2);
    }

    public static Result paymentRequired(String string2) {
        return Results.status(402, string2);
    }

    public static Result paymentRequired(String string2, String string3) {
        return Results.status(402, string2, string3);
    }

    public static Result paymentRequired(JsonNode jsonNode) {
        return Results.status(402, jsonNode);
    }

    public static Result paymentRequired(JsonNode jsonNode, String string2) {
        return Results.status(402, jsonNode, string2);
    }

    public static Result paymentRequired(byte[] byArray) {
        return Results.status(402, byArray);
    }

    public static Result paymentRequired(InputStream inputStream) {
        return Results.status(402, inputStream);
    }

    public static Result paymentRequired(InputStream inputStream, long l) {
        return Results.status(402, inputStream, l);
    }

    public static Result paymentRequired(File file2) {
        return Results.status(402, file2);
    }

    public static Result paymentRequired(File file2, boolean bl) {
        return Results.status(402, file2, bl);
    }

    public static Result paymentRequired(File file2, String string2) {
        return Results.status(402, file2, string2);
    }

    @Deprecated
    public static Result paymentRequired(Chunks<?> chunks) {
        return Results.status(402, chunks);
    }

    public static StatusHeader forbidden() {
        return new StatusHeader(403);
    }

    public static Result forbidden(Content content) {
        return Results.status(403, content);
    }

    public static Result forbidden(Content content, String string2) {
        return Results.status(403, content, string2);
    }

    public static Result forbidden(String string2) {
        return Results.status(403, string2);
    }

    public static Result forbidden(String string2, String string3) {
        return Results.status(403, string2, string3);
    }

    public static Result forbidden(JsonNode jsonNode) {
        return Results.status(403, jsonNode);
    }

    public static Result forbidden(JsonNode jsonNode, String string2) {
        return Results.status(403, jsonNode, string2);
    }

    public static Result forbidden(byte[] byArray) {
        return Results.status(403, byArray);
    }

    public static Result forbidden(InputStream inputStream) {
        return Results.status(403, inputStream);
    }

    public static Result forbidden(InputStream inputStream, long l) {
        return Results.status(403, inputStream, l);
    }

    public static Result forbidden(File file2) {
        return Results.status(403, file2);
    }

    public static Result forbidden(File file2, boolean bl) {
        return Results.status(403, file2, bl);
    }

    public static Result forbidden(File file2, String string2) {
        return Results.status(403, file2, string2);
    }

    @Deprecated
    public static Result forbidden(Chunks<?> chunks) {
        return Results.status(403, chunks);
    }

    public static StatusHeader notFound() {
        return new StatusHeader(404);
    }

    public static Result notFound(Content content) {
        return Results.status(404, content);
    }

    public static Result notFound(Content content, String string2) {
        return Results.status(404, content, string2);
    }

    public static Result notFound(String string2) {
        return Results.status(404, string2);
    }

    public static Result notFound(String string2, String string3) {
        return Results.status(404, string2, string3);
    }

    public static Result notFound(JsonNode jsonNode) {
        return Results.status(404, jsonNode);
    }

    public static Result notFound(JsonNode jsonNode, String string2) {
        return Results.status(404, jsonNode, string2);
    }

    public static Result notFound(byte[] byArray) {
        return Results.status(404, byArray);
    }

    public static Result notFound(InputStream inputStream) {
        return Results.status(404, inputStream);
    }

    public static Result notFound(InputStream inputStream, long l) {
        return Results.status(404, inputStream, l);
    }

    public static Result notFound(File file2) {
        return Results.status(404, file2);
    }

    public static Result notFound(File file2, boolean bl) {
        return Results.status(404, file2, bl);
    }

    public static Result notFound(File file2, String string2) {
        return Results.status(404, file2, string2);
    }

    @Deprecated
    public static Result notFound(Chunks<?> chunks) {
        return Results.status(404, chunks);
    }

    public static StatusHeader internalServerError() {
        return new StatusHeader(500);
    }

    public static Result internalServerError(Content content) {
        return Results.status(500, content);
    }

    public static Result internalServerError(Content content, String string2) {
        return Results.status(500, content, string2);
    }

    public static Result internalServerError(String string2) {
        return Results.status(500, string2);
    }

    public static Result internalServerError(String string2, String string3) {
        return Results.status(500, string2, string3);
    }

    public static Result internalServerError(JsonNode jsonNode) {
        return Results.status(500, jsonNode);
    }

    public static Result internalServerError(JsonNode jsonNode, String string2) {
        return Results.status(500, jsonNode, string2);
    }

    public static Result internalServerError(byte[] byArray) {
        return Results.status(500, byArray);
    }

    public static Result internalServerError(InputStream inputStream) {
        return Results.status(500, inputStream);
    }

    public static Result internalServerError(InputStream inputStream, long l) {
        return Results.status(500, inputStream, l);
    }

    public static Result internalServerError(File file2) {
        return Results.status(500, file2);
    }

    public static Result internalServerError(File file2, boolean bl) {
        return Results.status(500, file2, bl);
    }

    public static Result internalServerError(File file2, String string2) {
        return Results.status(500, file2, string2);
    }

    @Deprecated
    public static Result internalServerError(Chunks<?> chunks) {
        return Results.status(500, chunks);
    }

    public static Result movedPermanently(String string2) {
        return new Result(301, Collections.singletonMap("Location", string2));
    }

    public static Result movedPermanently(Call call2) {
        return new Result(301, Collections.singletonMap("Location", call2.url()));
    }

    public static Result found(String string2) {
        return new Result(302, Collections.singletonMap("Location", string2));
    }

    public static Result found(Call call2) {
        return new Result(302, Collections.singletonMap("Location", call2.url()));
    }

    public static Result seeOther(String string2) {
        return new Result(303, Collections.singletonMap("Location", string2));
    }

    public static Result seeOther(Call call2) {
        return new Result(303, Collections.singletonMap("Location", call2.url()));
    }

    public static Result redirect(String string2) {
        return new Result(303, Collections.singletonMap("Location", string2));
    }

    public static Result redirect(Call call2) {
        return new Result(303, Collections.singletonMap("Location", call2.url()));
    }

    public static Result temporaryRedirect(String string2) {
        return new Result(307, Collections.singletonMap("Location", string2));
    }

    public static Result temporaryRedirect(Call call2) {
        return new Result(307, Collections.singletonMap("Location", call2.url()));
    }

    public static Result permanentRedirect(String string2) {
        return new Result(308, Collections.singletonMap("Location", string2));
    }

    public static Result permanentRedirect(Call call2) {
        return new Result(308, Collections.singletonMap("Location", call2.url()));
    }

    @Deprecated
    public static abstract class ByteChunks
    extends Chunks<byte[]> {
        public ByteChunks() {
            super(JavaResults.writeBytes());
        }

        public static ByteChunks whenReady(Consumer<Chunks.Out<byte[]>> consumer) {
            return new WhenReadyByteChunks(consumer);
        }

        static final class WhenReadyByteChunks
        extends ByteChunks {
            private static final Logger logger = LoggerFactory.getLogger(WhenReadyByteChunks.class);
            private final Consumer<Chunks.Out<byte[]>> callback;

            WhenReadyByteChunks(Consumer<Chunks.Out<byte[]>> consumer) {
                if (consumer == null) {
                    throw new NullPointerException("ByteChunks onReady callback cannot be null");
                }
                this.callback = consumer;
            }

            @Override
            public void onReady(Chunks.Out<byte[]> out) {
                try {
                    this.callback.accept(out);
                }
                catch (Throwable throwable) {
                    logger.error("Exception in ByteChunks.onReady", throwable);
                }
            }
        }
    }

    public static abstract class StringChunks
    extends Chunks<String> {
        private static final Logger logger = LoggerFactory.getLogger(StringChunks.class);

        public StringChunks() {
            this(Codec.utf_8());
        }

        public StringChunks(String string2) {
            this(Codec.javaSupported(string2));
        }

        public StringChunks(Codec codec) {
            super(JavaResults.writeString(codec));
        }

        public static StringChunks whenReady(Consumer<Chunks.Out<String>> consumer) {
            return StringChunks.whenReady(Codec.utf_8(), consumer);
        }

        public static StringChunks whenReady(String string2, Consumer<Chunks.Out<String>> consumer) {
            return StringChunks.whenReady(Codec.javaSupported(string2), consumer);
        }

        public static StringChunks whenReady(Codec codec, Consumer<Chunks.Out<String>> consumer) {
            return new WhenReadyStringChunks(codec, consumer);
        }

        static final class WhenReadyStringChunks
        extends StringChunks {
            private final Consumer<Chunks.Out<String>> callback;

            WhenReadyStringChunks(Codec codec, Consumer<Chunks.Out<String>> consumer) {
                super(codec);
                if (consumer == null) {
                    throw new NullPointerException("StringChunks onReady callback cannot be null");
                }
                this.callback = consumer;
            }

            @Override
            public void onReady(Chunks.Out<String> out) {
                try {
                    this.callback.accept(out);
                }
                catch (Throwable throwable) {
                    logger.error("Exception in StringChunks.onReady", throwable);
                }
            }
        }
    }

    public static abstract class Chunks<A> {
        final Enumerator<A> enumerator;
        final Writeable<A> writable;

        public Chunks(Writeable<A> writeable2) {
            Chunks chunks = this;
            this.writable = writeable2;
            F.RedeemablePromise redeemablePromise = F.RedeemablePromise.empty();
            this.enumerator = JavaResults.chunked(channel -> {
                Out out = new Out(channel, redeemablePromise);
                chunks.onReady(out);
            }, () -> redeemablePromise.success(null));
        }

        public abstract void onReady(Out<A> var1);

        public static class Out<A> {
            final F.RedeemablePromise<Object> disconnected;
            final Concurrent.Channel<A> channel;

            public Out(Concurrent.Channel<A> channel, F.RedeemablePromise<Object> redeemablePromise) {
                this.channel = channel;
                this.disconnected = redeemablePromise;
            }

            public Out(Concurrent.Channel<A> channel, List<Runnable> list) {
                this.channel = channel;
                this.disconnected = F.RedeemablePromise.empty();
                for (Runnable runnable : list) {
                    this.onDisconnected(runnable);
                }
            }

            public void write(A a) {
                this.channel.push(a);
            }

            public void onDisconnected(Runnable runnable) {
                this.disconnected.onRedeem(object -> runnable.run());
            }

            public void close() {
                this.channel.eofAndEnd();
            }
        }
    }
}

