/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.node10.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.HandleListener;
import io.apigee.trireme.core.internal.handles.NIOSocketHandle;
import io.apigee.trireme.core.internal.handles.NetworkHandleListener;
import io.apigee.trireme.core.modules.Referenceable;
import io.apigee.trireme.net.NetUtils;
import io.apigee.trireme.node10.modules.JavaStreamWrap;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPWrap
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(TCPWrap.class);

    public String getModuleName() {
        return "tcp_wrap";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject exports = (ScriptableObject)cx.newObject(scope);
        exports.setPrototype(scope);
        exports.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)exports, Referenceable.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, JavaStreamWrap.StreamWrapImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)exports, TCPImpl.class, (boolean)false, (boolean)true);
        return exports;
    }

    public static class TCPImpl
    extends JavaStreamWrap.StreamWrapImpl
    implements NetworkHandleListener {
        public static final String CLASS_NAME = "TCP";
        private Function onConnection;
        private NIOSocketHandle sockHandle;

        public TCPImpl() {
        }

        protected TCPImpl(NIOSocketHandle handle, ScriptRunner runtime) {
            super((AbstractHandle)handle, runtime);
            this.sockHandle = handle;
        }

        @JSConstructor
        public static Object newTCPImpl(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            if (!inNewExpr) {
                return cx.newObject((Scriptable)ctorObj, CLASS_NAME, args);
            }
            ScriptRunner runner = TCPImpl.getRunner((Context)cx);
            NIOSocketHandle handle = (NIOSocketHandle)ArgUtils.objArg((Object[])args, (int)0, NIOSocketHandle.class, (boolean)false);
            if (handle == null) {
                handle = new NIOSocketHandle((NodeRuntime)runner);
            }
            TCPImpl tcp = new TCPImpl(handle, runner);
            tcp.requestPin();
            return tcp;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSSetter(value="onconnection")
        public void setOnConnection(Function oc) {
            this.onConnection = oc;
        }

        @JSGetter(value="onconnection")
        public Function getOnConnection() {
            return this.onConnection;
        }

        @JSFunction
        public String bind(String address, int port) {
            try {
                this.sockHandle.bind(address, port);
                TCPImpl.clearErrno();
            }
            catch (NodeOSException ose) {
                TCPImpl.setErrno((String)ose.getCode());
                return ose.getCode();
            }
            return null;
        }

        @JSFunction
        public String bind6(String address, int port) {
            return this.bind(address, port);
        }

        @JSFunction
        public String listen(int backlog) {
            try {
                this.sockHandle.listen(backlog, (NetworkHandleListener)this, null);
                TCPImpl.clearErrno();
                return null;
            }
            catch (NodeOSException ose) {
                TCPImpl.setErrno((String)ose.getCode());
                return ose.getCode();
            }
        }

        public void onConnection(boolean inScriptThread, final AbstractHandle handle, Object context) {
            if (inScriptThread) {
                Context cx = Context.getCurrentContext();
                this.sendOnConnection(cx, handle);
            } else {
                this.runtime.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        TCPImpl.this.sendOnConnection(cx, handle);
                    }
                });
            }
        }

        private void sendOnConnection(Context cx, AbstractHandle handle) {
            if (this.onConnection != null) {
                TCPImpl sock = (TCPImpl)cx.newObject((Scriptable)this, CLASS_NAME, new Object[]{handle});
                this.onConnection.call(cx, (Scriptable)this.onConnection, (Scriptable)this, new Object[]{sock});
            }
        }

        @JSFunction
        public static Object connect(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            String host = ArgUtils.stringArg((Object[])args, (int)0);
            int port = ArgUtils.intArg((Object[])args, (int)1);
            Scriptable pending = cx.newObject(thisObj);
            try {
                tcp.sockHandle.connect(host, port, (NetworkHandleListener)tcp, (Object)pending);
            }
            catch (NodeOSException ose) {
                TCPImpl.setErrno((String)ose.getCode());
                return null;
            }
            return pending;
        }

        @JSFunction
        public static Object connect6(Context cx, Scriptable thisObj, Object[] args, Function func) {
            return TCPImpl.connect(cx, thisObj, args, func);
        }

        public void onConnectComplete(boolean inScriptThread, final Object context) {
            if (inScriptThread) {
                this.sendOnConnectComplete(Context.getCurrentContext(), context, 0, true, true);
            } else {
                this.runtime.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        TCPImpl.this.sendOnConnectComplete(cx, context, 0, true, true);
                    }
                });
            }
        }

        public void onConnectError(final String err, boolean inScriptThread, final Object context) {
            if (inScriptThread) {
                this.sendOnConnectComplete(Context.getCurrentContext(), context, err, false, false);
            } else {
                this.runtime.enqueueTask(new ScriptTask(){

                    public void execute(Context cx, Scriptable scope) {
                        TCPImpl.this.sendOnConnectComplete(cx, context, err, false, false);
                    }
                });
            }
        }

        private void sendOnConnectComplete(Context cx, Object context, Object status, boolean readable, boolean writable) {
            Scriptable s = (Scriptable)context;
            Object onComplete = ScriptableObject.getProperty((Scriptable)s, (String)"oncomplete");
            if (onComplete != null) {
                Function ocf = (Function)onComplete;
                if (status instanceof String) {
                    TCPImpl.setErrno((String)status.toString());
                } else {
                    TCPImpl.clearErrno();
                }
                ocf.call(cx, (Scriptable)ocf, (Scriptable)this, new Object[]{status, this, s, readable, writable});
            }
        }

        @JSFunction
        public static Object shutdown(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            Scriptable req = cx.newObject((Scriptable)tcp);
            TCPImpl.clearErrno();
            tcp.sockHandle.shutdown((HandleListener)tcp, (Object)req);
            return req;
        }

        @JSFunction
        public static Object getsockname(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            TCPImpl.clearErrno();
            InetSocketAddress addr = tcp.sockHandle.getSockName();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress((InetAddress)addr.getAddress(), (int)addr.getPort(), (Context)cx, (Scriptable)thisObj);
        }

        @JSFunction
        public static Object getpeername(Context cx, Scriptable thisObj, Object[] args, Function func) {
            TCPImpl tcp = (TCPImpl)thisObj;
            TCPImpl.clearErrno();
            InetSocketAddress addr = tcp.sockHandle.getPeerName();
            if (addr == null) {
                return null;
            }
            return NetUtils.formatAddress((InetAddress)addr.getAddress(), (int)addr.getPort(), (Context)cx, (Scriptable)thisObj);
        }

        @JSFunction
        public void setNoDelay(boolean nd) {
            try {
                this.sockHandle.setNoDelay(nd);
                TCPImpl.clearErrno();
            }
            catch (NodeOSException ose) {
                TCPImpl.setErrno((String)ose.getCode());
            }
        }

        @JSFunction
        public void setKeepAlive(boolean nd) {
            try {
                this.sockHandle.setKeepAlive(nd);
                TCPImpl.clearErrno();
            }
            catch (NodeOSException ose) {
                TCPImpl.setErrno((String)ose.getCode());
            }
        }
    }
}

