/*
 * Decompiled with CFR 0.152.
 */
package activator;

import activator.ActivatorCliHelper;
import activator.ActivatorCliHelper$;
import activator.ActivatorCliHelper$class;
import activator.UICacheHelper$;
import activator.cache.TemplateCache;
import activator.cache.TemplateMetadata;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem$;
import akka.util.Timeout;
import java.util.concurrent.TimeoutException;
import sbt.complete.Parser;
import sbt.complete.Parser$;
import sbt.complete.Parsers$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class TemplateHandler$
implements ActivatorCliHelper {
    public static final TemplateHandler$ MODULE$;
    private final Timeout timeout;

    static {
        new TemplateHandler$();
    }

    @Override
    public Timeout timeout() {
        return this.timeout;
    }

    @Override
    public void activator$ActivatorCliHelper$_setter_$timeout_$eq(Timeout x$1) {
        this.timeout = x$1;
    }

    @Override
    public <U> Option<U> readLine(Parser<U> parser, String prompt, Option<Object> mask) {
        return ActivatorCliHelper$class.readLine(this, parser, prompt, mask);
    }

    @Override
    public <U> String readLine$default$2() {
        return ActivatorCliHelper$class.readLine$default$2(this);
    }

    @Override
    public <U> Option<Object> readLine$default$3() {
        return ActivatorCliHelper$class.readLine$default$3(this);
    }

    public int apply() {
        Iterable<TemplateMetadata> metadata = this.downloadTemplates(UICacheHelper$.MODULE$.makeDefaultCache((ActorRefFactory)ActivatorCliHelper$.MODULE$.system()), ActivatorCliHelper$.MODULE$.defaultDuration(), this.timeout());
        this.printTemplateNames(metadata);
        return 1;
    }

    public Iterable<TemplateMetadata> downloadTemplates(TemplateCache cache, FiniteDuration duration, Timeout timeout) {
        Iterable iterable;
        try {
            System.out.println();
            System.out.println("Fetching the latest list of templates...");
            System.out.println();
            iterable = (Iterable)Await$.MODULE$.result((Awaitable)cache.metadata(), (Duration)duration);
        }
        catch (TimeoutException timeoutException) {
            System.out.println();
            System.out.println("Could not fetch the updated list of templates.  Using the local cache.");
            System.out.println("Check your proxy settings or increase the timeout.  For more details see:\nhttp://lightbend.com/activator/docs");
            System.out.println();
            TemplateCache localOnlyCache = UICacheHelper$.MODULE$.makeLocalOnlyCache((ActorRefFactory)ActorSystem$.MODULE$.apply("fallback"));
            iterable = (Iterable)Await$.MODULE$.result((Awaitable)localOnlyCache.metadata(), (Duration)duration);
        }
        return iterable;
    }

    public void printTemplateNames(Iterable<TemplateMetadata> metadata) {
        Tuple2 tuple2 = metadata.toSeq().partition((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(TemplateMetadata x$1) {
                return x$1.featured();
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq featured = (Seq)tuple2._1();
            Seq unfeatured = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)featured, (Object)unfeatured);
            Seq featured2 = (Seq)tuple23._1();
            Seq unfeatured2 = (Seq)tuple23._2();
            Tuple2 tuple24 = featured2.partition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TemplateMetadata x$3) {
                    return x$3.tags().contains((Object)"seed");
                }
            });
            if (tuple24 != null) {
                Tuple2 tuple25;
                Seq featuredSeed = (Seq)tuple24._1();
                Seq featuredNotSeed = (Seq)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)featuredSeed, (Object)featuredNotSeed);
                Seq featuredSeed2 = (Seq)tuple26._1();
                Seq featuredNotSeed2 = (Seq)tuple26._2();
                Tuple2 tuple27 = unfeatured2.partition((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TemplateMetadata x$5) {
                        return x$5.tags().contains((Object)"seed");
                    }
                });
                if (tuple27 != null) {
                    Tuple2 tuple28;
                    Seq unfeaturedSeed = (Seq)tuple27._1();
                    Seq unfeaturedNotSeed = (Seq)tuple27._2();
                    Tuple2 tuple29 = tuple28 = new Tuple2((Object)unfeaturedSeed, (Object)unfeaturedNotSeed);
                    Seq unfeaturedSeed2 = (Seq)tuple29._1();
                    Seq unfeaturedNotSeed2 = (Seq)tuple29._2();
                    Seq sections = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Featured Seed Templates"), (Object)featuredSeed2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Featured Tutorial Templates"), (Object)featuredNotSeed2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Other Seed Templates"), (Object)unfeaturedSeed2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Other Tutorial Templates"), (Object)unfeaturedNotSeed2)}))).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, Seq<TemplateMetadata>> apply(Tuple2<String, Seq<TemplateMetadata>> x0$1) {
                            Tuple2<String, Seq<TemplateMetadata>> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String title = (String)tuple2._1();
                                Seq list = (Seq)tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)title), list.sortBy((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(TemplateMetadata x$7) {
                                        return x$7.name().toLowerCase();
                                    }
                                }, (Ordering)Ordering.String$.MODULE$));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    sections.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final void apply(Tuple2<String, Seq<TemplateMetadata>> x0$2) {
                            Tuple2<String, Seq<TemplateMetadata>> tuple2 = x0$2;
                            if (tuple2 != null) {
                                String title = (String)tuple2._1();
                                Seq ts = (Seq)tuple2._2();
                                if (ts.nonEmpty()) {
                                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{title})));
                                    ts.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final void apply(TemplateMetadata t) {
                                            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t.name()})));
                                        }
                                    });
                                    Predef$.MODULE$.println((Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple27);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public Option<String> getTemplateName(Seq<String> possible, Seq<String> suggested) {
        Parser templateNameParser = Parser$.MODULE$.richParser(Parser$.MODULE$.token(Parser$.MODULE$.richParser(Parser$.MODULE$.richParser(Parsers$.MODULE$.any()).$times()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Seq<Object> x$8) {
                return x$8.mkString("");
            }
        }), "<template name>")).examples(possible.toSet(), false);
        Seq options = (Seq)((TraversableLike)((IterableLike)suggested.sorted((Ordering)Ordering.String$.MODULE$)).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, String> apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String v = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(i + 1))), (Object)v);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        System.out.println("Browse the list of templates: http://lightbend.com/activator/templates");
        if (suggested.isEmpty()) {
            System.out.println("Enter a template name (hit tab to see a list)");
        } else {
            System.out.println("Choose from these featured templates or enter a template name:");
            options.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, String> check$ifrefutable$1) {
                    Tuple2<Object, String> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, String> x$9) {
                    Tuple2<Object, String> tuple2 = x$9;
                    if (tuple2 != null) {
                        int i = tuple2._1$mcI$sp();
                        String name = (String)tuple2._2();
                        System.out.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ") ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), name})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            System.out.println("(hit tab to see a list of all templates)");
        }
        Option enteredOption = this.readLine(templateNameParser, this.readLine$default$2(), this.readLine$default$3()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$10) {
                return x$10.trim();
            }
        }).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$11) {
                return x$11.isEmpty();
            }
        });
        return enteredOption.map((Function1)new Serializable(options){
            public static final long serialVersionUID = 0L;
            private final Seq options$1;

            public final String apply(String entered) {
                String string;
                try {
                    int i = Integer.parseInt(entered);
                    string = (String)this.options$1.find((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final boolean apply(Tuple2<Object, String> x$12) {
                            return x$12._1$mcI$sp() == this.i$1;
                        }
                        {
                            this.i$1 = i$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<Object, String> x$13) {
                            return (String)x$13._2();
                        }
                    }).getOrElse((Function0)new Serializable(this, entered){
                        public static final long serialVersionUID = 0L;
                        private final String entered$1;

                        public final String apply() {
                            return this.entered$1;
                        }
                        {
                            this.entered$1 = entered$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    String string2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    string = string2 = entered;
                }
                return string;
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public Option<TemplateMetadata> findTemplate(Iterable<TemplateMetadata> metadata, String tName) {
        Option option;
        block4: {
            Some some;
            block3: {
                block2: {
                    Some some2;
                    option = metadata.find((Function1)new Serializable(tName){
                        public static final long serialVersionUID = 0L;
                        private final String tName$1;

                        public final boolean apply(TemplateMetadata x$14) {
                            String string = x$14.name();
                            String string2 = this.tName$1;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.tName$1 = tName$1;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    some = some2 = (Some)option;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find template with name: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tName})));
                some = None$.MODULE$;
            }
            return some;
        }
        throw new MatchError((Object)option);
    }

    private TemplateHandler$() {
        MODULE$ = this;
        ActivatorCliHelper$class.$init$(this);
    }
}

