/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.netty.http;

import com.typesafe.netty.http.DelegateHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;

class EmptyHttpResponse
extends DelegateHttpResponse
implements FullHttpResponse {
    public EmptyHttpResponse(HttpResponse response) {
        super(response);
    }

    public FullHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }

    public FullHttpResponse setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    public FullHttpResponse copy() {
        if (this.response instanceof FullHttpResponse) {
            return new EmptyHttpResponse((HttpResponse)((FullHttpResponse)this.response).copy());
        }
        DefaultHttpResponse copy = new DefaultHttpResponse(this.getProtocolVersion(), this.getStatus());
        copy.headers().set(this.headers());
        return new EmptyHttpResponse((HttpResponse)copy);
    }

    public FullHttpResponse retain(int increment) {
        ReferenceCountUtil.retain((Object)this.message, (int)increment);
        return this;
    }

    public FullHttpResponse retain() {
        ReferenceCountUtil.retain((Object)this.message);
        return this;
    }

    public HttpHeaders trailingHeaders() {
        return new DefaultHttpHeaders();
    }

    public HttpContent duplicate() {
        if (this.response instanceof HttpContent) {
            return ((HttpContent)this.response).duplicate();
        }
        return this;
    }

    public ByteBuf content() {
        return Unpooled.EMPTY_BUFFER;
    }

    public int refCnt() {
        if (this.message instanceof ReferenceCounted) {
            return ((ReferenceCounted)this.message).refCnt();
        }
        return 1;
    }

    public boolean release() {
        return ReferenceCountUtil.release((Object)this.message);
    }

    public boolean release(int decrement) {
        return ReferenceCountUtil.release((Object)this.message, (int)decrement);
    }
}

