/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import akka.japi.function.Function;
import akka.stream.javadsl.Flow;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import play.api.libs.EventSource;
import play.libs.Json;
import play.libs.Scala;

public class EventSource {
    public static Flow<Event, ByteString, ?> flow() {
        Flow flow = Flow.of(Event.class);
        return flow.map((Function & Serializable)event -> ByteString.fromString((String)event.formatted()));
    }

    public static class Event {
        private final String name;
        private final String id;
        private final String data;

        public Event(String string, String string2, String string3) {
            this.name = string3;
            this.id = string2;
            this.data = string;
        }

        public Event withName(String string) {
            return new Event(this.data, this.id, string);
        }

        public Event withId(String string) {
            return new Event(this.data, string, this.name);
        }

        public String formatted() {
            return new EventSource.Event(this.data, Scala.Option((Object)this.id), Scala.Option((Object)this.name)).formatted();
        }

        public static Event event(String string) {
            return new Event(string, null, null);
        }

        public static Event event(JsonNode jsonNode) {
            return new Event(Json.stringify((JsonNode)jsonNode), null, null);
        }
    }
}

