/*
 * Decompiled with CFR 0.152.
 */
package play.libs;

import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public class Resources {
    public static <T extends AutoCloseable, U> CompletionStage<U> asyncTryWithResource(T t, Function<T, CompletionStage<U>> function) {
        try {
            CompletionStage<U> completionStage = function.apply(t);
            completionStage.whenCompleteAsync((object, throwable) -> Resources.tryCloseResource(t));
            return completionStage;
        }
        catch (RuntimeException runtimeException) {
            Resources.tryCloseResource(t);
            throw runtimeException;
        }
        catch (Exception exception) {
            Resources.tryCloseResource(t);
            throw new RuntimeException(exception);
        }
    }

    private static <T extends AutoCloseable> void tryCloseResource(T t) {
        try {
            t.close();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

