/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310;

import java.math.BigDecimal;

public final class DecimalUtils {
    private static final char[] ZEROES = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);

    private DecimalUtils() {
        throw new RuntimeException("DecimalUtils cannot be instantiated.");
    }

    public static String toDecimal(long seconds, int nanoseconds) {
        StringBuilder sb = new StringBuilder(20).append(seconds).append('.');
        String nanos = Integer.toString(nanoseconds);
        if (nanos.length() < 9) {
            sb.append(ZEROES, 0, 9 - nanos.length());
        }
        sb.append(nanos);
        return sb.toString();
    }

    public static int extractNanosecondDecimal(BigDecimal value, long integer) {
        return value.subtract(new BigDecimal(integer)).multiply(ONE_BILLION).intValue();
    }
}

