/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import tyrex.util.Logger;
import tyrex.util.Messages;

public final class Configuration {
    public static final String PROPERTY_LOG_VERBOSE = "tyrex.log.verbose";
    public static final String PROPERTY_LOG_CONSOLE = "tyrex.log.console";
    public static final String PROPERTY_UNSYNCH_TICKS = "tyrex.clock.unsynchTicks";
    public static final String PROPERTY_SYNCH_EVERY = "tyrex.clock.synchEvery";
    public static final String PROPERTY_SECURE_RANDOM = "tyrex.random.secure";
    public static final String PROPERTY_UUID_STATE_FILE = "tyrex.uuid.stateFile";
    public static final String PROPERTY_DOMAIN_FILES = "tyrex.domain.files";
    public static final String VENDOR_NAME;
    public static final String VENDOR_URL;
    public static final String VERSION;
    public static final String TITLE;
    public static final String COPYRIGHT;
    public static final String FILE_NAME = "tyrex.config";
    public static final String CONFIG_SYSTEM_PROPERTY = "tyrex.config.file";
    private static final String RESOURCE_NAME = "/tyrex/tyrex.config";
    private static final Properties _default;
    public static final boolean verbose;
    public static final boolean console;
    private static Random _random;
    static /* synthetic */ Class class$tyrex$util$Configuration;

    public static String getProperty(String string, String string2) {
        return _default.getProperty(string, string2);
    }

    public static String getProperty(String string) {
        return _default.getProperty(string);
    }

    public static Properties getProperties() {
        return _default;
    }

    public static boolean getBoolean(String string) {
        String string2 = _default.getProperty(string);
        if (string2 == null) {
            return false;
        }
        return string2.equals("true") || string2.equals("on");
    }

    public static int getInteger(String string) {
        String string2 = _default.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static synchronized Random getRandom() {
        if (_random == null) {
            if (Configuration.getBoolean(PROPERTY_SECURE_RANDOM)) {
                if (verbose) {
                    Logger.tyrex.info((Object)Messages.message("tyrex.util.randomSecure"));
                }
                _random = new SecureRandom();
            } else {
                if (verbose) {
                    Logger.tyrex.info((Object)Messages.message("tyrex.util.randomStandard"));
                }
                _random = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
            }
        }
        return _random;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load((class$tyrex$util$Configuration == null ? (class$tyrex$util$Configuration = Configuration.class$("tyrex.util.Configuration")) : class$tyrex$util$Configuration).getResourceAsStream(RESOURCE_NAME));
        }
        catch (Exception exception) {
            System.err.println(Messages.format("tyrex.util.noDefaultConfigurationFile", RESOURCE_NAME));
        }
        VENDOR_NAME = properties.getProperty("version.vendorName");
        VENDOR_URL = properties.getProperty("version.vendorUrl");
        VERSION = properties.getProperty("version.number");
        TITLE = properties.getProperty("version.title");
        COPYRIGHT = properties.getProperty("version.copyright");
        System.err.println(Messages.format("tyrex.util.startingTyrex", TITLE, VERSION));
        System.err.println(COPYRIGHT);
        System.err.println();
        String string = System.getProperty(CONFIG_SYSTEM_PROPERTY);
        try {
            InputStream inputStream;
            if (string != null) {
                inputStream = new FileInputStream(string);
            } else {
                string = FILE_NAME;
                inputStream = (class$tyrex$util$Configuration == null ? (class$tyrex$util$Configuration = Configuration.class$("tyrex.util.Configuration")) : class$tyrex$util$Configuration).getResourceAsStream("/" + string);
            }
            if (inputStream != null) {
                properties = new Properties(properties);
                properties.load(inputStream);
            } else {
                string = null;
            }
        }
        catch (Exception exception) {
            System.err.println(Messages.format("tyrex.util.noConfigurationFile", string));
            string = null;
        }
        _default = properties;
        verbose = Configuration.getBoolean(PROPERTY_LOG_VERBOSE);
        console = Configuration.getBoolean(PROPERTY_LOG_CONSOLE);
        if (string != null) {
            System.err.println(Messages.format("tyrex.util.loadedConfigurationFile", string));
            System.err.println();
        }
    }
}

