/*
 * Decompiled with CFR 0.152.
 */
package tyrex.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    public static final String ResourceName = "tyrex.util.resources.messages";
    private static ResourceBundle _messages;
    private static Hashtable _formats;

    public static String format(String string, Object object) {
        return Messages.format(string, new Object[]{object});
    }

    public static String format(String string, Object object, Object object2) {
        return Messages.format(string, new Object[]{object, object2});
    }

    public static String format(String string, Object object, Object object2, Object object3) {
        return Messages.format(string, new Object[]{object, object2, object3});
    }

    public static String format(String string, Object[] objectArray) {
        try {
            MessageFormat messageFormat = (MessageFormat)_formats.get(string);
            if (messageFormat == null) {
                String string2;
                try {
                    string2 = _messages.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    return string;
                }
                messageFormat = new MessageFormat(string2);
                _formats.put(string, messageFormat);
            }
            return messageFormat.format(objectArray);
        }
        catch (Exception exception) {
            return "An internal error occured while processing message " + string;
        }
    }

    public static String message(String string) {
        try {
            return _messages.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public static void setLocale(Locale locale) {
        try {
            _messages = locale == null ? ResourceBundle.getBundle(ResourceName) : ResourceBundle.getBundle(ResourceName, locale);
            _formats = new Hashtable();
        }
        catch (Exception exception) {
            _messages = new EmptyResourceBundle();
        }
    }

    static {
        Messages.setLocale(Locale.getDefault());
    }

    static class EmptyResourceBundle
    extends ResourceBundle
    implements Enumeration {
        EmptyResourceBundle() {
        }

        public Enumeration getKeys() {
            return this;
        }

        protected Object handleGetObject(String string) {
            return "[Missing message " + string + "]";
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

