/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import play.Application;
import play.GlobalSettings;
import play.Play;
import play.api.mvc.Action;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.routing.Router;
import play.api.test.Helpers$;
import play.api.test.PlayRunners$;
import play.api.test.WebDriverFactory;
import play.core.j.JavaHandler;
import play.core.j.JavaHandlerComponents;
import play.core.j.JavaResultExtractor;
import play.libs.F;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Http;
import play.test.FakeApplication;
import play.test.TestBrowser;
import play.test.TestServer;
import play.twirl.api.Content;
import scala.Option;
import scala.concurrent.Future;

public class Helpers
implements Http.Status,
Http.HeaderNames {
    public static String GET = "GET";
    public static String POST = "POST";
    public static String PUT = "PUT";
    public static String DELETE = "DELETE";
    public static String HEAD = "HEAD";
    public static Class<? extends WebDriver> HTMLUNIT = HtmlUnitDriver.class;
    public static Class<? extends WebDriver> FIREFOX = FirefoxDriver.class;
    public static final long DEFAULT_TIMEOUT = Long.getLong("test.timeout", 30000L);

    private static play.mvc.Result invokeHandler(Handler handler, Http.Request request, long l) {
        if (handler instanceof Action) {
            Action action = (Action)handler;
            return Helpers.wrapScalaResult((Future<Result>)action.apply(request._underlyingRequest()), l);
        }
        if (handler instanceof JavaHandler) {
            return Helpers.invokeHandler(((JavaHandler)handler).withComponents((JavaHandlerComponents)Play.application().injector().instanceOf(JavaHandlerComponents.class)), request, l);
        }
        throw new RuntimeException("This is not a JavaAction and can't be invoked this way.");
    }

    private static play.mvc.Result wrapScalaResult(Future<Result> future, long l) {
        if (future == null) {
            return null;
        }
        Result result = (Result)F.Promise.wrap(future).get(l);
        return () -> result;
    }

    public static <V> V invokeWithContext(Http.RequestBuilder requestBuilder, Callable<V> callable) {
        try {
            Http.Context.current.set(new Http.Context(requestBuilder));
            V v = callable.call();
            return v;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            Http.Context.current.remove();
        }
    }

    public static Http.RequestBuilder fakeRequest() {
        return Helpers.fakeRequest("GET", "/");
    }

    public static Http.RequestBuilder fakeRequest(String string, String string2) {
        return new Http.RequestBuilder().method(string).uri(string2);
    }

    public static Http.RequestBuilder fakeRequest(Call call) {
        return Helpers.fakeRequest(call.method(), call.url());
    }

    public static FakeApplication fakeApplication() {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), new HashMap(), new ArrayList<String>(), null);
    }

    public static FakeApplication fakeApplication(GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), new HashMap(), new ArrayList<String>(), globalSettings);
    }

    public static GlobalSettings fakeGlobal() {
        return new GlobalSettings();
    }

    public static Map<String, String> inMemoryDatabase() {
        return Helpers.inMemoryDatabase("default");
    }

    public static Map<String, String> inMemoryDatabase(String string) {
        return Helpers.inMemoryDatabase(string, Collections.emptyMap());
    }

    public static Map<String, String> inMemoryDatabase(String string, Map<String, String> map) {
        return Scala.asJava(play.api.test.Helpers.inMemoryDatabase(string, (scala.collection.immutable.Map<String, String>)Scala.asScala(map)));
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, new ArrayList<String>(), null);
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map, GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, new ArrayList<String>(), globalSettings);
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map, List<String> list) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, list, null);
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map, List<String> list, GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, list, globalSettings);
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map, List<String> list, List<String> list2) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, list, list2, null);
    }

    public static FakeApplication fakeApplication(Map<String, ? extends Object> map, List<String> list, List<String> list2, GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, list, list2, globalSettings);
    }

    @Deprecated
    public static int status(play.mvc.Result result) {
        return result.toScala().header().status();
    }

    @Deprecated
    public static String redirectLocation(play.mvc.Result result) {
        return Helpers.header("Location", result);
    }

    @Deprecated
    public static Http.Flash flash(play.mvc.Result result) {
        return JavaResultExtractor.getFlash((play.mvc.Result)result);
    }

    @Deprecated
    public static Http.Session session(play.mvc.Result result) {
        return JavaResultExtractor.getSession((play.mvc.Result)result);
    }

    @Deprecated
    public static Http.Cookie cookie(String string, play.mvc.Result result) {
        return JavaResultExtractor.getCookies((play.mvc.Result)result).get(string);
    }

    @Deprecated
    public static Http.Cookies cookies(play.mvc.Result result) {
        return JavaResultExtractor.getCookies((play.mvc.Result)result);
    }

    @Deprecated
    public static String header(String string, play.mvc.Result result) {
        return (String)JavaResultExtractor.getHeaders((play.mvc.Result)result).get(string);
    }

    @Deprecated
    public static Map<String, String> headers(play.mvc.Result result) {
        return JavaResultExtractor.getHeaders((play.mvc.Result)result);
    }

    @Deprecated
    public static String contentType(Content content) {
        return content.contentType();
    }

    @Deprecated
    public static String contentType(play.mvc.Result result) {
        String string = Helpers.header("Content-Type", result);
        if (string == null) {
            return null;
        }
        if (string.contains(";")) {
            return string.substring(0, string.indexOf(";")).trim();
        }
        return string.trim();
    }

    @Deprecated
    public static String charset(play.mvc.Result result) {
        String string = Helpers.header("Content-Type", result);
        if (string == null) {
            return null;
        }
        if (string.contains("; charset=")) {
            return string.substring(string.indexOf("; charset=") + 10, string.length()).trim();
        }
        return null;
    }

    public static byte[] contentAsBytes(play.mvc.Result result) {
        return Helpers.contentAsBytes(result, DEFAULT_TIMEOUT);
    }

    public static byte[] contentAsBytes(play.mvc.Result result, long l) {
        return JavaResultExtractor.getBody((play.mvc.Result)result, (long)l);
    }

    public static byte[] contentAsBytes(Content content) {
        return content.body().getBytes();
    }

    public static String contentAsString(Content content) {
        return content.body();
    }

    public static String contentAsString(play.mvc.Result result) {
        return Helpers.contentAsString(result, DEFAULT_TIMEOUT);
    }

    public static String contentAsString(play.mvc.Result result, long l) {
        try {
            String string = Helpers.charset(result);
            if (string == null) {
                string = "utf-8";
            }
            return new String(Helpers.contentAsBytes(result, l), string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result routeAndCall(Http.RequestBuilder requestBuilder, long l) {
        try {
            return Helpers.routeAndCall(Http.RequestBuilder.class.getClassLoader().loadClass("Routes"), requestBuilder, l);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result routeAndCall(Class<? extends Router> clazz, Http.RequestBuilder requestBuilder, long l) {
        try {
            Http.RequestImpl requestImpl = requestBuilder.build();
            Router router = (Router)clazz.getClassLoader().loadClass(clazz.getName() + "$").getDeclaredField("MODULE$").get(null);
            if (router.routes().isDefinedAt((Object)requestImpl._underlyingRequest())) {
                return Helpers.invokeHandler((Handler)router.routes().apply((Object)requestImpl._underlyingRequest()), (Http.Request)requestImpl, l);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result routeAndCall(Router router, Http.RequestBuilder requestBuilder) {
        return Helpers.routeAndCall(router, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result routeAndCall(Router router, Http.RequestBuilder requestBuilder, long l) {
        try {
            Http.RequestImpl requestImpl = requestBuilder.build();
            if (router.routes().isDefinedAt((Object)requestImpl._underlyingRequest())) {
                return Helpers.invokeHandler((Handler)router.routes().apply((Object)requestImpl._underlyingRequest()), (Http.Request)requestImpl, l);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result route(Call call) {
        return Helpers.route(Helpers.fakeRequest(call));
    }

    public static play.mvc.Result route(Call call, long l) {
        return Helpers.route(Helpers.fakeRequest(call), l);
    }

    public static play.mvc.Result route(Application application, Call call) {
        return Helpers.route(application, Helpers.fakeRequest(call));
    }

    public static play.mvc.Result route(Application application, Call call, long l) {
        return Helpers.route(application, Helpers.fakeRequest(call), l);
    }

    public static play.mvc.Result route(Http.RequestBuilder requestBuilder) {
        return Helpers.route(requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result route(Http.RequestBuilder requestBuilder, long l) {
        return Helpers.route(Play.application(), requestBuilder, l);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder) {
        return Helpers.route(application, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder, long l) {
        Option<Future<Result>> option = play.api.test.Helpers.jRoute(application.getWrappedApplication(), (RequestHeader)requestBuilder.build()._underlyingRequest(), requestBuilder.bodyAsAnyContent());
        return Helpers.wrapScalaResult((Future<Result>)((Future)Scala.orNull(option)), l);
    }

    @Deprecated
    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder, byte[] byArray) {
        return Helpers.route(application, requestBuilder, byArray, DEFAULT_TIMEOUT);
    }

    @Deprecated
    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder, byte[] byArray, long l) {
        return Helpers.wrapScalaResult((Future<Result>)((Future)Scala.orNull(play.api.test.Helpers.jRoute(application.getWrappedApplication(), (RequestHeader)requestBuilder.build()._underlyingRequest(), byArray))), l);
    }

    @Deprecated
    public static play.mvc.Result route(Http.RequestBuilder requestBuilder, byte[] byArray) {
        return Helpers.route(requestBuilder, byArray, DEFAULT_TIMEOUT);
    }

    @Deprecated
    public static play.mvc.Result route(Http.RequestBuilder requestBuilder, byte[] byArray, long l) {
        return Helpers.route(Play.application(), requestBuilder, byArray, l);
    }

    public static void start(Application application) {
        play.api.Play.start((play.api.Application)application.getWrappedApplication());
    }

    public static void stop(Application application) {
        play.api.Play.stop((play.api.Application)application.getWrappedApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(Application application, Runnable runnable) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            try {
                Helpers.start(application);
                runnable.run();
            }
            finally {
                Helpers.stop(application);
            }
        }
    }

    public static TestServer testServer() {
        return Helpers.testServer(play.api.test.Helpers.testServerPort());
    }

    public static TestServer testServer(Application application) {
        return Helpers.testServer(play.api.test.Helpers.testServerPort(), application);
    }

    public static TestServer testServer(int n) {
        return new TestServer(n, Helpers.fakeApplication());
    }

    public static TestServer testServer(int n, Application application) {
        return new TestServer(n, application);
    }

    public static void start(TestServer testServer) {
        testServer.start();
    }

    public static void stop(TestServer testServer) {
        testServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(TestServer testServer, Runnable runnable) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            try {
                Helpers.start(testServer);
                runnable.run();
            }
            finally {
                Helpers.stop(testServer);
            }
        }
    }

    public static void running(TestServer testServer, Class<? extends WebDriver> clazz, F.Callback<TestBrowser> callback) {
        Helpers.running(testServer, WebDriverFactory.apply(clazz), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(TestServer testServer, WebDriver webDriver, F.Callback<TestBrowser> callback) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            TestBrowser testBrowser = null;
            TestServer testServer2 = null;
            try {
                Helpers.start(testServer);
                testServer2 = testServer;
                testBrowser = Helpers.testBrowser(webDriver);
                callback.invoke((Object)testBrowser);
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            finally {
                if (testBrowser != null) {
                    testBrowser.quit();
                }
                if (testServer2 != null) {
                    Helpers.stop(testServer2);
                }
            }
        }
    }

    public static TestBrowser testBrowser() {
        return Helpers.testBrowser(HTMLUNIT);
    }

    public static TestBrowser testBrowser(int n) {
        return Helpers.testBrowser(HTMLUNIT, n);
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz) {
        return Helpers.testBrowser(clazz, Helpers$.MODULE$.testServerPort());
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz, int n) {
        try {
            return new TestBrowser(clazz, "http://localhost:" + n);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static TestBrowser testBrowser(WebDriver webDriver, int n) {
        return new TestBrowser(webDriver, "http://localhost:" + n);
    }

    public static TestBrowser testBrowser(WebDriver webDriver) {
        return Helpers.testBrowser(webDriver, Helpers$.MODULE$.testServerPort());
    }
}

