/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.cache.CacheUtil;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.ModuleDescriptorMemoryCache;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.matcher.NoMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.ResourceHelper;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.HexEncoder;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.PropertiesFile;

public class DefaultRepositoryCacheManager
implements RepositoryCacheManager,
IvySettingsAware {
    private static final String DEFAULT_ARTIFACT_PATTERN = "[organisation]/[module](/[branch])/[type]s/[artifact]-[revision](-[classifier])(.[ext])";
    private static final String DEFAULT_DATA_FILE_PATTERN = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private static final String DEFAULT_IVY_PATTERN = "[organisation]/[module](/[branch])/ivy-[revision].xml";
    private static final int DEFAULT_MEMORY_CACHE_SIZE = 150;
    private static MessageDigest SHA_DIGEST;
    private IvySettings settings;
    private File basedir;
    private LockStrategy lockStrategy;
    private String name;
    private String ivyPattern;
    private String dataFilePattern = "[organisation]/[module](/[branch])/ivydata-[revision].properties";
    private String artifactPattern;
    private String lockStrategyName;
    private String changingPattern;
    private String changingMatcherName = "exactOrRegexp";
    private Boolean checkmodified;
    private Boolean useOrigin;
    private ModuleRules ttlRules = new ModuleRules();
    private Long defaultTTL = null;
    private ModuleDescriptorMemoryCache memoryModuleDescrCache;
    private static final Pattern DURATION_PATTERN;
    private static final int MILLIS_IN_SECONDS = 1000;
    private static final int MILLIS_IN_MINUTES = 60000;
    private static final int MILLIS_IN_HOUR = 3600000;
    private static final int MILLIS_IN_DAY = 86400000;

    public DefaultRepositoryCacheManager() {
    }

    public DefaultRepositoryCacheManager(String string, IvySettings ivySettings, File file) {
        this.setName(string);
        this.setSettings(ivySettings);
        this.setBasedir(file);
    }

    public IvySettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public File getIvyFileInCache(ModuleRevisionId moduleRevisionId) {
        String string = IvyPatternHelper.substitute(this.getIvyPattern(), DefaultArtifact.newIvyArtifact(moduleRevisionId, null));
        return new File(this.getRepositoryCacheRoot(), string);
    }

    public String getIvyPattern() {
        if (this.ivyPattern == null) {
            if (this.settings != null) {
                this.ivyPattern = this.settings.getDefaultCacheIvyPattern();
            }
            if (this.ivyPattern == null) {
                this.ivyPattern = DEFAULT_IVY_PATTERN;
            }
        }
        return this.ivyPattern;
    }

    public String getArtifactPattern() {
        if (this.artifactPattern == null) {
            if (this.settings != null) {
                this.artifactPattern = this.settings.getDefaultCacheArtifactPattern();
            }
            if (this.artifactPattern == null) {
                this.artifactPattern = DEFAULT_ARTIFACT_PATTERN;
            }
        }
        return this.artifactPattern;
    }

    public void setArtifactPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.artifactPattern = string;
    }

    public File getBasedir() {
        if (this.basedir == null) {
            this.basedir = this.settings.getDefaultRepositoryCacheBasedir();
        }
        return this.basedir;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public long getDefaultTTL() {
        if (this.defaultTTL == null) {
            this.defaultTTL = new Long(this.parseDuration(this.settings.getVariable("ivy.cache.ttl.default")));
        }
        return this.defaultTTL;
    }

    public void setDefaultTTL(long l) {
        this.defaultTTL = new Long(l);
    }

    public void setDefaultTTL(String string) {
        this.defaultTTL = new Long(this.parseDuration(string));
    }

    public String getDataFilePattern() {
        return this.dataFilePattern;
    }

    public void setDataFilePattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.dataFilePattern = string;
    }

    public void setIvyPattern(String string) {
        CacheUtil.checkCachePattern(string);
        this.ivyPattern = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getChangingMatcherName() {
        return this.changingMatcherName;
    }

    public void setChangingMatcher(String string) {
        this.changingMatcherName = string;
    }

    public String getChangingPattern() {
        return this.changingPattern;
    }

    public void setChangingPattern(String string) {
        this.changingPattern = string;
    }

    public void addTTL(Map map, PatternMatcher patternMatcher, long l) {
        this.ttlRules.defineRule(new MapMatcher(map, patternMatcher), new Long(l));
    }

    public void addConfiguredTtl(Map map) {
        String string = (String)map.remove("duration");
        if (string == null) {
            throw new IllegalArgumentException("'duration' attribute is mandatory for ttl");
        }
        String string2 = (String)map.remove("matcher");
        this.addTTL(map, string2 == null ? ExactPatternMatcher.INSTANCE : this.settings.getMatcher(string2), this.parseDuration(string));
    }

    public void setMemorySize(int n) {
        this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache(n);
    }

    public ModuleDescriptorMemoryCache getMemoryCache() {
        if (this.memoryModuleDescrCache == null) {
            this.memoryModuleDescrCache = new ModuleDescriptorMemoryCache(150);
        }
        return this.memoryModuleDescrCache;
    }

    private long parseDuration(String string) {
        if (string == null) {
            return 0L;
        }
        if ("eternal".equals(string)) {
            return Long.MAX_VALUE;
        }
        java.util.regex.Matcher matcher = DURATION_PATTERN.matcher(string);
        if (matcher.matches()) {
            int n = this.getGroupIntValue(matcher, 1);
            int n2 = this.getGroupIntValue(matcher, 2);
            int n3 = this.getGroupIntValue(matcher, 3);
            int n4 = this.getGroupIntValue(matcher, 4);
            int n5 = this.getGroupIntValue(matcher, 5);
            return n * 86400000 + n2 * 3600000 + n3 * 60000 + n4 * 1000 + n5;
        }
        throw new IllegalArgumentException("invalid duration '" + string + "': it must match " + DURATION_PATTERN.pattern() + " or 'eternal'");
    }

    private int getGroupIntValue(java.util.regex.Matcher matcher, int n) {
        String string = matcher.group(n);
        return string == null || string.length() == 0 ? 0 : Integer.parseInt(string);
    }

    public boolean isCheckmodified() {
        if (this.checkmodified == null) {
            if (this.getSettings() != null) {
                String string = this.getSettings().getVariable("ivy.resolver.default.check.modified");
                return string != null ? Boolean.valueOf(string) : false;
            }
            return false;
        }
        return this.checkmodified;
    }

    public void setCheckmodified(boolean bl) {
        this.checkmodified = bl;
    }

    public boolean isUseOrigin() {
        if (this.useOrigin == null) {
            if (this.getSettings() != null) {
                return this.getSettings().isDefaultUseOrigin();
            }
            return false;
        }
        return this.useOrigin;
    }

    public void setUseOrigin(boolean bl) {
        this.useOrigin = bl;
    }

    public File getArchiveFileInCache(Artifact artifact) {
        ArtifactOrigin artifactOrigin = this.getSavedArtifactOrigin(artifact);
        return this.getArchiveFileInCache(artifact, artifactOrigin);
    }

    public File getArchiveFileInCache(Artifact artifact, ArtifactOrigin artifactOrigin) {
        File file;
        File file2 = new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, artifactOrigin));
        if (!file2.exists() && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal() && (file = Checks.checkAbsolute(artifactOrigin.getLocation(), artifact + " origin location")).exists()) {
            return file;
        }
        return file2;
    }

    private File getArchiveFileInCache(Artifact artifact, ArtifactOrigin artifactOrigin, boolean bl) {
        if (bl && !ArtifactOrigin.isUnknown(artifactOrigin) && artifactOrigin.isLocal()) {
            return Checks.checkAbsolute(artifactOrigin.getLocation(), artifact + " origin location");
        }
        return new File(this.getRepositoryCacheRoot(), this.getArchivePathInCache(artifact, artifactOrigin));
    }

    public String getArchivePathInCache(Artifact artifact) {
        return IvyPatternHelper.substitute(this.getArtifactPattern(), artifact);
    }

    public String getArchivePathInCache(Artifact artifact, ArtifactOrigin artifactOrigin) {
        if (this.isOriginalMetadataArtifact(artifact)) {
            return IvyPatternHelper.substitute(this.getIvyPattern() + ".original", artifact, artifactOrigin);
        }
        return IvyPatternHelper.substitute(this.getArtifactPattern(), artifact, artifactOrigin);
    }

    private void saveResolver(ModuleDescriptor moduleDescriptor, String string) {
        PropertiesFile propertiesFile = this.getCachedDataFile(moduleDescriptor);
        propertiesFile.setProperty("resolver", string);
        propertiesFile.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResolvers(ModuleDescriptor moduleDescriptor, String string, String string2) {
        ModuleRevisionId moduleRevisionId = moduleDescriptor.getResolvedModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleDescriptor);
            propertiesFile.setProperty("resolver", string);
            propertiesFile.setProperty("artifact.resolver", string2);
            propertiesFile.save();
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String getSavedResolverName(ModuleDescriptor moduleDescriptor) {
        PropertiesFile propertiesFile = this.getCachedDataFile(moduleDescriptor);
        return propertiesFile.getProperty("resolver");
    }

    private String getSavedArtResolverName(ModuleDescriptor moduleDescriptor) {
        PropertiesFile propertiesFile = this.getCachedDataFile(moduleDescriptor);
        return propertiesFile.getProperty("artifact.resolver");
    }

    void saveArtifactOrigin(Artifact artifact, ArtifactOrigin artifactOrigin) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.setProperty(this.getIsLocalKey(artifact), String.valueOf(artifactOrigin.isLocal()));
        propertiesFile.setProperty(this.getLocationKey(artifact), artifactOrigin.getLocation());
        if (artifactOrigin.getLastChecked() != null) {
            propertiesFile.setProperty(this.getLastCheckedKey(artifact), artifactOrigin.getLastChecked().toString());
        }
        propertiesFile.setProperty(this.getExistsKey(artifact), Boolean.toString(artifactOrigin.isExists()));
        propertiesFile.save();
    }

    private void removeSavedArtifactOrigin(Artifact artifact) {
        PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
        propertiesFile.remove(this.getLocationKey(artifact));
        propertiesFile.remove(this.getIsLocalKey(artifact));
        propertiesFile.remove(this.getLastCheckedKey(artifact));
        propertiesFile.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactOrigin getSavedArtifactOrigin(Artifact artifact) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return ArtifactOrigin.unkwnown(artifact);
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(artifact.getModuleRevisionId());
            String string = propertiesFile.getProperty(this.getLocationKey(artifact));
            String string2 = propertiesFile.getProperty(this.getIsLocalKey(artifact));
            String string3 = propertiesFile.getProperty(this.getLastCheckedKey(artifact));
            String string4 = propertiesFile.getProperty(this.getExistsKey(artifact));
            boolean bl = Boolean.valueOf(string2);
            if (string == null) {
                ArtifactOrigin artifactOrigin = ArtifactOrigin.unkwnown(artifact);
                return artifactOrigin;
            }
            ArtifactOrigin artifactOrigin = new ArtifactOrigin(artifact, bl, string);
            if (string3 != null) {
                artifactOrigin.setLastChecked(Long.valueOf(string3));
            }
            if (string4 != null) {
                artifactOrigin.setExist(Boolean.valueOf(string4));
            }
            ArtifactOrigin artifactOrigin2 = artifactOrigin;
            return artifactOrigin2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String getPrefixKey(Artifact artifact) {
        int n = artifact.getId().hashCode();
        return "artifact:" + artifact.getName() + "#" + artifact.getType() + "#" + artifact.getExt() + "#" + n;
    }

    private String getLocationKey(Artifact artifact) {
        String string = this.getPrefixKey(artifact);
        return string + ".location";
    }

    private String getIsLocalKey(Artifact artifact) {
        String string = this.getPrefixKey(artifact);
        return string + ".is-local";
    }

    private String getLastCheckedKey(Artifact artifact) {
        String string = this.getPrefixKey(artifact);
        return string + ".lastchecked";
    }

    private String getExistsKey(Artifact artifact) {
        String string = this.getPrefixKey(artifact);
        return string + ".exists";
    }

    private PropertiesFile getCachedDataFile(ModuleDescriptor moduleDescriptor) {
        return this.getCachedDataFile(moduleDescriptor.getResolvedModuleRevisionId());
    }

    private PropertiesFile getCachedDataFile(ModuleRevisionId moduleRevisionId) {
        return new PropertiesFile(new File(this.getRepositoryCacheRoot(), IvyPatternHelper.substitute(this.getDataFilePattern(), moduleRevisionId)), "ivy cached data file for " + moduleRevisionId);
    }

    @Override
    public ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions, String string) {
        ModuleRevisionId moduleRevisionId2 = moduleRevisionId;
        if (this.isCheckmodified(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": checkModified=true");
            return null;
        }
        if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
            Message.verbose("don't use cache for " + moduleRevisionId2 + ": changing=true");
            return null;
        }
        return this.doFindModuleInCache(moduleRevisionId2, cacheMetadataOptions, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResolvedModuleRevision doFindModuleInCache(ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions, String string) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        boolean bl = true;
        try {
            Object object;
            if (this.settings.getVersionMatcher().isDynamic(moduleRevisionId)) {
                object = this.getResolvedRevision(moduleRevisionId, cacheMetadataOptions);
                if (object == null) {
                    ResolvedModuleRevision resolvedModuleRevision = null;
                    return resolvedModuleRevision;
                }
                Message.verbose("found resolved revision in cache: " + moduleRevisionId + " => " + (String)object);
                this.unlockMetadataArtifact(moduleRevisionId);
                moduleRevisionId = ModuleRevisionId.newInstance(moduleRevisionId, (String)object);
                if (!this.lockMetadataArtifact(moduleRevisionId)) {
                    Message.error("impossible to acquire lock for " + moduleRevisionId);
                    bl = false;
                    ResolvedModuleRevision resolvedModuleRevision = null;
                    return resolvedModuleRevision;
                }
            }
            if (((File)(object = this.getIvyFileInCache(moduleRevisionId))).exists()) {
                try {
                    DependencyResolver dependencyResolver;
                    XmlModuleDescriptorParser xmlModuleDescriptorParser = XmlModuleDescriptorParser.getInstance();
                    ModuleDescriptor moduleDescriptor = this.getMdFromCache(xmlModuleDescriptorParser, cacheMetadataOptions, (File)object);
                    String string2 = this.getSavedResolverName(moduleDescriptor);
                    String string3 = this.getSavedArtResolverName(moduleDescriptor);
                    DependencyResolver dependencyResolver2 = this.settings.getResolver(string2);
                    if (dependencyResolver2 == null) {
                        Message.debug("\tresolver not found: " + string2 + " => trying to use the one configured for " + moduleRevisionId);
                        dependencyResolver2 = this.settings.getResolver(moduleDescriptor.getResolvedModuleRevisionId());
                        if (dependencyResolver2 != null) {
                            Message.debug("\tconfigured resolver found for " + moduleDescriptor.getResolvedModuleRevisionId() + ": " + dependencyResolver2.getName() + ": saving this data");
                            this.saveResolver(moduleDescriptor, dependencyResolver2.getName());
                        }
                    }
                    if ((dependencyResolver = this.settings.getResolver(string3)) == null) {
                        dependencyResolver = dependencyResolver2;
                    }
                    if (dependencyResolver2 != null) {
                        Message.debug("\tfound ivy file in cache for " + moduleRevisionId + " (resolved by " + dependencyResolver2.getName() + "): " + object);
                        if (string == null || string.equals(dependencyResolver2.getName())) {
                            MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
                            metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                            metadataArtifactDownloadReport.setSearched(false);
                            metadataArtifactDownloadReport.setLocalFile((File)object);
                            metadataArtifactDownloadReport.setSize(((File)object).length());
                            metadataArtifactDownloadReport.setArtifactOrigin(this.getSavedArtifactOrigin(moduleDescriptor.getMetadataArtifact()));
                            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(dependencyResolver2, dependencyResolver, moduleDescriptor, metadataArtifactDownloadReport);
                            return resolvedModuleRevision;
                        }
                        Message.debug("found module in cache but with a different resolver: discarding: " + moduleRevisionId + "; expected resolver=" + string + "; resolver=" + dependencyResolver2.getName());
                        return null;
                    }
                    Message.debug("\tresolver not found: " + string2 + " => cannot use cached ivy file for " + moduleRevisionId);
                    return null;
                }
                catch (Exception exception) {
                    Message.debug("\tproblem while parsing cached ivy file for: " + moduleRevisionId + ": " + exception.getMessage());
                    return null;
                }
            }
            Message.debug("\tno ivy file in cache for " + moduleRevisionId + ": tried " + object);
            return null;
        }
        finally {
            if (bl) {
                this.unlockMetadataArtifact(moduleRevisionId);
            }
        }
    }

    private ModuleDescriptor getMdFromCache(XmlModuleDescriptorParser xmlModuleDescriptorParser, CacheMetadataOptions cacheMetadataOptions, File file) throws ParseException, IOException {
        ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = this.getMemoryCache();
        MyModuleDescriptorProvider myModuleDescriptorProvider = new MyModuleDescriptorProvider(xmlModuleDescriptorParser, this.settings);
        return moduleDescriptorMemoryCache.get(file, this.settings, cacheMetadataOptions.isValidate(), myModuleDescriptorProvider);
    }

    private ModuleDescriptor getStaledMd(ModuleDescriptorParser moduleDescriptorParser, CacheMetadataOptions cacheMetadataOptions, File file, ParserSettings parserSettings) throws ParseException, IOException {
        ModuleDescriptorMemoryCache moduleDescriptorMemoryCache = this.getMemoryCache();
        MyModuleDescriptorProvider myModuleDescriptorProvider = new MyModuleDescriptorProvider(moduleDescriptorParser, parserSettings);
        return moduleDescriptorMemoryCache.getStale(file, this.settings, cacheMetadataOptions.isValidate(), myModuleDescriptorProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResolvedRevision(ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        try {
            long l;
            String string = null;
            if (cacheMetadataOptions.isForce()) {
                Message.verbose("refresh mode: no check for cached resolved revision for " + moduleRevisionId);
                String string2 = null;
                return string2;
            }
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleRevisionId);
            string = propertiesFile.getProperty("resolved.revision");
            if (string == null) {
                Message.verbose(this.getName() + ": no cached resolved revision for " + moduleRevisionId);
                String string3 = null;
                return string3;
            }
            String string4 = propertiesFile.getProperty("resolved.time");
            if (string4 == null) {
                Message.verbose(this.getName() + ": inconsistent or old cache: no cached resolved time for " + moduleRevisionId);
                this.saveResolvedRevision(moduleRevisionId, string);
                String string5 = string;
                return string5;
            }
            if (cacheMetadataOptions.isCheckTTL() && (l = Long.parseLong(string4) + this.getTTL(moduleRevisionId)) > 0L && System.currentTimeMillis() > l) {
                Message.verbose(this.getName() + ": cached resolved revision expired for " + moduleRevisionId);
                String string6 = null;
                return string6;
            }
            String string7 = string;
            return string7;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveResolvedRevision(ModuleRevisionId moduleRevisionId, String string) {
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return;
        }
        try {
            PropertiesFile propertiesFile = this.getCachedDataFile(moduleRevisionId);
            propertiesFile.setProperty("resolved.time", String.valueOf(System.currentTimeMillis()));
            propertiesFile.setProperty("resolved.revision", string);
            propertiesFile.save();
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    public long getTTL(ModuleRevisionId moduleRevisionId) {
        Long l = (Long)this.ttlRules.getRule(moduleRevisionId);
        return l == null ? this.getDefaultTTL() : l.longValue();
    }

    public String toString() {
        return this.name;
    }

    public File getRepositoryCacheRoot() {
        return this.getBasedir();
    }

    public LockStrategy getLockStrategy() {
        if (this.lockStrategy == null) {
            this.lockStrategy = this.lockStrategyName != null ? this.settings.getLockStrategy(this.lockStrategyName) : this.settings.getDefaultLockStrategy();
        }
        return this.lockStrategy;
    }

    public void setLockStrategy(LockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    public void setLockStrategy(String string) {
        this.lockStrategyName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactDownloadReport download(Artifact artifact, ArtifactResourceResolver artifactResourceResolver, ResourceDownloader resourceDownloader, CacheDownloadOptions cacheDownloadOptions) {
        ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifact);
        boolean bl = this.isUseOrigin();
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
            artifactDownloadReport.setDownloadDetails("impossible to get lock for " + moduleRevisionId);
            return artifactDownloadReport;
        }
        try {
            ArtifactOrigin artifactOrigin;
            File file;
            DownloadListener downloadListener = cacheDownloadOptions.getListener();
            if (downloadListener != null) {
                downloadListener.needArtifact(this, artifact);
            }
            if ((file = this.getArchiveFileInCache(artifact, artifactOrigin = this.getSavedArtifactOrigin(artifact), bl)).exists() && !cacheDownloadOptions.isForce()) {
                artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                artifactDownloadReport.setSize(file.length());
                artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                artifactDownloadReport.setLocalFile(file);
            } else {
                long l = System.currentTimeMillis();
                try {
                    ResolvedResource resolvedResource = artifactResourceResolver.resolve(artifact);
                    if (resolvedResource != null) {
                        artifactOrigin = new ArtifactOrigin(artifact, resolvedResource.getResource().isLocal(), resolvedResource.getResource().getName());
                        if (bl && resolvedResource.getResource().isLocal()) {
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            file = this.getArchiveFileInCache(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                            artifactDownloadReport.setSize(file.length());
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file);
                        } else {
                            file = this.getArchiveFileInCache(artifact, artifactOrigin, bl);
                            if (ResourceHelper.equals(resolvedResource.getResource(), file)) {
                                throw new IllegalStateException("invalid settings for '" + artifactResourceResolver + "': pointing repository to ivy cache is forbidden !");
                            }
                            if (downloadListener != null) {
                                downloadListener.startArtifactDownload(this, resolvedResource, artifact, artifactOrigin);
                            }
                            resourceDownloader.download(artifact, resolvedResource.getResource(), file);
                            artifactDownloadReport.setSize(file.length());
                            this.saveArtifactOrigin(artifact, artifactOrigin);
                            artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                            artifactDownloadReport.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                            artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                            artifactDownloadReport.setLocalFile(file);
                        }
                    } else {
                        artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                        artifactDownloadReport.setDownloadDetails("missing artifact");
                        artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                    }
                }
                catch (Exception exception) {
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                    artifactDownloadReport.setDownloadDetails(exception.getMessage());
                    artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                }
            }
            if (downloadListener != null) {
                downloadListener.endArtifactDownload(this, artifact, artifactDownloadReport, file);
            }
            ArtifactDownloadReport artifactDownloadReport2 = artifactDownloadReport;
            return artifactDownloadReport2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactDownloadReport downloadRepositoryResource(Resource resource, String string, String string2, String string3, CacheResourceOptions cacheResourceOptions, Repository repository) {
        String string4 = this.computeResourceNameHash(resource);
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance("_repository_metadata_", string4, Ivy.getWorkingRevision());
        DefaultArtifact defaultArtifact = new DefaultArtifact(moduleRevisionId, null, string, string2, string3);
        ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(defaultArtifact);
        boolean bl = this.isUseOrigin();
        try {
            DownloadListener downloadListener = cacheResourceOptions.getListener();
            if (downloadListener != null) {
                downloadListener.needArtifact(this, defaultArtifact);
            }
            ArtifactOrigin artifactOrigin = this.getSavedArtifactOrigin(defaultArtifact);
            File file = this.getArchiveFileInCache(defaultArtifact, artifactOrigin, bl);
            ArtifactOrigin artifactOrigin2 = new ArtifactOrigin(defaultArtifact, resource.isLocal(), resource.getName());
            if (!cacheResourceOptions.isForce() && this.checkCacheUptodate(file, resource, artifactOrigin, artifactOrigin2, cacheResourceOptions.getTtl())) {
                if (file.exists()) {
                    this.saveArtifactOrigin(defaultArtifact, artifactOrigin2);
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                    artifactDownloadReport.setSize(file.length());
                    artifactDownloadReport.setArtifactOrigin(artifactOrigin);
                    artifactDownloadReport.setLocalFile(file);
                } else {
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                    artifactDownloadReport.setDownloadDetails("Remote resource is known to not exist");
                }
            } else {
                long l = System.currentTimeMillis();
                artifactOrigin2.setLastChecked(new Long(l));
                try {
                    ResolvedResource resolvedResource = new ResolvedResource(resource, Ivy.getWorkingRevision());
                    if (bl && resource.isLocal()) {
                        this.saveArtifactOrigin(defaultArtifact, artifactOrigin2);
                        file = this.getArchiveFileInCache(defaultArtifact, artifactOrigin2);
                        artifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
                        artifactDownloadReport.setSize(file.length());
                        artifactDownloadReport.setArtifactOrigin(artifactOrigin2);
                        artifactDownloadReport.setLocalFile(file);
                    } else {
                        if (downloadListener != null) {
                            downloadListener.startArtifactDownload(this, resolvedResource, defaultArtifact, artifactOrigin2);
                        }
                        if (file.exists()) {
                            file.delete();
                        }
                        File file2 = new File(file.getAbsolutePath() + ".part");
                        repository.get(resource.getName(), file2);
                        if (!file2.renameTo(file)) {
                            throw new IOException("impossible to move part file to definitive one: " + file2 + " -> " + file);
                        }
                        artifactDownloadReport.setSize(file.length());
                        this.saveArtifactOrigin(defaultArtifact, artifactOrigin2);
                        artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                        artifactDownloadReport.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                        artifactDownloadReport.setArtifactOrigin(artifactOrigin2);
                        artifactDownloadReport.setLocalFile(file);
                    }
                }
                catch (Exception exception) {
                    artifactOrigin2.setExist(false);
                    this.saveArtifactOrigin(defaultArtifact, artifactOrigin2);
                    artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
                    artifactDownloadReport.setDownloadDetails(exception.getMessage());
                    artifactDownloadReport.setDownloadTimeMillis(System.currentTimeMillis() - l);
                }
            }
            if (downloadListener != null) {
                downloadListener.endArtifactDownload(this, defaultArtifact, artifactDownloadReport, file);
            }
            ArtifactDownloadReport artifactDownloadReport2 = artifactDownloadReport;
            return artifactDownloadReport2;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    private String computeResourceNameHash(Resource resource) {
        byte[] byArray;
        try {
            byArray = SHA_DIGEST.digest(resource.getName().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return HexEncoder.encode(byArray);
    }

    private boolean checkCacheUptodate(File file, Resource resource, ArtifactOrigin artifactOrigin, ArtifactOrigin artifactOrigin2, long l) {
        long l2 = System.currentTimeMillis();
        if (artifactOrigin.getLastChecked() != null && l2 - artifactOrigin.getLastChecked() < l) {
            if (!file.exists()) {
                return !artifactOrigin.isExists();
            }
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        artifactOrigin2.setLastChecked(new Long(l2));
        return file.lastModified() >= resource.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void originalToCachedModuleDescriptor(DependencyResolver dependencyResolver, ResolvedResource resolvedResource, Artifact artifact, ResolvedModuleRevision resolvedModuleRevision, ModuleDescriptorWriter moduleDescriptorWriter) {
        ModuleDescriptor moduleDescriptor = resolvedModuleRevision.getDescriptor();
        Artifact artifact2 = this.getOriginalMetadataArtifact(artifact);
        File file = this.getIvyFileInCache(moduleDescriptor.getResolvedModuleRevisionId());
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.warn("impossible to acquire lock for: " + moduleRevisionId);
            return;
        }
        try {
            File file2 = this.getArchiveFileInCache(artifact2);
            moduleDescriptorWriter.write(resolvedResource, moduleDescriptor, file2, file);
            this.getMemoryCache().putInCache(file, new ParserSettingsMonitor(this.settings), true, moduleDescriptor);
            this.saveResolvers(moduleDescriptor, dependencyResolver.getName(), dependencyResolver.getName());
            if (!moduleDescriptor.isDefault()) {
                resolvedModuleRevision.getReport().setOriginalLocalFile(file2);
            }
            resolvedModuleRevision.getReport().setLocalFile(file);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Message.warn("impossible to put metadata file in cache: " + (resolvedResource == null ? String.valueOf(moduleDescriptor.getResolvedModuleRevisionId()) : String.valueOf(resolvedResource)) + ". " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvedModuleRevision cacheModuleDescriptor(DependencyResolver dependencyResolver, final ResolvedResource resolvedResource, DependencyDescriptor dependencyDescriptor, Artifact artifact, ResourceDownloader resourceDownloader, CacheMetadataOptions cacheMetadataOptions) throws ParseException {
        Date date = null;
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (!this.lockMetadataArtifact(moduleRevisionId)) {
            Message.error("impossible to acquire lock for " + moduleRevisionId);
            return null;
        }
        BackupResourceDownloader backupResourceDownloader = new BackupResourceDownloader(resourceDownloader);
        try {
            Object object;
            Object object2;
            ModuleDescriptor moduleDescriptor;
            if (!artifact.isMetadata()) {
                if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                    ArtifactOrigin artifactOrigin;
                    long l = resolvedResource.getLastModified();
                    Artifact artifact2 = NameSpaceHelper.transform(artifact, cacheMetadataOptions.getNamespace().getToSystemTransformer());
                    File file = this.getArchiveFileInCache(artifact2, artifactOrigin = this.getSavedArtifactOrigin(artifact2), false);
                    if (file.exists() && l > file.lastModified()) {
                        Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                        Message.debug("deleting " + file);
                        if (!file.delete()) {
                            Message.error("Couldn't delete outdated artifact from cache: " + file);
                            ResolvedModuleRevision resolvedModuleRevision = null;
                            return resolvedModuleRevision;
                        }
                        this.removeSavedArtifactOrigin(artifact2);
                    }
                }
                ResolvedModuleRevision resolvedModuleRevision = null;
                return resolvedModuleRevision;
            }
            ResolvedModuleRevision resolvedModuleRevision = this.doFindModuleInCache(moduleRevisionId, cacheMetadataOptions, null);
            if (resolvedModuleRevision != null) {
                if (resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision.getResolver() != dependencyResolver) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + moduleRevisionId + " (resolved by " + resolvedModuleRevision.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else {
                    if (!this.isCheckmodified(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions) && !this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                        Message.verbose("\t" + this.getName() + ": revision in cache: " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision2 = resolvedModuleRevision;
                        return resolvedModuleRevision2;
                    }
                    long l = resolvedResource.getLastModified();
                    long l2 = resolvedModuleRevision.getDescriptor().getLastModified();
                    if (!resolvedModuleRevision.getDescriptor().isDefault() && l <= l2) {
                        Message.verbose("\t" + this.getName() + ": revision in cache (not updated): " + moduleRevisionId);
                        resolvedModuleRevision.getReport().setSearched(true);
                        ResolvedModuleRevision resolvedModuleRevision3 = resolvedModuleRevision;
                        return resolvedModuleRevision3;
                    }
                    Message.verbose("\t" + this.getName() + ": revision in cache is not up to date: " + moduleRevisionId);
                    if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                        date = resolvedModuleRevision.getDescriptor().getResolvedPublicationDate();
                    }
                }
            }
            Artifact artifact3 = this.getOriginalMetadataArtifact(artifact);
            ArtifactDownloadReport artifactDownloadReport = this.download(artifact3, new ArtifactResourceResolver(){

                @Override
                public ResolvedResource resolve(Artifact artifact) {
                    return resolvedResource;
                }
            }, backupResourceDownloader, new CacheDownloadOptions().setListener(cacheMetadataOptions.getListener()).setForce(true));
            Message.verbose("\t" + artifactDownloadReport);
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
                Message.warn("problem while downloading module descriptor: " + resolvedResource.getResource() + ": " + artifactDownloadReport.getDownloadDetails() + " (" + artifactDownloadReport.getDownloadTimeMillis() + "ms)");
                ResolvedModuleRevision resolvedModuleRevision4 = null;
                return resolvedModuleRevision4;
            }
            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser(resolvedResource.getResource());
            ParserSettings parserSettings = this.settings;
            if (dependencyResolver instanceof AbstractResolver) {
                parserSettings = ((AbstractResolver)dependencyResolver).getParserSettings();
            }
            if ((moduleDescriptor = this.getStaledMd(moduleDescriptorParser, cacheMetadataOptions, artifactDownloadReport.getLocalFile(), parserSettings)) == null) {
                throw new IllegalStateException("module descriptor parser returned a null module descriptor, which is not allowed. parser=" + moduleDescriptorParser + "; parser class=" + moduleDescriptorParser.getClass().getName() + "; module descriptor resource=" + resolvedResource.getResource());
            }
            Message.debug("\t" + this.getName() + ": parsed downloaded md file for " + moduleRevisionId + "; parsed=" + moduleDescriptor.getModuleRevisionId());
            boolean bl = false;
            if (date != null && !date.equals(moduleDescriptor.getResolvedPublicationDate())) {
                Message.verbose(moduleRevisionId + " has changed: deleting old artifacts");
                bl = true;
            }
            if (bl) {
                object2 = moduleDescriptor.getConfigurationsNames();
                for (int i = 0; i < ((String[])object2).length; ++i) {
                    object = moduleDescriptor.getArtifacts(object2[i]);
                    for (int j = 0; j < ((Artifact[])object).length; ++j) {
                        ArtifactOrigin artifactOrigin;
                        Artifact artifact4 = NameSpaceHelper.transform(object[j], cacheMetadataOptions.getNamespace().getToSystemTransformer());
                        File file = this.getArchiveFileInCache(artifact4, artifactOrigin = this.getSavedArtifactOrigin(artifact4), false);
                        if (file.exists()) {
                            Message.debug("deleting " + file);
                            if (!file.delete()) {
                                backupResourceDownloader.restore();
                                Message.error("Couldn't delete outdated artifact from cache: " + file);
                                ResolvedModuleRevision resolvedModuleRevision5 = null;
                                return resolvedModuleRevision5;
                            }
                        }
                        this.removeSavedArtifactOrigin(artifact4);
                    }
                }
            } else if (this.isChanging(dependencyDescriptor, moduleRevisionId, cacheMetadataOptions)) {
                Message.verbose(moduleRevisionId + " is changing, but has not changed: will trust cached artifacts if any");
            }
            object2 = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
            ((MetadataArtifactDownloadReport)object2).setSearched(true);
            ((ArtifactDownloadReport)object2).setDownloadStatus(artifactDownloadReport.getDownloadStatus());
            ((ArtifactDownloadReport)object2).setDownloadDetails(artifactDownloadReport.getDownloadDetails());
            ((ArtifactDownloadReport)object2).setArtifactOrigin(artifactDownloadReport.getArtifactOrigin());
            ((ArtifactDownloadReport)object2).setDownloadTimeMillis(artifactDownloadReport.getDownloadTimeMillis());
            ((MetadataArtifactDownloadReport)object2).setOriginalLocalFile(artifactDownloadReport.getLocalFile());
            ((ArtifactDownloadReport)object2).setSize(artifactDownloadReport.getSize());
            Artifact artifact5 = NameSpaceHelper.transform(moduleDescriptor.getMetadataArtifact(), cacheMetadataOptions.getNamespace().getToSystemTransformer());
            this.saveArtifactOrigin(artifact5, artifactDownloadReport.getArtifactOrigin());
            object = new ResolvedModuleRevision(dependencyResolver, dependencyResolver, moduleDescriptor, (MetadataArtifactDownloadReport)object2);
            return object;
        }
        finally {
            this.unlockMetadataArtifact(moduleRevisionId);
            backupResourceDownloader.cleanUp();
        }
    }

    private boolean lockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = this.getDefaultMetadataArtifact(moduleRevisionId);
        try {
            return this.getLockStrategy().lockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("operation interrupted");
        }
    }

    private void unlockMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        Artifact artifact = this.getDefaultMetadataArtifact(moduleRevisionId);
        this.getLockStrategy().unlockArtifact(artifact, this.getArchiveFileInCache(artifact, this.getDefaultMetadataArtifactOrigin(moduleRevisionId)));
    }

    private ArtifactOrigin getDefaultMetadataArtifactOrigin(ModuleRevisionId moduleRevisionId) {
        return new ArtifactOrigin(DefaultArtifact.newIvyArtifact(moduleRevisionId, null), false, this.getIvyFileInCache(moduleRevisionId).getPath());
    }

    private Artifact getDefaultMetadataArtifact(ModuleRevisionId moduleRevisionId) {
        return new DefaultArtifact(moduleRevisionId, new Date(), "metadata", "metadata", "ivy", true);
    }

    public Artifact getOriginalMetadataArtifact(Artifact artifact) {
        return DefaultArtifact.cloneWithAnotherType(artifact, artifact.getType() + ".original");
    }

    private boolean isOriginalMetadataArtifact(Artifact artifact) {
        return artifact.isMetadata() && artifact.getType().endsWith(".original");
    }

    private boolean isChanging(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        return dependencyDescriptor.isChanging() || this.getChangingMatcher(cacheMetadataOptions).matches(moduleRevisionId.getRevision());
    }

    private Matcher getChangingMatcher(CacheMetadataOptions cacheMetadataOptions) {
        String string;
        String string2 = string = cacheMetadataOptions.getChangingPattern() != null ? cacheMetadataOptions.getChangingPattern() : this.changingPattern;
        if (string == null) {
            return NoMatcher.INSTANCE;
        }
        String string3 = cacheMetadataOptions.getChangingMatcherName() != null ? cacheMetadataOptions.getChangingMatcherName() : this.changingMatcherName;
        PatternMatcher patternMatcher = this.settings.getMatcher(string3);
        if (patternMatcher == null) {
            throw new IllegalStateException("unknown matcher '" + string3 + "'. It is set as changing matcher in " + this);
        }
        return patternMatcher.getMatcher(string);
    }

    private boolean isCheckmodified(DependencyDescriptor dependencyDescriptor, ModuleRevisionId moduleRevisionId, CacheMetadataOptions cacheMetadataOptions) {
        if (cacheMetadataOptions.isCheckmodified() != null) {
            return cacheMetadataOptions.isCheckmodified();
        }
        return this.isCheckmodified();
    }

    @Override
    public void clean() {
        FileUtil.forceDelete(this.getBasedir());
    }

    public void dumpSettings() {
        Message.verbose("\t" + this.getName());
        Message.debug("\t\tivyPattern: " + this.getIvyPattern());
        Message.debug("\t\tartifactPattern: " + this.getArtifactPattern());
        Message.debug("\t\tlockingStrategy: " + this.getLockStrategy().getName());
        Message.debug("\t\tchangingPattern: " + this.getChangingPattern());
        Message.debug("\t\tchangingMatcher: " + this.getChangingMatcherName());
    }

    static {
        try {
            SHA_DIGEST = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("The SHA1 algorithm is not available in your classpath", noSuchAlgorithmException);
        }
        DURATION_PATTERN = Pattern.compile("(?:(\\d+)d)? ?(?:(\\d+)h)? ?(?:(\\d+)m)? ?(?:(\\d+)s)? ?(?:(\\d+)ms)?");
    }

    private final class BackupResourceDownloader
    implements ResourceDownloader {
        private ResourceDownloader delegate;
        private File backup;
        private String originalPath;

        private BackupResourceDownloader(ResourceDownloader resourceDownloader) {
            this.delegate = resourceDownloader;
        }

        @Override
        public void download(Artifact artifact, Resource resource, File file) throws IOException {
            if (file.exists()) {
                this.originalPath = file.getAbsolutePath();
                this.backup = new File(file.getAbsolutePath() + ".backup");
                FileUtil.copy(file, this.backup, null, true);
            }
            this.delegate.download(artifact, resource, file);
        }

        public void restore() throws IOException {
            if (this.backup != null && this.backup.exists()) {
                File file = new File(this.originalPath);
                FileUtil.copy(this.backup, file, null, true);
                this.backup.delete();
            }
        }

        public void cleanUp() {
            if (this.backup != null && this.backup.exists()) {
                this.backup.delete();
            }
        }
    }

    private class MyModuleDescriptorProvider
    implements ModuleDescriptorProvider {
        private final ModuleDescriptorParser mdParser;
        private final ParserSettings settings;

        public MyModuleDescriptorProvider(ModuleDescriptorParser moduleDescriptorParser, ParserSettings parserSettings) {
            this.mdParser = moduleDescriptorParser;
            this.settings = parserSettings;
        }

        @Override
        public ModuleDescriptor provideModule(ParserSettings parserSettings, File file, boolean bl) throws ParseException, IOException {
            return this.mdParser.parseDescriptor(this.settings, file.toURI().toURL(), bl);
        }
    }
}

