/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.impl.ConfigImpl;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import play.api.Application;
import play.api.Configuration;
import play.api.Environment;
import play.api.Mode$;
import play.api.Play$;
import play.api.PlayException;
import play.utils.PlayIO$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.runtime.Null$;

public final class Configuration$
implements Serializable {
    public static final Configuration$ MODULE$;
    private ConfigParseOptions dontAllowMissingConfigOptions;
    private Config dontAllowMissingConfig;
    private volatile byte bitmap$0;

    static {
        new Configuration$();
    }

    private ConfigParseOptions dontAllowMissingConfigOptions$lzycompute() {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dontAllowMissingConfigOptions = ConfigParseOptions.defaults().setAllowMissing(false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.dontAllowMissingConfigOptions;
        }
    }

    private Config dontAllowMissingConfig$lzycompute() {
        Configuration$ configuration$ = this;
        synchronized (configuration$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dontAllowMissingConfig = ConfigFactory.load((ConfigParseOptions)this.dontAllowMissingConfigOptions());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.dontAllowMissingConfig;
        }
    }

    private ConfigParseOptions dontAllowMissingConfigOptions() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dontAllowMissingConfigOptions$lzycompute() : this.dontAllowMissingConfigOptions;
    }

    private Config dontAllowMissingConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dontAllowMissingConfig$lzycompute() : this.dontAllowMissingConfig;
    }

    public Configuration load(ClassLoader classLoader, Properties properties, scala.collection.immutable.Map<String, Object> directSettings, boolean allowMissingApplicationConf) {
        try {
            Config systemPropertyConfig = properties == System.getProperties() ? ConfigImpl.systemPropertiesAsConfig() : ConfigFactory.parseProperties((Properties)properties);
            Config directConfig = ConfigFactory.parseMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(directSettings).asJava()));
            Config applicationConfig = (Config)this.play$api$Configuration$$setting$1("config.resource", properties, directSettings).map((Function1)new Serializable(classLoader){
                public static final long serialVersionUID = 0L;
                private final ClassLoader classLoader$1;

                public final Config apply(Object resource2) {
                    return ConfigFactory.parseResources((ClassLoader)this.classLoader$1, (String)resource2.toString());
                }
                {
                    this.classLoader$1 = classLoader$1;
                }
            }).orElse((Function0)new Serializable(properties, directSettings){
                public static final long serialVersionUID = 0L;
                private final Properties properties$1;
                private final scala.collection.immutable.Map directSettings$1;

                public final Option<Config> apply() {
                    return Configuration$.MODULE$.play$api$Configuration$$setting$1("config.file", this.properties$1, this.directSettings$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Config apply(Object fileName) {
                            return ConfigFactory.parseFileAnySyntax((File)new File(fileName.toString()));
                        }
                    });
                }
                {
                    this.properties$1 = properties$1;
                    this.directSettings$1 = directSettings$1;
                }
            }).getOrElse((Function0)new Serializable(classLoader, allowMissingApplicationConf){
                public static final long serialVersionUID = 0L;
                private final ClassLoader classLoader$1;
                private final boolean allowMissingApplicationConf$1;

                public final Config apply() {
                    ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setClassLoader(this.classLoader$1).setAllowMissing(this.allowMissingApplicationConf$1);
                    return ConfigFactory.defaultApplication((ConfigParseOptions)parseOptions);
                }
                {
                    this.classLoader$1 = classLoader$1;
                    this.allowMissingApplicationConf$1 = allowMissingApplicationConf$1;
                }
            });
            Config playOverridesConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"play/reference-overrides.conf");
            Config referenceConfig = ConfigFactory.parseResources((ClassLoader)classLoader, (String)"reference.conf");
            Config combinedConfig = (Config)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Config[]{systemPropertyConfig, directConfig, applicationConfig, playOverridesConfig, referenceConfig}))).reduceLeft((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Config apply(Config x$1, Config x$2) {
                    return x$1.withFallback((ConfigMergeable)x$2);
                }
            });
            Config resolvedConfig = combinedConfig.resolve();
            return new Configuration(resolvedConfig);
        }
        catch (ConfigException configException) {
            throw this.configError(configException.origin(), configException.getMessage(), (Option<Throwable>)new Some((Object)configException));
        }
    }

    public Configuration load(File appPath, Enumeration.Value mode, scala.collection.immutable.Map<String, Object> devSettings) {
        Enumeration.Value currentMode;
        Enumeration.Value value = currentMode = (Enumeration.Value)Play$.MODULE$.maybeApplication().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Enumeration.Value apply(Application x$3) {
                return x$3.mode();
            }
        }).getOrElse((Function0)new Serializable(mode){
            public static final long serialVersionUID = 0L;
            private final Enumeration.Value mode$1;

            public final Enumeration.Value apply() {
                return this.mode$1;
            }
            {
                this.mode$1 = mode$1;
            }
        });
        Enumeration.Value value2 = Mode$.MODULE$.Prod();
        return !(value != null ? !value.equals(value2) : value2 != null) ? this.load(Thread.currentThread().getContextClassLoader(), System.getProperties(), (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty(), false) : this.load(Thread.currentThread().getContextClassLoader(), System.getProperties(), devSettings, true);
    }

    public Configuration load(Environment environment, scala.collection.immutable.Map<String, Object> devSettings) {
        Enumeration.Value value = environment.mode();
        Enumeration.Value value2 = Mode$.MODULE$.Test();
        return this.load(environment.classLoader(), System.getProperties(), devSettings, !(value != null ? !value.equals(value2) : value2 != null));
    }

    public Configuration load(Environment environment) {
        return this.load(environment, (scala.collection.immutable.Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public Enumeration.Value load$default$2() {
        return Mode$.MODULE$.Dev();
    }

    public scala.collection.immutable.Map<String, Object> load$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Configuration empty() {
        return new Configuration(ConfigFactory.empty());
    }

    public Configuration reference() {
        return new Configuration(ConfigFactory.defaultReference());
    }

    public Configuration from(scala.collection.immutable.Map<String, Object> data) {
        return new Configuration(ConfigFactory.parseMap((java.util.Map)((java.util.Map)this.play$api$Configuration$$toJava$1(data))));
    }

    public Configuration apply(Seq<Tuple2<String, Object>> data) {
        return this.from((scala.collection.immutable.Map<String, Object>)data.toMap(Predef$.MODULE$.$conforms()));
    }

    public PlayException configError(ConfigOrigin origin, String message, Option<Throwable> e) {
        Integer originLine = (Integer)Option$.MODULE$.apply((Object)Predef$.MODULE$.int2Integer(origin.lineNumber())).orNull(Predef$.MODULE$.$conforms());
        Option originUrl = Option$.MODULE$.apply((Object)origin.url());
        String originSourceName = (String)Option$.MODULE$.apply((Object)origin.filename()).orNull(Predef$.MODULE$.$conforms());
        return new PlayException.ExceptionSource(message, e, originLine, originUrl, originSourceName){
            private final Integer originLine$1;
            private final Option originUrl$1;
            private final String originSourceName$1;

            public Integer line() {
                return this.originLine$1;
            }

            public Null$ position() {
                return null;
            }

            public String input() {
                return (String)this.originUrl$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(URL url) {
                        return PlayIO$.MODULE$.readUrlAsString(url, Codec$.MODULE$.fallbackSystemCodec());
                    }
                }).orNull(Predef$.MODULE$.$conforms());
            }

            public String sourceName() {
                return this.originSourceName$1;
            }

            public String toString() {
                return new StringBuilder().append((Object)"Configuration error: ").append((Object)this.getMessage()).toString();
            }
            {
                this.originLine$1 = originLine$1;
                this.originUrl$1 = originUrl$1;
                this.originSourceName$1 = originSourceName$1;
                super("Configuration error", message$1, (Throwable)e$1.orNull(Predef$.MODULE$.$conforms()));
            }
        };
    }

    public Option<Throwable> configError$default$3() {
        return None$.MODULE$;
    }

    public <A> Seq<A> asScalaList(List<A> l) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(l).asScala()).toList();
    }

    public Configuration apply(Config underlying) {
        return new Configuration(underlying);
    }

    public Option<Config> unapply(Configuration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.underlying());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final Option play$api$Configuration$$setting$1(String key, Properties properties$1, scala.collection.immutable.Map directSettings$1) {
        return directSettings$1.get((Object)key).orElse((Function0)new Serializable(properties$1, key){
            public static final long serialVersionUID = 0L;
            private final Properties properties$1;
            private final String key$1;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)this.properties$1.getProperty(this.key$1));
            }
            {
                this.properties$1 = properties$1;
                this.key$1 = key$1;
            }
        });
    }

    public final Object play$api$Configuration$$toJava$1(Object data) {
        Object object;
        Object object2 = data;
        if (object2 instanceof scala.collection.immutable.Map) {
            scala.collection.immutable.Map map2 = (scala.collection.immutable.Map)object2;
            object = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)map2.mapValues((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object data) {
                    return Configuration$.MODULE$.play$api$Configuration$$toJava$1(data);
                }
            })).asJava();
        } else if (object2 instanceof Iterable) {
            Iterable iterable = (Iterable)object2;
            object = JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)iterable.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(Object data) {
                    return Configuration$.MODULE$.play$api$Configuration$$toJava$1(data);
                }
            }, Iterable$.MODULE$.canBuildFrom())).asJava();
        } else {
            object = object2;
        }
        return object;
    }

    private Configuration$() {
        MODULE$ = this;
    }
}

