/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.Configuration;
import play.api.Environment;
import play.api.Logger$;
import play.api.Mode$;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.http.ContentTypeOf$;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpErrorHandler$class;
import play.api.http.HttpErrorHandlerExceptions$;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.mvc.Codec$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.routing.Router;
import play.core.SourceMapper;
import play.twirl.api.Html;
import scala.Enumeration;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import views.html.defaultpages.badRequest$;
import views.html.defaultpages.devError$;
import views.html.defaultpages.devNotFound$;
import views.html.defaultpages.error$;
import views.html.defaultpages.notFound$;
import views.html.defaultpages.unauthorized$;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0001\u0003\u0001%\u0011q\u0003R3gCVdG\u000f\u0013;ua\u0016\u0013(o\u001c:IC:$G.\u001a:\u000b\u0005\r!\u0011\u0001\u00025uiBT!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018NC\u0001\b\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001A\u0003\t\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\tIiR\u0004XI\u001d:pe\"\u000bg\u000e\u001a7fe\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0006f]ZL'o\u001c8nK:$\bCA\f\u0019\u001b\u0005!\u0011BA\r\u0005\u0005-)eN^5s_:lWM\u001c;\t\u0011m\u0001!\u0011!Q\u0001\nq\tQbY8oM&<WO]1uS>t\u0007CA\f\u001e\u0013\tqBAA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005a1o\\;sG\u0016l\u0015\r\u001d9feB\u00191B\t\u0013\n\u0005\rb!AB(qi&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\r\u0005!1m\u001c:f\u0013\tIcE\u0001\u0007T_V\u00148-Z'baB,'\u000f\u0003\u0005,\u0001\t\u0005I\u0015!\u0003-\u0003\u0019\u0011x.\u001e;feB\u00191\"L\u0018\n\u00059b!\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007-\u0011\u0003\u0007\u0005\u00022i5\t!G\u0003\u00024\t\u00059!o\\;uS:<\u0017BA\u001b3\u0005\u0019\u0011v.\u001e;fe\")q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"R!\u000f\u001e<yu\u0002\"!\u0005\u0001\t\u000bU1\u0004\u0019\u0001\f\t\u000bm1\u0004\u0019\u0001\u000f\t\u000f\u00012\u0004\u0013!a\u0001C!91F\u000eI\u0005\u0002\u0004a\u0003\"B\u001c\u0001\t\u0003yD#B\u001dA\u0003\n3\u0005\"B\u000b?\u0001\u00041\u0002\"B\u000e?\u0001\u0004a\u0002\"\u0002\u0011?\u0001\u0004\u0019\u0005CA\fE\u0013\t)EA\u0001\u000bPaRLwN\\1m'>,(oY3NCB\u0004XM\u001d\u0005\u0006Wy\u0002\ra\u0012\t\u0004\u00116\u0003T\"A%\u000b\u0005)[\u0015AB5oU\u0016\u001cGOC\u0001M\u0003\u0015Q\u0017M^1y\u0013\tq\u0015J\u0001\u0005Qe>4\u0018\u000eZ3sQ\tq\u0004\u000b\u0005\u0002I#&\u0011!+\u0013\u0002\u0007\u0013:TWm\u0019;\t\u000fQ\u0003\u0001\u0019!C\u0005+\u0006Q\u0001\u000f\\1z\u000b\u0012LGo\u001c:\u0016\u0003Y\u00032a\u0003\u0012X!\tA6L\u0004\u0002\f3&\u0011!\fD\u0001\u0007!J,G-\u001a4\n\u0005qk&AB*ue&twM\u0003\u0002[\u0019!9q\f\u0001a\u0001\n\u0013\u0001\u0017A\u00049mCf,E-\u001b;pe~#S-\u001d\u000b\u0003C\u0012\u0004\"a\u00032\n\u0005\rd!\u0001B+oSRDq!\u001a0\u0002\u0002\u0003\u0007a+A\u0002yIEBaa\u001a\u0001!B\u00131\u0016a\u00039mCf,E-\u001b;pe\u0002BQ!\u001b\u0001\u0005\u0002)\fQb]3u!2\f\u00170\u00123ji>\u0014HCA1l\u0011\u0015a\u0007\u000e1\u0001X\u0003\u0019)G-\u001b;pe\")a\u000e\u0001C\u0001_\u0006iqN\\\"mS\u0016tG/\u0012:s_J$b\u0001\u001d?\u0002\u0004\u00055\u0001cA9um6\t!O\u0003\u0002t\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005U\u0014(A\u0002$viV\u0014X\r\u0005\u0002xu6\t\u0001P\u0003\u0002z\t\u0005\u0019QN^2\n\u0005mD(A\u0002*fgVdG\u000fC\u0003~[\u0002\u0007a0A\u0004sKF,Xm\u001d;\u0011\u0005]|\u0018bAA\u0001q\ni!+Z9vKN$\b*Z1eKJDq!!\u0002n\u0001\u0004\t9!\u0001\u0006ti\u0006$Xo]\"pI\u0016\u00042aCA\u0005\u0013\r\tY\u0001\u0004\u0002\u0004\u0013:$\b\u0002CA\b[B\u0005\t\u0019A,\u0002\u000f5,7o]1hK\"9\u00111\u0003\u0001\u0005\u0012\u0005U\u0011\u0001D8o\u0005\u0006$'+Z9vKN$H#\u00029\u0002\u0018\u0005e\u0001BB?\u0002\u0012\u0001\u0007a\u0010C\u0004\u0002\u0010\u0005E\u0001\u0019A,\t\u000f\u0005u\u0001\u0001\"\u0005\u0002 \u0005YqN\u001c$pe\nLG\rZ3o)\u0015\u0001\u0018\u0011EA\u0012\u0011\u0019i\u00181\u0004a\u0001}\"9\u0011qBA\u000e\u0001\u00049\u0006bBA\u0014\u0001\u0011E\u0011\u0011F\u0001\u000b_:tu\u000e\u001e$pk:$G#\u00029\u0002,\u00055\u0002BB?\u0002&\u0001\u0007a\u0010C\u0004\u0002\u0010\u0005\u0015\u0002\u0019A,\t\u000f\u0005E\u0002\u0001\"\u0005\u00024\u0005\u0011rN\\(uQ\u0016\u00148\t\\5f]R,%O]8s)\u001d\u0001\u0018QGA\u001c\u0003sAa!`A\u0018\u0001\u0004q\b\u0002CA\u0003\u0003_\u0001\r!a\u0002\t\u000f\u0005=\u0011q\u0006a\u0001/\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012!D8o'\u0016\u0014h/\u001a:FeJ|'\u000fF\u0003q\u0003\u0003\n\u0019\u0005\u0003\u0004~\u0003w\u0001\rA \u0005\t\u0003\u000b\nY\u00041\u0001\u0002H\u0005IQ\r_2faRLwN\u001c\t\u0005\u0003\u0013\nIF\u0004\u0003\u0002L\u0005Uc\u0002BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u0003\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0019\u0011q\u000b\u0007\u0002\u000fA\f7m[1hK&!\u00111LA/\u0005%!\u0006N]8xC\ndWMC\u0002\u0002X1Aq!!\u0019\u0001\t#\t\u0019'\u0001\bm_\u001e\u001cVM\u001d<fe\u0016\u0013(o\u001c:\u0015\u000b\u0005\f)'a\u001a\t\ru\fy\u00061\u0001\u007f\u0011!\tI'a\u0018A\u0002\u0005-\u0014aD;tK\u001a,H.\u0012=dKB$\u0018n\u001c8\u0011\u0007]\ti'C\u0002\u0002p\u0011\u0011q\"V:fMVdW\t_2faRLwN\u001c\u0005\b\u0003g\u0002A\u0011CA;\u0003Ayg\u000eR3w'\u0016\u0014h/\u001a:FeJ|'\u000fF\u0003q\u0003o\nI\b\u0003\u0004~\u0003c\u0002\rA \u0005\t\u0003\u000b\n\t\b1\u0001\u0002l!9\u0011Q\u0010\u0001\u0005\u0012\u0005}\u0014!E8o!J|GmU3sm\u0016\u0014XI\u001d:peR)\u0001/!!\u0002\u0004\"1Q0a\u001fA\u0002yD\u0001\"!\u0012\u0002|\u0001\u0007\u00111\u000e\u0015\u0004\u0001\u0005\u001d\u0005c\u0001%\u0002\n&\u0019\u00111R%\u0003\u0013MKgn\u001a7fi>twaBAH\u0005!\u0005\u0011\u0011S\u0001\u0018\t\u00164\u0017-\u001e7u\u0011R$\b/\u0012:s_JD\u0015M\u001c3mKJ\u00042!EAJ\r\u0019\t!\u0001#\u0001\u0002\u0016N\u0019\u00111S\u001d\t\u000f]\n\u0019\n\"\u0001\u0002\u001aR\u0011\u0011\u0011\u0013\u0005\u000b\u0003;\u000b\u0019*%A\u0005\u0002\u0005}\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\"*\u001a\u0011%a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a.\u0002\u0014F\u0005I\u0011AA]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0018\u0016\u0004_\u0005\r\u0006")
public class DefaultHttpErrorHandler
implements HttpErrorHandler {
    private final Environment environment;
    private final Option<SourceMapper> sourceMapper;
    private final Function0<Option<Router>> router;
    private Option<String> playEditor;

    public static Option<Router> $lessinit$greater$default$4() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<SourceMapper> $lessinit$greater$default$3() {
        return DefaultHttpErrorHandler$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String onClientError$default$3() {
        return HttpErrorHandler$class.onClientError$default$3(this);
    }

    private Option<String> playEditor() {
        return this.playEditor;
    }

    private void playEditor_$eq(Option<String> x$1) {
        this.playEditor = x$1;
    }

    public void setPlayEditor(String editor) {
        this.playEditor_$eq((Option<String>)Option$.MODULE$.apply((Object)editor));
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        block6: {
            Future<Result> future;
            block3: {
                block5: {
                    int n;
                    block4: {
                        block2: {
                            n = statusCode;
                            if (Status$.MODULE$.BAD_REQUEST() != n) break block2;
                            future = this.onBadRequest(request, message);
                            break block3;
                        }
                        if (Status$.MODULE$.FORBIDDEN() != n) break block4;
                        future = this.onForbidden(request, message);
                        break block3;
                    }
                    if (Status$.MODULE$.NOT_FOUND() != n) break block5;
                    future = this.onNotFound(request, message);
                    break block3;
                }
                if (statusCode < 400 || statusCode >= 500) break block6;
                future = this.onOtherClientError(request, statusCode, message);
            }
            return future;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onClientError invoked with non client error status code ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)statusCode), message})));
    }

    public Future<Result> onBadRequest(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.BadRequest().apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onForbidden(RequestHeader request, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Forbidden().apply(unauthorized$.MODULE$.apply(), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onNotFound(RequestHeader request, String message) {
        Enumeration.Value value = this.environment.mode();
        Enumeration.Value value2 = Mode$.MODULE$.Prod();
        Enumeration.Value value3 = value;
        Html html = !(value2 != null ? !value2.equals(value3) : value3 != null) ? notFound$.MODULE$.apply(request.method(), request.uri()) : devNotFound$.MODULE$.apply(request.method(), request.uri(), (Option<Router>)((Option)this.router.apply()));
        return Future$.MODULE$.successful((Object)Results$.MODULE$.NotFound().apply(html, Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onOtherClientError(RequestHeader request, int statusCode, String message) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.Status(statusCode).apply(badRequest$.MODULE$.apply(request.method(), request.uri(), message), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        Future<Result> future;
        try {
            Enumeration.Value value = this.environment.mode();
            Enumeration.Value value2 = Mode$.MODULE$.Prod();
            UsefulException usefulException = HttpErrorHandlerExceptions$.MODULE$.throwableToUsefulException(this.sourceMapper, !(value != null ? !value.equals(value2) : value2 != null), exception);
            this.logServerError(request, usefulException);
            Enumeration.Value value3 = this.environment.mode();
            Enumeration.Value value4 = Mode$.MODULE$.Prod();
            Enumeration.Value value5 = value3;
            Future<Result> future2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.onProdServerError(request, usefulException) : this.onDevServerError(request, usefulException);
            future = future2;
        }
        catch (Throwable throwable) {
            Future<Result> future3;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            Logger$.MODULE$.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while handling error";
                }
            }, (Function0<Throwable>)new Serializable(this, e){
                public static final long serialVersionUID = 0L;
                private final Throwable e$1;

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
            future = future3 = Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError());
        }
        return future;
    }

    public void logServerError(RequestHeader request, UsefulException usefulException) {
        Logger$.MODULE$.error((Function0<String>)new Serializable(this, request, usefulException){
            public static final long serialVersionUID = 0L;
            private final RequestHeader request$1;
            private final UsefulException usefulException$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n                    |\n                    |! @%s - Internal server error, for (%s) [%s] ->\n                    | ")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.usefulException$1.id, this.request$1.method(), this.request$1.uri()}));
            }
            {
                this.request$1 = request$1;
                this.usefulException$1 = usefulException$1;
            }
        }, (Function0<Throwable>)new Serializable(this, usefulException){
            public static final long serialVersionUID = 0L;
            private final UsefulException usefulException$1;

            public final UsefulException apply() {
                return this.usefulException$1;
            }
            {
                this.usefulException$1 = usefulException$1;
            }
        });
    }

    public Future<Result> onDevServerError(RequestHeader request, UsefulException exception) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(devError$.MODULE$.apply(this.playEditor(), exception), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public Future<Result> onProdServerError(RequestHeader request, UsefulException exception) {
        return Future$.MODULE$.successful((Object)Results$.MODULE$.InternalServerError().apply(error$.MODULE$.apply(exception), Writeable$.MODULE$.writeableOf_Content(Codec$.MODULE$.utf_8(), ContentTypeOf$.MODULE$.contentTypeOf_Html(Codec$.MODULE$.utf_8()))));
    }

    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, Option<SourceMapper> sourceMapper, Function0<Option<Router>> router) {
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        this.router = router;
        HttpErrorHandler$class.$init$(this);
        this.playEditor = configuration.getString("play.editor", configuration.getString$default$2());
    }

    @Inject
    public DefaultHttpErrorHandler(Environment environment, Configuration configuration, OptionalSourceMapper sourceMapper, Provider<Router> router) {
        this(environment, configuration, sourceMapper.sourceMapper(), (Function0<Option<Router>>)new Serializable(router){
            public static final long serialVersionUID = 0L;
            private final Provider router$1;

            public final Some<Router> apply() {
                return new Some(this.router$1.get());
            }
            {
                this.router$1 = router$1;
            }
        });
    }
}

