/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import play.api.libs.MimeTypes;
import play.core.j.JavaRangeResult;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class RangeResults {
    private static Optional<String> rangeHeader() {
        Http.Request request = Http.Context.current().request();
        return Optional.ofNullable(request.getHeader("Range"));
    }

    private static Optional<String> mimeTypeFor(String string2) {
        Option<String> option = MimeTypes.forFileName(string2);
        return OptionConverters.toJava(option);
    }

    public static Result ofStream(InputStream inputStream) {
        return JavaRangeResult.ofStream(inputStream, RangeResults.rangeHeader(), null, Optional.empty());
    }

    public static Result ofStream(InputStream inputStream, long l) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(), null, Optional.empty());
    }

    public static Result ofStream(InputStream inputStream, long l, String string2) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(), string2, Optional.empty());
    }

    public static Result ofStream(InputStream inputStream, long l, String string2, String string3) {
        return JavaRangeResult.ofStream(l, inputStream, RangeResults.rangeHeader(), string2, Optional.ofNullable(string3));
    }

    public static Result ofPath(Path path) {
        return JavaRangeResult.ofPath(path, RangeResults.rangeHeader(), RangeResults.mimeTypeFor(path.toFile().getName()));
    }

    public static Result ofPath(Path path, String string2) {
        return JavaRangeResult.ofPath(path, RangeResults.rangeHeader(), string2, RangeResults.mimeTypeFor(string2));
    }

    public static Result ofFile(File file2) {
        return JavaRangeResult.ofFile(file2, RangeResults.rangeHeader(), RangeResults.mimeTypeFor(file2.getName()));
    }

    public static Result ofFile(File file2, String string2) {
        return JavaRangeResult.ofFile(file2, RangeResults.rangeHeader(), string2, RangeResults.mimeTypeFor(string2));
    }

    public static Result ofSource(Long l, Source<ByteString, ?> source, String string2, String string3) {
        return JavaRangeResult.ofSource(l, source, RangeResults.rangeHeader(), Optional.ofNullable(string2), Optional.ofNullable(string3));
    }
}

