/*
 * Decompiled with CFR 0.152.
 */
package play.filters.csrf;

import play.api.mvc.RequestHeader;
import play.filters.csrf.CSRF;
import play.filters.csrf.CSRFAction$;
import play.filters.csrf.CSRFConf$;
import play.filters.csrf.CSRFErrorHandler;
import play.filters.csrf.RequireCSRFCheck;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import scala.Option;

public class RequireCSRFCheckAction
extends Action<RequireCSRFCheck> {
    private final String tokenName = CSRFConf$.MODULE$.TokenName();
    private final Option<String> cookieName = CSRFConf$.MODULE$.CookieName();
    private final CSRFAction$ CSRFAction = CSRFAction$.MODULE$;
    private final CSRF.TokenProvider tokenProvider = CSRFConf$.MODULE$.defaultTokenProvider();

    public F.Promise<Result> call(Http.Context context) throws Throwable {
        RequestHeader requestHeader = context._requestHeader();
        if (this.CSRFAction.checkCsrfBypass(requestHeader)) {
            return this.delegate.call(context);
        }
        Option<String> option = this.CSRFAction.getTokenFromHeader(requestHeader, this.tokenName, this.cookieName);
        if (option.isDefined()) {
            String[] stringArray;
            String string = null;
            Option<String> option2 = this.CSRFAction.getTokenFromQueryString(requestHeader, this.tokenName);
            if (option2.isDefined()) {
                string = (String)option2.get();
            } else if (context.request().body().asFormUrlEncoded() != null) {
                String[] stringArray2 = (String[])context.request().body().asFormUrlEncoded().get(this.tokenName);
                if (stringArray2 != null && stringArray2.length > 0) {
                    string = stringArray2[0];
                }
            } else if (context.request().body().asMultipartFormData() != null && (stringArray = (String[])context.request().body().asMultipartFormData().asFormUrlEncoded().get(this.tokenName)) != null && stringArray.length > 0) {
                string = stringArray[0];
            }
            if (string != null) {
                if (this.tokenProvider.compareTokens(string, (String)option.get())) {
                    return this.delegate.call(context);
                }
                return F.Promise.pure((Object)this.handleTokenError("CSRF tokens don't match"));
            }
            return F.Promise.pure((Object)this.handleTokenError("CSRF token not found in body or query string"));
        }
        return F.Promise.pure((Object)this.handleTokenError("CSRF token not found in session"));
    }

    private Result handleTokenError(String string) throws Exception {
        CSRFErrorHandler cSRFErrorHandler = ((RequireCSRFCheck)this.configuration).error().newInstance();
        return cSRFErrorHandler.handle(string);
    }
}

