/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.asynchttpclient.Response;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.util.HttpUtils;
import org.w3c.dom.Document;
import play.libs.Json;
import play.libs.XML;
import play.libs.ws.WSCookie;
import play.libs.ws.WSResponse;
import play.libs.ws.ahc.AhcWSCookie;

public class AhcWSResponse
implements WSResponse {
    private final Response ahcResponse;

    public AhcWSResponse(Response response) {
        this.ahcResponse = response;
    }

    @Override
    public Object getUnderlying() {
        return this.ahcResponse;
    }

    @Override
    public int getStatus() {
        return this.ahcResponse.getStatusCode();
    }

    @Override
    public String getStatusText() {
        return this.ahcResponse.getStatusText();
    }

    @Override
    public Map<String, List<String>> getAllHeaders() {
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        HttpHeaders httpHeaders = this.ahcResponse.getHeaders();
        for (String string : httpHeaders.names()) {
            List list = httpHeaders.getAll(string);
            treeMap.put(string, list);
        }
        return treeMap;
    }

    @Override
    public String getHeader(String string) {
        return this.ahcResponse.getHeader(string);
    }

    @Override
    public List<WSCookie> getCookies() {
        return this.ahcResponse.getCookies().stream().map(AhcWSCookie::new).collect(Collectors.toList());
    }

    @Override
    public WSCookie getCookie(String string) {
        for (Cookie cookie : this.ahcResponse.getCookies()) {
            if (!cookie.getName().equals(string)) continue;
            return new AhcWSCookie(cookie);
        }
        return null;
    }

    private String contentType() {
        String string = this.ahcResponse.getContentType();
        if (string == null) {
            string = "application/octet-stream";
        }
        return string;
    }

    @Override
    public String getBody() {
        String string = this.contentType();
        Charset charset = HttpUtils.parseCharset((String)string);
        if (charset != null) {
            return this.ahcResponse.getResponseBody(charset);
        }
        if (string.startsWith("text/")) {
            return this.ahcResponse.getResponseBody(HttpUtils.DEFAULT_CHARSET);
        }
        return this.ahcResponse.getResponseBody(StandardCharsets.UTF_8);
    }

    @Override
    public Document asXml() {
        String string = this.contentType();
        Charset charset = HttpUtils.parseCharset((String)string);
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        return XML.fromInputStream((InputStream)this.ahcResponse.getResponseBodyAsStream(), (String)charset.name());
    }

    @Override
    public JsonNode asJson() {
        return Json.parse((InputStream)this.ahcResponse.getResponseBodyAsStream());
    }

    @Override
    public InputStream getBodyAsStream() {
        return this.ahcResponse.getResponseBodyAsStream();
    }

    @Override
    public byte[] asByteArray() {
        return this.ahcResponse.getResponseBodyAsBytes();
    }

    @Override
    public URI getUri() {
        try {
            return this.ahcResponse.getUri().toJavaNetURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }
}

