/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterConstructor;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.wait.FluentSizeBuilder;
import org.fluentlenium.core.wait.FluentWaitBuilder;
import org.fluentlenium.core.wait.WaitMessage;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class FluentWaitMatcher {
    private List<Filter> filters = new ArrayList<Filter>();
    private Search search;
    private String selector;
    private FluentWait wait;

    public FluentWaitMatcher(Search search, FluentWait fluentWait, String selector) {
        this.selector = selector;
        this.wait = fluentWait;
        this.search = search;
    }

    public Fluent hasAttribute(final String attribute, final String value) {
        Predicate<WebDriver> hasAttribute = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().getAttributes(attribute).contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasAttribute, this.filters, WaitMessage.hasAttributeMessage(this.selector, attribute, value));
        return FluentThread.get();
    }

    static void until(FluentWait wait, Predicate present, List<Filter> filters, String defaultMessage) {
        StringBuilder message = new StringBuilder(defaultMessage);
        if (filters != null && !filters.isEmpty()) {
            for (Filter filter : filters) {
                message.append(filter.toString());
            }
            message.append(" Filters : ");
        }
        wait.withMessage(message.toString()).until(present);
    }

    public Fluent hasId(final String value) {
        Predicate<WebDriver> hasId = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().getIds().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasId, this.filters, WaitMessage.hasIdMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent hasName(final String value) {
        Predicate<WebDriver> hasName = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().getNames().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasName, this.filters, WaitMessage.hasNameMessage(this.selector, value));
        return FluentThread.get();
    }

    public FluentSizeBuilder hasSize() {
        return new FluentSizeBuilder(this.search, this.wait, this.selector, this.filters);
    }

    public Fluent hasSize(final int size) {
        Predicate<WebDriver> hasSize = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().size() == size;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasSize, this.filters, WaitMessage.hasSizeMessage(this.selector, size));
        return FluentThread.get();
    }

    public Fluent containsText(final String value) {
        Predicate<WebDriver> hasText = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                List<String> texts = FluentWaitMatcher.this.find().getTexts();
                if (texts != null) {
                    for (String text : texts) {
                        if (!text.contains(value)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasText, this.filters, WaitMessage.hasTextMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent hasText(final String value) {
        Predicate<WebDriver> hasText = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().getTexts().contains(value);
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)hasText, this.filters, WaitMessage.hasTextMessage(this.selector, value));
        return FluentThread.get();
    }

    public Fluent isPresent() {
        Predicate<WebDriver> isPresent = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                int size = FluentWaitMatcher.this.find().size();
                return size > 0;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isPresent, this.filters, WaitMessage.isPresentMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent isNotPresent() {
        Predicate<WebDriver> isNotPresent = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                return FluentWaitMatcher.this.find().isEmpty();
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isNotPresent, this.filters, WaitMessage.isNotPresentMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent areDisplayed() {
        Predicate<WebDriver> isVisible = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                FluentList fluentWebElements = FluentWaitMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (fluentWebElement.isDisplayed()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isVisible, this.filters, WaitMessage.isDisplayedMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent areNotDisplayed() {
        Predicate<WebDriver> isNotVisible = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                FluentList fluentWebElements = FluentWaitMatcher.this.findWithFilter();
                for (FluentWebElement fluentWebElement : fluentWebElements) {
                    if (!fluentWebElement.isDisplayed()) continue;
                    return false;
                }
                return true;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isNotVisible, this.filters, WaitMessage.isDisplayedMessage(this.selector));
        return FluentThread.get();
    }

    public Fluent areEnabled() {
        Predicate<WebDriver> isEnabled = new Predicate<WebDriver>(){

            public boolean apply(WebDriver webDriver) {
                FluentList fluentWebElements = FluentWaitMatcher.this.find();
                if (fluentWebElements.size() > 0) {
                    for (FluentWebElement fluentWebElement : fluentWebElements) {
                        if (fluentWebElement.isEnabled()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isEnabled, this.filters, WaitMessage.isEnabledMessage(this.selector));
        return FluentThread.get();
    }

    private FluentList<FluentWebElement> find() {
        if (this.filters.size() > 0) {
            return this.findWithFilter();
        }
        return this.search.find(this.selector, new Filter[0]);
    }

    private FluentList<FluentWebElement> findWithFilter() {
        return this.search.find(this.selector, this.filters.toArray(new Filter[this.filters.size()]));
    }

    public FluentWaitBuilder with(String attribute) {
        return new FluentWaitBuilder(this, attribute);
    }

    public FluentWaitBuilder withId() {
        return new FluentWaitBuilder(this, FilterType.ID);
    }

    public FluentWaitMatcher withId(String value) {
        this.filters.add(FilterConstructor.withId(value));
        return this;
    }

    public FluentWaitBuilder withName() {
        return new FluentWaitBuilder(this, FilterType.NAME);
    }

    public FluentWaitMatcher withName(String value) {
        this.filters.add(FilterConstructor.withName(value));
        return this;
    }

    public FluentWaitBuilder withClass() {
        return new FluentWaitBuilder(this, FilterType.CLASS);
    }

    public FluentWaitMatcher withClass(String value) {
        this.filters.add(FilterConstructor.withClass(value));
        return this;
    }

    public FluentWaitBuilder withText() {
        return new FluentWaitBuilder(this, FilterType.TEXT);
    }

    public FluentWaitMatcher withText(String value) {
        this.filters.add(FilterConstructor.withText(value));
        return this;
    }

    void addFilter(Filter filter) {
        this.filters.add(filter);
    }
}

