<!--- Copyright (C) 2009-2015 Typesafe Inc. <http://www.typesafe.com> -->
# Play Tutorials

Many Activator templates come with comprehensive tutorials that guide you to creating an application using the technologies featured by that template.

A full list of templates can be discovered in the Activator UI.

Additionally, templates are also published on the Typesafe website, a full list of both official and community contributed templates for Play can be found [here](https://typesafe.com/activator/templates#filter:play).

The template directory allows you to browse templates, preview the tutorials that come with the templates, and even download self contained template bundles that allow you to get quickly started with a template.

Some tutorials we recommend:

## Scala

* [Play Scala Intro](https://typesafe.com/activator/template/play-scala-intro): Introduction to create a simple CRUD application with Play Scala.
* [Reactive Maps](https://typesafe.com/activator/template/reactive-maps): This template and tutorial shows how the Typesafe Reactive Platform can be used to implement scalable, resilient, responsive event driven apps.
* [AngularJS Play Mongo](https://typesafe.com/activator/template/modern-web-template): Application shows how to build a modern web application, comprising of a Client-side JavaScript App built using AngularJS wrote in CoffeeScript, served from the Play Framework and using document persistence with Reactive Mongo a non-blocking Scala client for MongoDB.
* [Super Slick Play](https://typesafe.com/activator/template/play-slick): This template combines Play Framework with [Slick](http://slick.typesafe.com/) for quick start Slick integrated database-backed web application development.

## Java

* [Play Java Intro](https://typesafe.com/activator/template/play-java-intro): Introduction to create a simple CRUD application with Play Java.
* [Reactive Maps in Java](https://typesafe.com/activator/template/reactive-maps-java): This template and tutorial shows how the Typesafe Reactive Platform can be used to implement scalable, resilient, responsive event driven apps.
* [Play with Spring Data JPA](https://typesafe.com/activator/template/play-spring-data-jpa): This is a Play example that uses [Spring Data JPA](https://projects.spring.io/spring-data-jpa/).
