/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.converter.CoreAmqpConverter;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPMessageWriter
implements MessageWriter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ProtonServerSenderContext serverSender;
    private final AMQPSessionCallback sessionSPI;
    private final Sender protonSender;

    public AMQPMessageWriter(ProtonServerSenderContext serverSender) {
        this.serverSender = serverSender;
        this.sessionSPI = serverSender.getSessionContext().getSessionSPI();
        this.protonSender = serverSender.getSender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBytes(MessageReference messageReference) {
        if (this.protonSender.getLocalState() == EndpointState.CLOSED) {
            logger.debug("Not delivering message {} as the sender is closed and credits were available, if you see too many of these it means clients are issuing credits and closing the connection with pending credits a lot of times", (Object)messageReference);
            return;
        }
        try {
            AMQPMessage amqpMessage = CoreAmqpConverter.checkAMQP(messageReference.getMessage(), null);
            if (this.sessionSPI.invokeOutgoing(amqpMessage, (ActiveMQProtonRemotingConnection)this.sessionSPI.getTransportConnection().getProtocolConnection()) != null) {
                return;
            }
            Delivery delivery = this.serverSender.createDelivery(messageReference, (int)amqpMessage.getMessageFormat());
            ReadableBuffer sendBuffer = amqpMessage.getSendBuffer(messageReference.getDeliveryCount(), messageReference);
            boolean releaseRequired = sendBuffer instanceof NettyReadable;
            try {
                if (releaseRequired) {
                    this.protonSender.send(sendBuffer);
                    releaseRequired = false;
                    ((NettyReadable)sendBuffer).getByteBuf().release();
                } else {
                    this.protonSender.sendNoCopy(sendBuffer);
                }
                this.serverSender.reportDeliveryComplete(this, messageReference, delivery, false);
            }
            finally {
                if (releaseRequired) {
                    ((NettyReadable)sendBuffer).getByteBuf().release();
                }
            }
        }
        catch (Exception deliveryError) {
            this.serverSender.reportDeliveryError(this, messageReference, deliveryError);
        }
    }
}

