/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.ValueSerializer;
import java.io.IOException;

public class StructSerializer
extends ProtobufSerializer<Struct> {
    private static final Descriptors.FieldDescriptor FIELDS_FIELD = Struct.getDescriptor().findFieldByName("fields");

    @Deprecated
    public StructSerializer() {
        this(ProtobufJacksonConfig.getDefaultInstance());
    }

    public StructSerializer(ProtobufJacksonConfig config) {
        super(Struct.class, config);
    }

    public void serialize(Struct struct, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        this.writeMap(FIELDS_FIELD, struct.getField(FIELDS_FIELD), generator, serializerProvider);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JavaType keyType = visitor.getProvider().constructType(String.class);
        JavaType valueType = visitor.getProvider().constructType(Value.class);
        MapLikeType mapType = visitor.getProvider().getTypeFactory().constructMapLikeType(typeHint.getRawClass(), keyType, valueType);
        JsonMapFormatVisitor mapVisitor = visitor.expectMapFormat((JavaType)mapType);
        if (mapVisitor != null) {
            mapVisitor.keyFormat(JsonFormatVisitorWrapper::expectStringFormat, keyType);
            mapVisitor.valueFormat((JsonFormatVisitable)new ValueSerializer(this.getConfig()), valueType);
        }
    }
}

