/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.plugin;

import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.aries.blueprint.plugin.OsgiServiceProviderWriter;
import org.apache.aries.blueprint.plugin.model.Bean;
import org.apache.aries.blueprint.plugin.model.Context;
import org.apache.aries.blueprint.plugin.model.OsgiServiceBean;
import org.apache.aries.blueprint.plugin.model.Property;
import org.apache.aries.blueprint.plugin.model.PropertyWriter;
import org.apache.aries.blueprint.plugin.model.TransactionalDef;

public class Generator
implements PropertyWriter {
    private static final String NS_BLUEPRINT = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    private static final String NS_EXT = "http://aries.apache.org/blueprint/xmlns/blueprint-ext/v1.0.0";
    private static final String NS_JPA = "http://aries.apache.org/xmlns/jpa/v1.1.0";
    private static final String NS_TX = "http://aries.apache.org/xmlns/transactions/v1.1.0";
    private Context context;
    private XMLStreamWriter writer;

    public Generator(Context context, OutputStream os) throws XMLStreamException {
        this.context = context;
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        this.writer = factory.createXMLStreamWriter(os);
    }

    public void generate() {
        try {
            this.writer.writeStartDocument();
            this.writer.writeCharacters("\n");
            this.writeBlueprint();
            for (Bean bean : this.context.getBeans()) {
                this.writeBeanStart(bean);
                bean.writeProperties(this);
                this.writer.writeEndElement();
                this.writer.writeCharacters("\n");
            }
            this.writeServiceRefs();
            new OsgiServiceProviderWriter(this.writer).write(this.context.getBeans());
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
            this.writer.writeEndDocument();
            this.writer.writeCharacters("\n");
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void writeBlueprint() throws XMLStreamException {
        this.writer.writeStartElement("blueprint");
        this.writer.writeDefaultNamespace(NS_BLUEPRINT);
        this.writer.writeNamespace("ext", NS_EXT);
        this.writer.writeNamespace("jpa", NS_JPA);
        this.writer.writeNamespace("tx", NS_TX);
        this.writer.writeCharacters("\n");
    }

    public void writeBeanStart(Bean bean) throws XMLStreamException {
        this.writer.writeStartElement("bean");
        this.writer.writeAttribute("id", bean.id);
        this.writer.writeAttribute("class", bean.clazz.getName());
        this.writer.writeAttribute("ext", NS_EXT, "field-injection", "true");
        if (bean.initMethod != null) {
            this.writer.writeAttribute("init-method", bean.initMethod);
        }
        if (bean.destroyMethod != null) {
            this.writer.writeAttribute("destroy-method", bean.destroyMethod);
        }
        this.writer.writeCharacters("\n");
        this.writeTransactional(bean.transactionDef);
        this.writePersistenceFields(bean.persistenceFields);
    }

    private void writeTransactional(TransactionalDef transactionDef) throws XMLStreamException {
        if (transactionDef != null) {
            this.writer.writeCharacters("    ");
            this.writer.writeEmptyElement("tx", "transaction", NS_TX);
            this.writer.writeAttribute("method", transactionDef.getMethod());
            this.writer.writeAttribute("value", transactionDef.getType());
            this.writer.writeCharacters("\n");
        }
    }

    private void writePersistenceFields(Field[] fields) throws XMLStreamException {
        for (Field field : fields) {
            this.writePersistenceField(field);
        }
    }

    private void writePersistenceField(Field field) throws XMLStreamException {
        PersistenceUnit persistenceUnit;
        PersistenceContext persistenceContext = field.getAnnotation(PersistenceContext.class);
        if (persistenceContext != null) {
            this.writer.writeCharacters("    ");
            this.writer.writeEmptyElement("jpa", "context", NS_JPA);
            this.writer.writeAttribute("unitname", persistenceContext.unitName());
            this.writer.writeAttribute("property", field.getName());
            this.writer.writeCharacters("\n");
        }
        if ((persistenceUnit = field.getAnnotation(PersistenceUnit.class)) != null) {
            this.writer.writeCharacters("    ");
            this.writer.writeEmptyElement("jpa", "unit", NS_JPA);
            this.writer.writeAttribute("unitname", persistenceUnit.unitName());
            this.writer.writeAttribute("property", field.getName());
            this.writer.writeCharacters("\n");
        }
    }

    private void writeServiceRefs() throws XMLStreamException {
        for (OsgiServiceBean serviceBean : this.context.getServiceRefs()) {
            this.writeServiceRef(serviceBean);
        }
    }

    private void writeServiceRef(OsgiServiceBean serviceBean) throws XMLStreamException {
        this.writer.writeEmptyElement("reference");
        this.writer.writeAttribute("id", serviceBean.id);
        this.writer.writeAttribute("interface", serviceBean.clazz.getName());
        if (serviceBean.filter != null && !"".equals(serviceBean.filter)) {
            this.writer.writeAttribute("filter", serviceBean.filter);
        }
        this.writer.writeCharacters("\n");
    }

    @Override
    public void writeProperty(Property property) {
        try {
            this.writer.writeCharacters("    ");
            this.writer.writeEmptyElement("property");
            this.writer.writeAttribute("name", property.name);
            if (property.ref != null) {
                this.writer.writeAttribute("ref", property.ref);
            } else if (property.value != null) {
                this.writer.writeAttribute("value", property.value);
            }
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

