/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.jackson;

import com.fasterxml.jackson.jaxrs.cfg.Annotations;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.Dictionary;
import org.osgi.annotation.bundle.Capability;
import org.osgi.framework.Bundle;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jaxrs.whiteboard.annotations.RequireJaxrsWhiteboard;

@Capability(attribute={"objectClass:List<String>='javax.ws.rs.ext.MessageBodyReader,javax.ws.rs.ext.MessageBodyWriter'", "osgi.jaxrs.media.type=application/json", "osgi.jaxrs.name=jackson"}, namespace="osgi.service")
@RequireJaxrsWhiteboard
public class JsonProviderPrototypeServiceFactory
implements PrototypeServiceFactory<JacksonJsonProvider> {
    private Dictionary<String, ?> _properties;

    JsonProviderPrototypeServiceFactory(Dictionary<String, ?> properties) {
        this._properties = properties;
    }

    public JacksonJsonProvider getService(Bundle bundle, ServiceRegistration<JacksonJsonProvider> registration) {
        return this.createJsonProvider(this._properties);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<JacksonJsonProvider> registration, JacksonJsonProvider service) {
    }

    private JacksonJsonProvider createJsonProvider(Dictionary<String, ?> properties) {
        ArrayList<Annotations> list = new ArrayList<Annotations>();
        if (this.getBooleanProperty(properties, "jackson.annotations.enabled", true)) {
            list.add(Annotations.JACKSON);
        }
        if (this.getBooleanProperty(properties, "jaxb.annotations.enabled", true)) {
            list.add(Annotations.JAXB);
        }
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider(list.toArray(new Annotations[list.size()]));
        return jsonProvider;
    }

    private boolean getBooleanProperty(Dictionary<String, ?> properties, String key, boolean defaultValue) {
        Object object = properties.get(key);
        if (object == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(String.valueOf(object));
    }
}

