/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.ExtensionsSchema;
import org.osgi.framework.BundleContext;
import org.osgi.service.rest.RestApiExtension;

public class ExtensionResource
extends BaseResource {
    private final Set<CachingServiceReference<RestApiExtension>> extensions;

    public ExtensionResource(BundleContext bundleContext, Set<CachingServiceReference<RestApiExtension>> extensions) {
        super(bundleContext);
        this.extensions = extensions;
    }

    @GET
    @Path(value="extensions{ext: (\\.json|\\.xml)*}")
    @Produces(value={"application/org.osgi.extensions+json", "application/org.osgi.extensions+xml"})
    @Operation(summary="Retrieves a Extensions Representation ", responses={@ApiResponse(responseCode="200", description="The framework bundle", content={@Content(schema=@Schema(implementation=ExtensionsSchema.class))}), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response extensions(@Parameter(allowEmptyValue=true, schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity((Object)ExtensionsSchema.build(this.extensions));
        return Optional.ofNullable(ext).map(String::trim).map(t -> ".json".equals(t) ? "application/org.osgi.extensions+json" : "application/org.osgi.extensions+xml").map(t -> builder.type(t)).orElse(builder).build();
    }
}

