/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.internal.map.CaseInsensitiveMap;
import org.apache.aries.jax.rs.rest.management.schema.ServiceSchema;
import org.apache.aries.jax.rs.rest.management.schema.ServiceSchemaListSchema;
import org.osgi.framework.BundleContext;
import org.osgi.framework.dto.FrameworkDTO;
import org.osgi.framework.dto.ServiceReferenceDTO;

public class FrameworkServicesRepresentationsResource
extends BaseResource {
    public FrameworkServicesRepresentationsResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Produces(value={"application/org.osgi.services.representations+json", "application/org.osgi.services.representations+xml"})
    @Path(value="framework/services/representations{ext:(\\.json|\\.xml)*}")
    @Operation(operationId="GET/services/representations", summary="Retrieves the service representation of each available service", responses={@ApiResponse(responseCode="200", description="The request has been served successfully", content={@Content(schema=@Schema(implementation=ServiceSchemaListSchema.class))}), @ApiResponse(responseCode="400", description="The provided filter expression was not valid"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response serviceDTOs(@Parameter(name="filter", in=ParameterIn.QUERY, description="A filter parameter whose value is a filter expression that follows the Core Specifications Framework Filter Syntax; see OSGi Core, Chapter 3.2.7 Filter Syntax. The filter is matched against the service attributes and only services that match are returned", examples={@ExampleObject(summary="format: filter=<filter_string>", value="filter=(&(osgi.vendor=Apache Aries)(objectClass=com.acme.Widget))")}) @QueryParam(value="filter") String filter, @Parameter(allowEmptyValue=true, description="File extension", schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Predicate<ServiceReferenceDTO> predicate = FrameworkServicesRepresentationsResource.fromFilterQuery(filter);
        Response.ResponseBuilder builder = Response.ok((Object)((Object)ServiceSchemaListSchema.build(((FrameworkDTO)this.framework.adapt(FrameworkDTO.class)).services.stream().map(sr -> {
            sr.properties = new CaseInsensitiveMap(sr.properties);
            return sr;
        }).filter(predicate).map(sr -> ServiceSchema.build(this.uriInfo, sr)).collect(Collectors.toList()))));
        return Optional.ofNullable(ext).map(String::trim).map(e -> ".json".equals(e) ? "application/org.osgi.services.representations+json" : "application/org.osgi.services.representations+xml").map(type -> builder.type(type)).orElse(builder).build();
    }
}

