/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraphVisitor;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.resource.Capability;

public class SharingPolicyValidator {
    private final Region from;
    private final Region to;

    public SharingPolicyValidator(Region from, Region to) {
        this.from = from;
        this.to = to;
    }

    public boolean isValid(Capability capability) {
        Visitor visitor = new Visitor(capability);
        this.to.visitSubgraph((RegionDigraphVisitor)visitor);
        return visitor.contains(this.from);
    }

    private static class Visitor
    implements RegionDigraphVisitor {
        private final Capability capability;
        private final Collection<Region> visited;

        public Visitor(Capability capability) {
            this.capability = capability;
            this.visited = new HashSet<Region>();
        }

        public boolean contains(Region region) {
            return this.visited.contains(region);
        }

        public void postEdgeTraverse(RegionFilter filter) {
        }

        public boolean preEdgeTraverse(RegionFilter filter) {
            if (filter.isAllowed("osgi.service".equals(this.capability.getNamespace()) ? "org.eclipse.equinox.allow.service" : this.capability.getNamespace(), this.capability.getAttributes())) {
                return true;
            }
            if (this.capability instanceof BundleCapability) {
                return filter.isAllowed(((BundleCapability)this.capability).getRevision());
            }
            return false;
        }

        public boolean visit(Region region) {
            this.visited.add(region);
            return true;
        }
    }
}

