/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.aries.subsystem.core.archive.PreferredProviderHeader;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.Subsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubsystemResolverHook
implements ResolverHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubsystemResolverHook.class);
    private final Subsystems subsystems;

    public SubsystemResolverHook(Subsystems subsystems) {
        if (subsystems == null) {
            throw new NullPointerException("Missing required parameter: subsystems");
        }
        this.subsystems = subsystems;
    }

    public void end() {
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        Collection<BasicSubsystem> requirers = this.subsystems.getSubsystemsReferencing((Resource)requirement.getResource());
        ArrayList<BundleCapability> preferredProviders = new ArrayList<BundleCapability>(candidates.size());
        for (BundleCapability candidate : candidates) {
            for (BasicSubsystem subsystem : requirers) {
                PreferredProviderHeader header = subsystem.getSubsystemManifest().getPreferredProviderHeader();
                if (header == null || !header.contains((Resource)candidate.getResource()) && !this.isResourceConstituentOfPreferredSubsystem((Resource)candidate.getResource(), subsystem)) continue;
                preferredProviders.add(candidate);
            }
        }
        if (!preferredProviders.isEmpty()) {
            candidates.retainAll(preferredProviders);
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
        try {
            Iterator<BundleRevision> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                BundleRevision revision = iterator.next();
                if (revision.getSymbolicName().startsWith("org.osgi.service.subsystem.region.context.")) continue;
                Collection<BasicSubsystem> subsystems = this.subsystems.getSubsystemsReferencing((Resource)revision);
                for (BasicSubsystem subsystem : subsystems) {
                    if (subsystem.isFeature() || !Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) continue;
                    iterator.remove();
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Unexpected exception while filtering resolution candidates: " + candidates, (Throwable)e);
        }
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
    }

    private boolean isResourceConstituentOfPreferredSubsystem(Resource resource, BasicSubsystem preferer) {
        Collection<BasicSubsystem> subsystems = this.subsystems.getSubsystemsReferencing(resource);
        for (BasicSubsystem subsystem : subsystems) {
            if (!preferer.getSubsystemManifest().getPreferredProviderHeader().contains(subsystem)) continue;
            return true;
        }
        return false;
    }
}

