/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.http.api.IChannelClosedHandler;
import org.apache.hyracks.http.api.IServlet;
import org.apache.hyracks.http.server.HttpRequestHandler;
import org.apache.hyracks.http.server.HttpServerConfig;
import org.apache.hyracks.http.server.HttpServerHandler;
import org.apache.hyracks.http.server.HttpServerInitializer;
import org.apache.hyracks.http.server.ServletRegistry;
import org.apache.hyracks.util.MXHelper;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpServer {
    private static final int LOW_WRITE_BUFFER_WATER_MARK = 8192;
    private static final int HIGH_WRITE_BUFFER_WATER_MARK = 32768;
    protected static final WriteBufferWaterMark WRITE_BUFFER_WATER_MARK = new WriteBufferWaterMark(8192, 32768);
    protected static final int RECEIVE_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FAILED = -1;
    private static final int STOPPED = 0;
    private static final int STARTING = 1;
    private static final int STARTED = 2;
    private static final int STOPPING = 3;
    private final IChannelClosedHandler closedHandler;
    private final Object lock = new Object();
    private final AtomicInteger threadId = new AtomicInteger();
    private final ConcurrentMap<String, Object> ctx;
    private final LinkedBlockingQueue<Runnable> workQueue;
    private final ServletRegistry servlets;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final InetSocketAddress address;
    private final ThreadPoolExecutor executor;
    private volatile int state = 0;
    private volatile Thread recoveryThread;
    private volatile Channel channel;
    private Throwable cause;
    private HttpServerConfig config;

    public HttpServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, int port, HttpServerConfig config) {
        this(bossGroup, workerGroup, new InetSocketAddress(port), config, null);
    }

    public HttpServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, InetSocketAddress address, HttpServerConfig config) {
        this(bossGroup, workerGroup, address, config, null);
    }

    public HttpServer(EventLoopGroup bossGroup, EventLoopGroup workerGroup, InetSocketAddress address, HttpServerConfig config, IChannelClosedHandler closeHandler) {
        this.bossGroup = bossGroup;
        this.workerGroup = workerGroup;
        this.address = address;
        this.closedHandler = closeHandler;
        this.config = config;
        this.ctx = new ConcurrentHashMap<String, Object>();
        this.servlets = new ServletRegistry();
        this.workQueue = new LinkedBlockingQueue(config.getRequestQueueSize());
        int numExecutorThreads = config.getThreadCount();
        this.executor = new ThreadPoolExecutor(numExecutorThreads, numExecutorThreads, 0L, TimeUnit.MILLISECONDS, this.workQueue, runnable -> new Thread(runnable, "HttpExecutor(port:" + address.getPort() + ")-" + this.threadId.getAndIncrement()));
        long directMemoryBudget = (long)numExecutorThreads * 32768L + (long)(numExecutorThreads * config.getMaxResponseChunkSize());
        LOGGER.log(Level.DEBUG, "The output direct memory budget for this server is " + directMemoryBudget + " bytes");
        long inputBudgetEstimate = (long)config.getMaxRequestInitialLineLength() * (long)(config.getRequestQueueSize() + numExecutorThreads);
        LOGGER.log(Level.DEBUG, "The \"estimated\" input direct memory budget for this server is " + (inputBudgetEstimate *= 2L) + " bytes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 2 || this.state == 1) {
                    return;
                }
                this.setStarting();
                this.doStart();
                this.setStarted();
            }
            catch (Throwable e) {
                LOGGER.error("Failure starting an Http Server at: {}", (Object)this.address, (Object)e);
                this.setFailed(e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.state == 3 || this.state == 0) {
                    return;
                }
                this.setStopping();
                this.doStop();
                this.setStopped();
            }
            catch (Throwable e) {
                LOGGER.log(Level.ERROR, "Failure stopping an Http Server", e);
                this.setFailed(e);
                throw e;
            }
        }
        Thread rt = this.recoveryThread;
        if (rt != null) {
            rt.join(TimeUnit.SECONDS.toMillis(5L));
            if (this.recoveryThread != null) {
                LOGGER.log(Level.ERROR, "Failure stopping recovery thread of {}", (Object)this);
            }
        }
    }

    public String getState() {
        switch (this.state) {
            case -1: {
                return "FAILED";
            }
            case 1: {
                return "STARTING";
            }
            case 2: {
                return "STARTED";
            }
            case 3: {
                return "STOPPING";
            }
            case 0: {
                return "STOPPED";
            }
        }
        return "UNKNOWN";
    }

    private void setStarting() {
        this.state = 1;
    }

    private void setStarted() {
        this.state = 2;
    }

    private void setStopping() {
        this.state = 3;
    }

    private void setStopped() {
        this.state = 0;
    }

    private void setFailed(Throwable th) {
        this.state = -1;
        this.cause = th;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setAttribute(String name, Object value) {
        this.ctx.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.ctx.get(name);
    }

    public ConcurrentMap<String, Object> ctx() {
        return this.ctx;
    }

    public void addServlet(IServlet let) {
        this.servlets.register(let);
    }

    public Set<IServlet> getServlets() {
        return this.servlets.getServlets();
    }

    protected void doStart() throws InterruptedException, IOException {
        for (IServlet servlet : this.servlets.getServlets()) {
            servlet.init();
        }
        this.channel = this.bind();
    }

    private Channel bind() throws InterruptedException {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(4096)).childOption(ChannelOption.AUTO_READ, (Object)Boolean.FALSE).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)WRITE_BUFFER_WATER_MARK).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler(this.getChannelInitializer());
        Channel newChannel = b.bind((SocketAddress)this.address).sync().channel();
        newChannel.closeFuture().addListener(f -> {
            Object object = this.lock;
            synchronized (object) {
                if (this.state != 2) {
                    return;
                }
                LOGGER.log(Level.WARN, "{} has stopped unexpectedly. Starting server recovery", (Object)this);
                MXHelper.logFileDescriptors();
                this.triggerRecovery();
            }
        });
        return newChannel;
    }

    private void triggerRecovery() {
        Thread rt = this.recoveryThread;
        if (rt != null) {
            try {
                rt.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARN, this + " recovery was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.recoveryThread = new Thread(this::recover);
        this.recoveryThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void recover() {
        try {
            Object object = this.lock;
            // MONITORENTER : object
            while (this.state == 2) {
                try {
                    this.channel = this.bind();
                    return;
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.WARN, this + " was interrupted while attempting to revive server channel", (Throwable)e);
                    this.setFailed(e);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable th) {
                    LOGGER.log(Level.WARN, this + " failed server recovery attempt. Sleeping for 5s before starting the next attempt", th);
                    try {
                        this.lock.wait(TimeUnit.SECONDS.toMillis(5L));
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARN, this + " interrupted while attempting to revive server channel", (Throwable)e);
                        this.setFailed(e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            // MONITOREXIT : object
            return;
        }
        finally {
            this.recoveryThread = null;
        }
    }

    protected void doStop() throws InterruptedException {
        Thread rt = this.recoveryThread;
        if (rt != null) {
            rt.interrupt();
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            this.executor.shutdownNow();
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!this.executor.isTerminated()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.log(Level.ERROR, "Failed to shutdown http server executor; thread dump: " + ThreadDumpUtil.takeDumpString());
                } else {
                    LOGGER.log(Level.ERROR, "Failed to shutdown http server executor");
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Error while shutting down http server executor", (Throwable)e);
        }
        if (this.channel != null) {
            this.channel.close();
            this.channel.closeFuture().sync();
        }
    }

    public IServlet getServlet(FullHttpRequest request) {
        return this.servlets.getServlet(request.uri());
    }

    protected HttpServerHandler<? extends HttpServer> createHttpHandler(int chunkSize) {
        return new HttpServerHandler<HttpServer>(this, chunkSize);
    }

    protected ChannelInitializer<SocketChannel> getChannelInitializer() {
        return new HttpServerInitializer(this);
    }

    public ThreadPoolExecutor getExecutor(HttpRequestHandler handler) {
        return this.executor;
    }

    protected EventLoopGroup getWorkerGroup() {
        return this.workerGroup;
    }

    public int getWorkQueueSize() {
        return this.workQueue.size();
    }

    public IChannelClosedHandler getChannelClosedHandler() {
        return this.closedHandler;
    }

    public HttpScheme getScheme() {
        return HttpScheme.HTTP;
    }

    public String toString() {
        return "{\"class\":\"" + this.getClass().getSimpleName() + "\",\"address\":" + this.address + ",\"state\":\"" + this.getState() + "\"}";
    }

    public HttpServerConfig getConfig() {
        return this.config;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }
}

