/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ArraySliceEvaluator
extends AbstractScalarEval {
    private final IAType inputListType;
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final IScalarEvaluator listEval;
    private final IScalarEvaluator startPositionEval;
    private IScalarEvaluator endPositionEval;
    private final IPointable listPointable = new VoidPointable();
    private final IPointable startPositionPointable = new VoidPointable();
    private IPointable endPositionPointable;
    private final ListAccessor listAccessor = new ListAccessor();
    private final IAsterixListBuilder orderedListBuilder = new OrderedListBuilder();
    private final IAsterixListBuilder unorderedListBuilder = new UnorderedListBuilder();

    ArraySliceEvaluator(IScalarEvaluatorFactory[] argEvalFactories, IEvaluatorContext ctx, SourceLocation sourceLoc, FunctionIdentifier functionIdentifier, IAType inputListType) throws HyracksDataException {
        super(sourceLoc, functionIdentifier);
        this.inputListType = inputListType;
        this.listEval = argEvalFactories[0].createScalarEvaluator(ctx);
        this.startPositionEval = argEvalFactories[1].createScalarEvaluator(ctx);
        if (argEvalFactories.length > 2) {
            this.endPositionEval = argEvalFactories[2].createScalarEvaluator(ctx);
            this.endPositionPointable = new VoidPointable();
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        Object collectionType;
        IAsterixListBuilder listBuilder;
        int startPositionValue;
        ATypeTag endPositionTypeTag;
        this.listEval.evaluate(tuple, this.listPointable);
        this.startPositionEval.evaluate(tuple, this.startPositionPointable);
        if (this.endPositionEval != null) {
            this.endPositionEval.evaluate(tuple, this.endPositionPointable);
        }
        if (PointableHelper.checkAndSetMissingOrNull(result, this.listPointable, this.startPositionPointable, this.endPositionPointable)) {
            return;
        }
        int endPositionValue = 0;
        byte[] listBytes = this.listPointable.getByteArray();
        int listOffset = this.listPointable.getStartOffset();
        ATypeTag listTypetag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[listOffset]);
        byte[] startPositionBytes = this.startPositionPointable.getByteArray();
        int startPositionOffset = this.startPositionPointable.getStartOffset();
        ATypeTag startPositionTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(startPositionBytes[startPositionOffset]);
        if (!listTypetag.isListType() || !ATypeHierarchy.isCompatible((ATypeTag)startPositionTypeTag, (ATypeTag)ATypeTag.DOUBLE)) {
            PointableHelper.setNull(result);
            return;
        }
        this.listAccessor.reset(listBytes, listOffset);
        byte[] endPositionBytes = null;
        int endPositionOffset = 0;
        if (this.endPositionEval != null) {
            endPositionBytes = this.endPositionPointable.getByteArray();
            endPositionTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(endPositionBytes[endPositionOffset = this.endPositionPointable.getStartOffset()]);
            if (!ATypeHierarchy.isCompatible((ATypeTag)endPositionTypeTag, (ATypeTag)ATypeTag.DOUBLE)) {
                PointableHelper.setNull(result);
                return;
            }
        } else {
            endPositionValue = this.listAccessor.size();
            endPositionTypeTag = ATypeTag.BIGINT;
        }
        try {
            startPositionValue = this.getValue(startPositionBytes, startPositionOffset + 1, startPositionTypeTag);
            endPositionValue = this.endPositionEval != null ? this.getValue(endPositionBytes, endPositionOffset + 1, endPositionTypeTag) : endPositionValue;
        }
        catch (HyracksDataException ignored) {
            PointableHelper.setNull(result);
            return;
        }
        startPositionValue = startPositionValue < 0 ? this.listAccessor.size() + startPositionValue : startPositionValue;
        int n = endPositionValue = endPositionValue < 0 ? this.listAccessor.size() + endPositionValue : endPositionValue;
        if (!this.isValidArguments(this.listAccessor.size(), startPositionValue, endPositionValue)) {
            PointableHelper.setNull(result);
            return;
        }
        IAsterixListBuilder iAsterixListBuilder = listBuilder = this.listAccessor.getListType() == ATypeTag.ARRAY ? this.orderedListBuilder : this.unorderedListBuilder;
        if (!this.inputListType.getTypeTag().isListType()) {
            ATypeTag listItemTypeTag = this.listAccessor.getItemType();
            IAType listItemType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)listItemTypeTag);
            collectionType = this.listAccessor.getListType() == ATypeTag.ARRAY ? new AOrderedListType(listItemType, listItemType.getTypeName()) : new AUnorderedListType(listItemType, listItemType.getTypeName());
        } else {
            collectionType = (AbstractCollectionType)this.inputListType;
        }
        listBuilder.reset(collectionType);
        try {
            for (int i = startPositionValue; i < endPositionValue; ++i) {
                this.resultStorage.reset();
                this.listAccessor.writeItem(i, this.resultStorage.getDataOutput());
                listBuilder.addItem((IValueReference)this.resultStorage);
            }
        }
        catch (IOException ex) {
            throw HyracksDataException.create((Throwable)ex);
        }
        this.resultStorage.reset();
        listBuilder.write(this.resultStorage.getDataOutput(), true);
        result.set((IValueReference)this.resultStorage);
    }

    private int getValue(byte[] data, int offset, ATypeTag typeTag) throws HyracksDataException {
        double value;
        switch (typeTag) {
            case TINYINT: {
                value = AInt8SerializerDeserializer.getByte((byte[])data, (int)offset);
                break;
            }
            case SMALLINT: {
                value = AInt16SerializerDeserializer.getShort((byte[])data, (int)offset);
                break;
            }
            case INTEGER: {
                value = AInt32SerializerDeserializer.getInt((byte[])data, (int)offset);
                break;
            }
            case BIGINT: {
                value = AInt64SerializerDeserializer.getLong((byte[])data, (int)offset);
                break;
            }
            case FLOAT: {
                value = AFloatSerializerDeserializer.getFloat((byte[])data, (int)offset);
                break;
            }
            case DOUBLE: {
                value = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)offset);
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(this.srcLoc, this.funID, typeTag.serialize());
            }
        }
        if (Double.isNaN(value) || Double.isInfinite(value) || value > Math.floor(value)) {
            throw new InvalidDataFormatException(this.srcLoc, this.funID, typeTag.serialize());
        }
        return (int)value;
    }

    private boolean isValidArguments(double listLength, double startPosition, double endPosition) {
        if (startPosition < 0.0 || endPosition < 0.0) {
            return false;
        }
        if (startPosition > listLength - 1.0 || endPosition > listLength) {
            return false;
        }
        if (startPosition > Math.floor(startPosition) || endPosition > Math.floor(endPosition)) {
            return false;
        }
        return !(startPosition > endPosition);
    }
}

