/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.interval.utils.memory;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.asterix.runtime.operators.joins.interval.utils.memory.FrameTupleCursor;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;

public class RunFileStream {
    private final String key;
    private final IFrame runFileBuffer;
    private final IFrameTupleAppender runFileAppender;
    private RunFileWriter runFileWriter;
    private RunFileReader runFileReader;
    private FileReference runfile;
    private final IHyracksTaskContext ctx;
    private long runFileCounter = 0L;
    private long readCount = 0L;
    private long writeCount = 0L;
    private long totalTupleCount = 0L;
    private long previousReadPointer;
    private boolean reading = false;
    private boolean writing = false;

    public RunFileStream(IHyracksTaskContext ctx, String key) throws HyracksDataException {
        this.ctx = ctx;
        this.key = key;
        this.runFileBuffer = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.runFileAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
    }

    public long getFileCount() {
        return this.runFileCounter;
    }

    public long getTupleCount() {
        return this.totalTupleCount;
    }

    public long getReadCount() {
        return this.readCount;
    }

    public long getWriteCount() {
        return this.writeCount;
    }

    public void createRunFileWriting() throws HyracksDataException {
        ++this.runFileCounter;
        String prefix = this.key + '-' + this.runFileCounter + '-' + this.toString();
        this.runfile = this.ctx.getJobletContext().createManagedWorkspaceFile(prefix);
        if (this.runFileWriter != null) {
            this.runFileWriter.close();
        }
        this.runFileWriter = new RunFileWriter(this.runfile, this.ctx.getIoManager());
        this.runFileWriter.open();
        this.totalTupleCount = 0L;
    }

    public void startRunFileWriting() throws HyracksDataException {
        this.writing = true;
        this.runFileBuffer.reset();
    }

    public void addToRunFile(IFrameTupleAccessor accessor, int tupleId) throws HyracksDataException {
        if (!this.runFileAppender.append(accessor, tupleId)) {
            this.runFileAppender.write((IFrameWriter)this.runFileWriter, true);
            ++this.writeCount;
            this.runFileAppender.append(accessor, tupleId);
        }
        ++this.totalTupleCount;
    }

    public void addToRunFile(FrameTupleCursor cursor) throws HyracksDataException {
        if (!this.runFileAppender.append(cursor.getAccessor(), cursor.getTupleId())) {
            this.runFileAppender.write((IFrameWriter)this.runFileWriter, true);
            ++this.writeCount;
            this.runFileAppender.append(cursor.getAccessor(), cursor.getTupleId());
        }
        ++this.totalTupleCount;
    }

    public void startReadingRunFile(FrameTupleCursor cursor) throws HyracksDataException {
        this.startReadingRunFile(cursor, 0L);
    }

    public void startReadingRunFile(FrameTupleCursor cursor, long startOffset) throws HyracksDataException {
        if (this.runFileReader != null) {
            this.runFileReader.close();
        }
        this.reading = true;
        this.runFileReader = this.runFileWriter.createReader();
        this.runFileReader.open();
        this.runFileReader.seek(startOffset);
        this.previousReadPointer = 0L;
        this.loadNextBuffer(cursor);
    }

    public boolean loadNextBuffer(FrameTupleCursor cursor) throws HyracksDataException {
        long tempFrame = this.runFileReader.position();
        if (this.runFileReader.nextFrame(this.runFileBuffer)) {
            this.previousReadPointer = tempFrame;
            cursor.reset(this.runFileBuffer.getBuffer());
            ++this.readCount;
            return true;
        }
        return false;
    }

    public void flushRunFile() throws HyracksDataException {
        this.writing = false;
        if (this.runFileAppender.getTupleCount() > 0) {
            this.runFileAppender.write((IFrameWriter)this.runFileWriter, true);
            ++this.writeCount;
        }
        this.runFileBuffer.reset();
    }

    public void closeRunFileReading() throws HyracksDataException {
        this.reading = false;
        this.runFileReader.close();
        this.previousReadPointer = -1L;
    }

    public void close() throws HyracksDataException {
        if (this.runFileReader != null) {
            this.runFileReader.close();
        }
        if (this.runFileWriter != null) {
            this.runFileWriter.close();
        }
    }

    public void removeRunFile() {
        if (this.runfile != null) {
            FileUtils.deleteQuietly((File)this.runfile.getFile());
        }
    }

    public boolean isReading() {
        return this.reading;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public long getReadPointer() {
        if (this.runFileReader != null) {
            return this.previousReadPointer;
        }
        return -1L;
    }

    public ByteBuffer getAppenderBuffer() {
        return this.runFileAppender.getBuffer();
    }
}

