/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.asterix.common.api.IMetadataLockManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.IMetadataLock;
import org.apache.asterix.common.metadata.LockList;
import org.apache.asterix.metadata.lock.DatasetLock;
import org.apache.asterix.metadata.lock.MetadataLock;
import org.apache.asterix.metadata.lock.MetadataLockKey;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;

public class MetadataLockManager
implements IMetadataLockManager {
    private static final Function<MetadataLockKey, MetadataLock> LOCK_FUNCTION = MetadataLock::new;
    private static final Function<MetadataLockKey, DatasetLock> DATASET_LOCK_FUNCTION = DatasetLock::new;
    private final ConcurrentMap<MetadataLockKey, IMetadataLock> mdlocks = new ConcurrentHashMap<MetadataLockKey, IMetadataLock>();

    public void acquireDataverseReadLock(LockList locks, DataverseName dataverseName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataverseLockKey(dataverseName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataverseWriteLock(LockList locks, DataverseName dataverseName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataverseLockKey(dataverseName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDatasetReadLock(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, (IMetadataLock)lock);
    }

    public void acquireDatasetWriteLock(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, (IMetadataLock)lock);
    }

    public void acquireDatasetModifyLock(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.MODIFY, (IMetadataLock)lock);
    }

    public void acquireDatasetCreateIndexLock(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.INDEX_BUILD, (IMetadataLock)lock);
    }

    public void acquireDatasetExclusiveModificationLock(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }

    public void acquireFunctionReadLock(LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFunctionLockKey(dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireFunctionWriteLock(LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFunctionLockKey(dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireLibraryReadLock(LockList locks, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createLibraryLockKey(dataverseName, libraryName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireLibraryWriteLock(LockList locks, DataverseName dataverseName, String libraryName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createLibraryLockKey(dataverseName, libraryName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireAdapterReadLock(LockList locks, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createAdapterLockKey(dataverseName, adapterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireAdapterWriteLock(LockList locks, DataverseName dataverseName, String adapterName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createAdapterLockKey(dataverseName, adapterName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireNodeGroupReadLock(LockList locks, String nodeGroupName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createNodeGroupLockKey(nodeGroupName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireNodeGroupWriteLock(LockList locks, String nodeGroupName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createNodeGroupLockKey(nodeGroupName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireActiveEntityReadLock(LockList locks, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createActiveEntityLockKey(dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireActiveEntityWriteLock(LockList locks, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createActiveEntityLockKey(dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyWriteLock(LockList locks, DataverseName dataverseName, String feedPolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFeedPolicyLockKey(dataverseName, feedPolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireFeedPolicyReadLock(LockList locks, DataverseName dataverseName, String feedPolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createFeedPolicyLockKey(dataverseName, feedPolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyReadLock(LockList locks, String mergePolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createMergePolicyLockKey(mergePolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireMergePolicyWriteLock(LockList locks, String mergePolicyName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createMergePolicyLockKey(mergePolicyName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireDataTypeReadLock(LockList locks, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataTypeLockKey(dataverseName, datatypeName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireDataTypeWriteLock(LockList locks, DataverseName dataverseName, String datatypeName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDataTypeLockKey(dataverseName, datatypeName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireSynonymReadLock(LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createSynonymLockKey(dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireSynonymWriteLock(LockList locks, DataverseName dataverseName, String synonymName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createSynonymLockKey(dataverseName, synonymName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void acquireExtensionEntityReadLock(LockList locks, String extension, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createExtensionEntityLockKey(extension, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.READ, lock);
    }

    public void acquireExtensionEntityWriteLock(LockList locks, String extension, DataverseName dataverseName, String entityName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createExtensionEntityLockKey(extension, dataverseName, entityName);
        IMetadataLock lock = this.mdlocks.computeIfAbsent(key, LOCK_FUNCTION);
        locks.add(IMetadataLock.Mode.WRITE, lock);
    }

    public void upgradeDatasetLockToWrite(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.upgrade(IMetadataLock.Mode.UPGRADED_WRITE, (IMetadataLock)lock);
    }

    public void downgradeDatasetLockToExclusiveModify(LockList locks, DataverseName dataverseName, String datasetName) throws AlgebricksException {
        MetadataLockKey key = MetadataLockKey.createDatasetLockKey(dataverseName, datasetName);
        DatasetLock lock = this.mdlocks.computeIfAbsent(key, DATASET_LOCK_FUNCTION);
        locks.downgrade(IMetadataLock.Mode.EXCLUSIVE_MODIFY, (IMetadataLock)lock);
    }
}

