/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private static final String USER_AGENT = "User-Agent";
    private static final String DEFAULT_USER_AGENT_HEADER = "azsdk-java";
    public static final String OVERRIDE_USER_AGENT_CONTEXT_KEY = "Override-User-Agent";
    public static final String APPEND_USER_AGENT_CONTEXT_KEY = "Append-User-Agent";
    private static final String DEFAULT_USER_AGENT_FORMAT = "azsdk-java-%s/%s";
    private static final String PLATFORM_INFO_FORMAT = "%s; %s %s";
    private final String userAgent;

    public UserAgentPolicy() {
        this(null);
    }

    public UserAgentPolicy(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : DEFAULT_USER_AGENT_HEADER;
    }

    public UserAgentPolicy(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        this.userAgent = UserAgentPolicy.buildUserAgent(applicationId, sdkName, sdkVersion, configuration);
    }

    public UserAgentPolicy(String sdkName, String sdkVersion, Configuration configuration, ServiceVersion version) {
        this.userAgent = UserAgentPolicy.buildUserAgent(null, sdkName, sdkVersion, configuration);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String overrideUserAgent = context.getData(OVERRIDE_USER_AGENT_CONTEXT_KEY).orElse(null);
        String appendUserAgent = context.getData(APPEND_USER_AGENT_CONTEXT_KEY).orElse(null);
        String userAgentValue = !CoreUtils.isNullOrEmpty(overrideUserAgent) ? overrideUserAgent : (!CoreUtils.isNullOrEmpty(appendUserAgent) ? this.userAgent + " " + appendUserAgent : this.userAgent);
        context.getHttpRequest().getHeaders().put(USER_AGENT, userAgentValue);
        return next.process();
    }

    private static String buildUserAgent(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        StringBuilder userAgentBuilder = new StringBuilder();
        if (applicationId != null) {
            userAgentBuilder.append(applicationId).append(" ");
        }
        userAgentBuilder.append(String.format(DEFAULT_USER_AGENT_FORMAT, sdkName, sdkVersion));
        if (!UserAgentPolicy.telemetryDisabled(configuration)) {
            userAgentBuilder.append(" ").append("(").append(UserAgentPolicy.getPlatformInfo()).append(")");
        }
        return userAgentBuilder.toString();
    }

    private static String getPlatformInfo() {
        String javaVersion = Configuration.getGlobalConfiguration().get("java.version");
        String osName = Configuration.getGlobalConfiguration().get("os.name");
        String osVersion = Configuration.getGlobalConfiguration().get("os.version");
        return String.format(PLATFORM_INFO_FORMAT, javaVersion, osName, osVersion);
    }

    private static boolean telemetryDisabled(Configuration configuration) {
        return configuration == null ? Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", false).booleanValue() : configuration.get("AZURE_TELEMETRY_DISABLED", false).booleanValue();
    }
}

