/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.kv.subdoc.simple;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocMutationRequest;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class SubArrayRequest
extends AbstractSubdocMutationRequest {
    private final ArrayOperation arrayOp;

    public SubArrayRequest(String key, String path, ArrayOperation arrayOp, ByteBuf fragment, String bucket, int expiration, long cas) {
        super(key, path, fragment, bucket, expiration, cas);
        this.arrayOp = arrayOp;
        if (path.isEmpty() && arrayOp == ArrayOperation.INSERT) {
            this.cleanUpAndThrow(EXCEPTION_EMPTY_PATH);
        }
    }

    public SubArrayRequest(String key, String path, ArrayOperation arrayOp, ByteBuf fragment, String bucket) {
        this(key, path, arrayOp, fragment, bucket, 0, 0L);
    }

    @Override
    public byte opcode() {
        return this.arrayOp.opCode();
    }

    public ArrayOperation arrayOperation() {
        return this.arrayOp;
    }

    public static enum ArrayOperation {
        PUSH_FIRST(-52),
        PUSH_LAST(-53),
        INSERT(-51),
        ADD_UNIQUE(-50);

        private byte opCode;

        private ArrayOperation(byte opCode) {
            this.opCode = opCode;
        }

        public byte opCode() {
            return this.opCode;
        }
    }
}

