/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AUUID
implements IAObject {
    public static final int UUID_CHARS = 36;
    public static final int UUID_BYTES = 16;
    protected final byte[] uuidBytes;
    private static final char[] CHARS = new char[16];

    protected AUUID() {
        this(new byte[16]);
    }

    public AUUID(byte[] bytes) {
        this.uuidBytes = bytes;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AUUID", this.toString());
        return json;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AUUID;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof AUUID)) {
            return false;
        }
        AUUID oUUID = (AUUID)obj;
        return Arrays.equals(oUUID.uuidBytes, this.uuidBytes);
    }

    @Override
    public int hash() {
        return Arrays.hashCode(this.uuidBytes);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(45);
        buf.append("uuid: { ");
        return this.appendLiteralOnly(buf).append(" }").toString();
    }

    public StringBuilder appendLiteralOnly(StringBuilder buf) {
        return AUUID.appendLiteralOnly(this.uuidBytes, 0, buf);
    }

    private static StringBuilder digits(byte[] b, int offset, int count, StringBuilder result) {
        for (int i = 0; i < count; ++i) {
            result.append(CHARS[b[offset + i] >> 4 & 0xF]);
            result.append(CHARS[b[offset + i] & 0xF]);
        }
        return result;
    }

    public static StringBuilder appendLiteralOnly(byte[] bytes, int offset, StringBuilder result) {
        AUUID.digits(bytes, offset, 4, result).append('-');
        AUUID.digits(bytes, offset + 4, 2, result).append('-');
        AUUID.digits(bytes, offset + 6, 2, result).append('-');
        AUUID.digits(bytes, offset + 8, 2, result).append('-');
        return AUUID.digits(bytes, offset + 10, 6, result);
    }

    public void writeTo(DataOutput out) throws HyracksDataException {
        try {
            out.write(this.uuidBytes);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static AUUID readFrom(DataInput in) throws HyracksDataException {
        AUUID instance = new AUUID();
        try {
            in.readFully(instance.uuidBytes);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        return instance;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            AUUID.CHARS[i] = Character.forDigit(i, 16);
        }
    }
}

