/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types.hierachy;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.FloatPointable;

public class FloatToInt64TypeConvertComputer
implements ITypeConvertComputer {
    private static final FloatToInt64TypeConvertComputer INSTANCE_STRICT = new FloatToInt64TypeConvertComputer(true);
    private static final FloatToInt64TypeConvertComputer INSTANCE_LAX = new FloatToInt64TypeConvertComputer(false);
    private final boolean strict;

    private FloatToInt64TypeConvertComputer(boolean strict) {
        this.strict = strict;
    }

    public static FloatToInt64TypeConvertComputer getInstance(boolean strict) {
        return strict ? INSTANCE_STRICT : INSTANCE_LAX;
    }

    @Override
    public void convertType(byte[] data, int start, int length, DataOutput out) throws IOException {
        long targetValue = this.convertType(data, start);
        out.writeByte(ATypeTag.BIGINT.serialize());
        out.writeLong(targetValue);
    }

    @Override
    public IAObject convertType(IAObject sourceObject, ATypeHierarchy.TypeCastingMathFunctionType mathFunction) throws HyracksDataException {
        float sourceValue = ATypeHierarchy.applyMathFunctionToFloatValue(sourceObject, mathFunction);
        long targetValue = this.convert(sourceValue);
        return new AInt64(targetValue);
    }

    long convertType(byte[] data, int start) throws HyracksDataException {
        float sourceValue = FloatPointable.getFloat((byte[])data, (int)start);
        return this.convert(sourceValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long convert(float sourceValue) throws HyracksDataException {
        if (Float.isNaN(sourceValue)) {
            if (!this.strict) return 0L;
            this.raiseBoundaryCheckException(sourceValue);
            return (long)Math.floor(sourceValue);
        } else if (sourceValue > 9.223372E18f) {
            if (!this.strict) return Long.MAX_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
            return (long)Math.floor(sourceValue);
        } else {
            if (!(sourceValue < -9.223372E18f)) return (long)Math.floor(sourceValue);
            if (!this.strict) return Long.MIN_VALUE;
            this.raiseBoundaryCheckException(sourceValue);
        }
        return (long)Math.floor(sourceValue);
    }

    private void raiseBoundaryCheckException(float sourceValue) throws HyracksDataException {
        throw new RuntimeDataException(ErrorCode.TYPE_CONVERT_OUT_OF_BOUND, new Serializable[]{Float.valueOf(sourceValue), ATypeTag.BIGINT, Long.valueOf(Long.MAX_VALUE), Long.valueOf(Long.MIN_VALUE)});
    }
}

