/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.clienthelper;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.asterix.clienthelper.Args;
import org.apache.asterix.clienthelper.commands.ClientCommand;
import org.apache.asterix.clienthelper.commands.GenerateCredentialCommand;
import org.apache.asterix.clienthelper.commands.GetClusterStateCommand;
import org.apache.asterix.clienthelper.commands.ShutdownAllCommand;
import org.apache.asterix.clienthelper.commands.ShutdownCommand;
import org.apache.asterix.clienthelper.commands.SleepCommand;
import org.apache.asterix.clienthelper.commands.WaitForClusterCommand;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;

public class AsterixHelperExecution {
    public static final String ASTERIX_HELPER = "asterixhelper";
    public static final int COMMAND_USAGE_ALIGNMENT = 20;

    protected AsterixHelperExecution() {
    }

    public int execute(String[] argArray) throws IOException {
        Args args = this.createArgs();
        CmdLineParser parser = this.createParser(args);
        try {
            parser.parseArgument(argArray);
            if (args.getArguments().isEmpty()) {
                throw new CmdLineException(parser, "No command specified.", null);
            }
            ClientCommand command = this.getCommand(args);
            if (command == null) {
                throw new CmdLineException(parser, "Unknown command specified: " + args.getArguments().get(0), null);
            }
            return command.execute();
        }
        catch (CmdLineException e) {
            System.err.println("ERROR: " + e.getMessage() + "\n\nUsage: " + this.getHelperCommandName() + " [options] <command>");
            this.printUsageDetails(parser, System.err);
            return 99;
        }
    }

    protected void printUsageDetails(CmdLineParser parser, PrintStream ps) {
        ps.println("\nCommands:");
        this.printCommandsUsage(ps);
        ps.println("\nOptions:");
        parser.printUsage((OutputStream)ps);
        ps.flush();
    }

    protected String getHelperCommandName() {
        return ASTERIX_HELPER;
    }

    protected void printCommandsUsage(PrintStream out) {
        for (ClientCommand.Command command : ClientCommand.Command.values()) {
            this.printCommandUsage(out, command);
        }
    }

    protected void printCommandUsage(PrintStream out, ClientCommand.Command command) {
        this.printCommandUsage(out, command.name(), command.usage());
    }

    protected void printCommandUsage(PrintStream out, String name, String usage) {
        StringBuilder padding = new StringBuilder();
        for (int i = name.length(); i < 20; ++i) {
            padding.append(' ');
        }
        out.println("  " + name.toLowerCase() + padding.toString() + " : " + usage);
    }

    protected CmdLineParser createParser(Args args) {
        return new CmdLineParser((Object)args, ParserProperties.defaults().withUsageWidth(120));
    }

    protected Args createArgs() {
        return new Args();
    }

    protected ClientCommand getCommand(Args args) {
        ClientCommand.Command command = ClientCommand.Command.valueOfSafe(args.getArguments().get(0));
        if (command == null) {
            return null;
        }
        switch (command) {
            case GET_CLUSTER_STATE: {
                return new GetClusterStateCommand(args);
            }
            case WAIT_FOR_CLUSTER: {
                return new WaitForClusterCommand(args);
            }
            case SHUTDOWN_CLUSTER: {
                return new ShutdownCommand(args);
            }
            case SHUTDOWN_CLUSTER_ALL: {
                return new ShutdownAllCommand(args);
            }
            case SLEEP: {
                return new SleepCommand(args);
            }
            case ADD_CREDENTIAL: {
                return new GenerateCredentialCommand(args);
            }
        }
        throw new IllegalStateException("NYI: " + command);
    }
}

