/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.EquivalenceClass;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractGroupByPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.PropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;

public abstract class AbstractPreclusteredGroupByPOperator
extends AbstractGroupByPOperator {
    protected AbstractPreclusteredGroupByPOperator(List<LogicalVariable> columnList) {
        super(columnList);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        GroupByOperator gby = (GroupByOperator)op;
        ILogicalOperator childOp = (ILogicalOperator)gby.getInputs().get(0).getValue();
        IPhysicalPropertiesVector childProperties = childOp.getDeliveredPhysicalProperties();
        IPartitioningProperty partitioning = this.computePartitioningProperty(gby, childProperties.getPartitioningProperty());
        List<ILocalStructuralProperty> local = this.computeLocalProperties(gby, childProperties.getLocalProperties());
        this.deliveredProperties = new StructuralPropertiesVector(partitioning, local);
    }

    private IPartitioningProperty computePartitioningProperty(GroupByOperator gby, IPartitioningProperty childPartitioning) {
        Map<LogicalVariable, LogicalVariable> substMap = this.computePartitioningPropertySubstitutionMap(gby, childPartitioning);
        return substMap != null ? childPartitioning.substituteColumnVars(substMap) : childPartitioning;
    }

    private List<ILocalStructuralProperty> computeLocalProperties(GroupByOperator gby, List<ILocalStructuralProperty> childLocals) {
        ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
        if (childLocals != null) {
            for (ILocalStructuralProperty lsp : childLocals) {
                ILocalStructuralProperty propagatedLsp = this.getPropagatedProperty(lsp, gby);
                if (propagatedLsp == null) continue;
                propsLocal.add(propagatedLsp);
            }
        }
        return propsLocal;
    }

    private Map<LogicalVariable, LogicalVariable> computePartitioningPropertySubstitutionMap(GroupByOperator gbyOp, IPartitioningProperty childpp) {
        HashSet<LogicalVariable> childPartitioningColumns = new HashSet<LogicalVariable>();
        childpp.getColumns(childPartitioningColumns);
        List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> groupByList = gbyOp.getGroupByList();
        if (groupByList.size() != childPartitioningColumns.size()) {
            return null;
        }
        HashMap<LogicalVariable, LogicalVariable> substMap = null;
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : groupByList) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)ve.second).getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                return null;
            }
            VariableReferenceExpression varRefExpr = (VariableReferenceExpression)expr;
            LogicalVariable var = varRefExpr.getVariableReference();
            if (!childPartitioningColumns.remove(var)) {
                return null;
            }
            if (substMap == null) {
                substMap = new HashMap<LogicalVariable, LogicalVariable>();
            }
            substMap.put(var, (LogicalVariable)ve.first);
        }
        return childPartitioningColumns.isEmpty() ? substMap : null;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        List<ILocalStructuralProperty> lpPar;
        GroupByOperator gby = (GroupByOperator)op;
        IPhysicalPropertiesVector[] pv = new StructuralPropertiesVector[1];
        if (gby.isGroupAll() && gby.isGlobal()) {
            if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
                pv[0] = new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, null);
                return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
            }
            return this.emptyUnaryRequirements();
        }
        ArrayList<ILocalStructuralProperty> localProps = new ArrayList<ILocalStructuralProperty>();
        ListSet gbvars = new ListSet((Collection)this.columnList);
        LocalGroupingProperty groupProp = new LocalGroupingProperty((Set<LogicalVariable>)gbvars, new ArrayList<LogicalVariable>(this.columnList));
        boolean goon = true;
        for (ILogicalPlan p : gby.getNestedPlans()) {
            for (Mutable<ILogicalOperator> mutable : p.getRoots()) {
                AbstractLogicalOperator op2;
                IPhysicalOperator pop2;
                AbstractLogicalOperator op1 = (AbstractLogicalOperator)mutable.getValue();
                if (op1.getOperatorTag() != LogicalOperatorTag.AGGREGATE || !((pop2 = (op2 = (AbstractLogicalOperator)op1.getInputs().get(0).getValue()).getPhysicalOperator()) instanceof AbstractPreclusteredGroupByPOperator)) continue;
                List<LogicalVariable> gbyColumns = ((AbstractPreclusteredGroupByPOperator)pop2).getGroupByColumns();
                ArrayList<LogicalVariable> sndOrder = new ArrayList<LogicalVariable>();
                sndOrder.addAll(gbyColumns);
                HashSet<LogicalVariable> freeVars = new HashSet<LogicalVariable>();
                try {
                    OperatorPropertiesUtil.getFreeVariablesInSelfOrDesc(op2, freeVars);
                }
                catch (AlgebricksException e) {
                    throw new IllegalStateException(e);
                }
                sndOrder.retainAll(freeVars);
                groupProp.getColumnSet().addAll(sndOrder);
                groupProp.getPreferredOrderEnforcer().addAll(sndOrder);
                goon = false;
                break;
            }
            if (goon) continue;
            break;
        }
        localProps.add(groupProp);
        if (reqdByParent != null && (lpPar = reqdByParent.getLocalProperties()) != null) {
            boolean allOk = true;
            ArrayList<ILocalStructuralProperty> props = new ArrayList<ILocalStructuralProperty>(lpPar.size());
            for (ILocalStructuralProperty prop : lpPar) {
                if (prop.getPropertyType() != ILocalStructuralProperty.PropertyType.LOCAL_ORDER_PROPERTY) {
                    allOk = false;
                    break;
                }
                LocalOrderProperty lop = (LocalOrderProperty)prop;
                ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
                List<OrderColumn> ords = lop.getOrderColumns();
                for (OrderColumn ord : ords) {
                    Pair<LogicalVariable, Mutable<ILogicalExpression>> p = AbstractPreclusteredGroupByPOperator.getGbyPairByRhsVar(gby, ord.getColumn());
                    if (p == null && (p = AbstractPreclusteredGroupByPOperator.getDecorPairByRhsVar(gby, ord.getColumn())) == null) {
                        allOk = false;
                        break;
                    }
                    ILogicalExpression e = (ILogicalExpression)((Mutable)p.second).getValue();
                    if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        throw new IllegalStateException("Right hand side of group-by assignment should have been normalized to a variable reference.");
                    }
                    LogicalVariable v = ((VariableReferenceExpression)e).getVariableReference();
                    orderColumns.add(new OrderColumn(v, ord.getOrder()));
                }
                props.add(new LocalOrderProperty(orderColumns));
            }
            ArrayList<FunctionalDependency> arrayList = new ArrayList<FunctionalDependency>();
            for (Pair<LogicalVariable, Mutable<ILogicalExpression>> decorPair : gby.getDecorList()) {
                List<LogicalVariable> hd = gby.getGroupByVarList();
                ArrayList<LogicalVariable> tl = new ArrayList<LogicalVariable>();
                tl.add(((VariableReferenceExpression)((Mutable)decorPair.second).getValue()).getVariableReference());
                arrayList.add(new FunctionalDependency(hd, tl));
            }
            if (allOk && PropertiesUtil.matchLocalProperties(localProps, props, new HashMap<LogicalVariable, EquivalenceClass>(), arrayList)) {
                localProps = props;
            }
        }
        UnorderedPartitionedProperty pp = null;
        AbstractLogicalOperator aop = (AbstractLogicalOperator)op;
        if (aop.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            pp = new UnorderedPartitionedProperty((Set<LogicalVariable>)new ListSet((Collection)this.columnList), context.getComputationNodeDomain());
        }
        pv[0] = new StructuralPropertiesVector(pp, localProps);
        return new PhysicalRequirements(pv, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    private static Pair<LogicalVariable, Mutable<ILogicalExpression>> getGbyPairByRhsVar(GroupByOperator gby, LogicalVariable var) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : gby.getGroupByList()) {
            if (ve.first != var) continue;
            return ve;
        }
        return null;
    }

    private static Pair<LogicalVariable, Mutable<ILogicalExpression>> getDecorPairByRhsVar(GroupByOperator gby, LogicalVariable var) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : gby.getDecorList()) {
            if (ve.first != var) continue;
            return ve;
        }
        return null;
    }

    private static LogicalVariable getLhsGbyVar(GroupByOperator gby, LogicalVariable var) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : gby.getGroupByList()) {
            ILogicalExpression e = (ILogicalExpression)((Mutable)ve.second).getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                throw new IllegalStateException("Right hand side of group by assignment should have been normalized to a variable reference.");
            }
            LogicalVariable v = ((VariableReferenceExpression)e).getVariableReference();
            if (!v.equals(var)) continue;
            return (LogicalVariable)ve.first;
        }
        return null;
    }

    private ILocalStructuralProperty getPropagatedProperty(ILocalStructuralProperty lsp, GroupByOperator gby) {
        OrderColumn oc;
        LogicalVariable v2;
        ILocalStructuralProperty.PropertyType propertyType = lsp.getPropertyType();
        if (propertyType == ILocalStructuralProperty.PropertyType.LOCAL_GROUPING_PROPERTY) {
            return new LocalGroupingProperty((Set<LogicalVariable>)new ListSet(gby.getGroupByVarList()));
        }
        LocalOrderProperty lop = (LocalOrderProperty)lsp;
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        Iterator<OrderColumn> iterator = lop.getOrderColumns().iterator();
        while (iterator.hasNext() && (v2 = AbstractPreclusteredGroupByPOperator.getLhsGbyVar(gby, (oc = iterator.next()).getColumn())) != null) {
            orderColumns.add(new OrderColumn(v2, oc.getOrder()));
        }
        return orderColumns.isEmpty() ? null : new LocalOrderProperty(orderColumns);
    }
}

