/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.application.NCServiceContext;
import org.apache.hyracks.control.nc.net.NetworkManager;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.hyracks.util.JSONUtil;

public class NetDiagnosticsApiServlet
extends AbstractServlet {
    private final INcApplicationContext appCtx;

    public NetDiagnosticsApiServlet(ConcurrentMap<String, Object> ctx, INcApplicationContext appCtx, String ... paths) {
        super(ctx, paths);
        this.appCtx = appCtx;
    }

    protected void get(IServletRequest request, IServletResponse response) throws IOException {
        HttpUtil.setContentType((IServletResponse)response, (String)"application/json", (IServletRequest)request);
        response.setStatus(HttpResponseStatus.OK);
        JsonNode netDiagnostics = this.getNetDiagnostics();
        PrintWriter responseWriter = response.writer();
        JSONUtil.writeNode((Writer)responseWriter, (JsonNode)netDiagnostics);
    }

    private JsonNode getNetDiagnostics() {
        NCServiceContext serviceContext = (NCServiceContext)this.appCtx.getServiceContext();
        NodeControllerService controllerService = (NodeControllerService)serviceContext.getControllerService();
        NetworkManager networkManager = controllerService.getNetworkManager();
        return networkManager.getMuxDemux().getState();
    }
}

