/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.util.ThrowingFunction;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static List<Exception> getActualExceptions(List<Exception> allExceptions) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Exception exception : allExceptions) {
            if (!ExceptionUtils.possibleRootCause(exception)) continue;
            exceptions.add(exception);
        }
        return exceptions;
    }

    public static void setNodeIds(Collection<Exception> exceptions, String nodeId) {
        ArrayList<Exception> newExceptions = new ArrayList<Exception>();
        for (Exception e : exceptions) {
            if (e instanceof HyracksDataException) {
                if (((HyracksDataException)e).getNodeId() == null) {
                    newExceptions.add(HyracksDataException.create((HyracksDataException)e, nodeId));
                    continue;
                }
                newExceptions.add(e);
                continue;
            }
            newExceptions.add(HyracksDataException.create(ErrorCode.FAILURE_ON_NODE, (Throwable)e, new Serializable[]{nodeId}));
        }
        exceptions.clear();
        exceptions.addAll(newExceptions);
    }

    private static boolean possibleRootCause(Throwable exception) {
        Throwable cause = exception;
        while ((cause = cause.getCause()) != null) {
            if (!(cause instanceof InterruptedException) && !(cause instanceof ClosedChannelException)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Throwable> T suppress(T first, T second) {
        if (second instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first != second) {
            first.addSuppressed(second);
        }
        return first;
    }

    public static Throwable fromThreadStack(Thread thread) {
        Throwable stackThrowable = new Throwable(thread.getName() + " Stack trace");
        stackThrowable.setStackTrace(thread.getStackTrace());
        return stackThrowable;
    }

    public static Throwable getRootCause(Throwable e) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != null && cause != current) {
            current = cause;
            cause = current.getCause();
        }
        return current;
    }

    public static boolean causedByInterrupt(Throwable th) {
        return ExceptionUtils.getRootCause(th) instanceof InterruptedException;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, ThrowingFunction<K, V> function) throws HyracksDataException {
        try {
            return (V)map.computeIfAbsent(key, k -> {
                try {
                    return function.process(k);
                }
                catch (Exception e) {
                    throw new UncheckedExecutionException((Throwable)e);
                }
            });
        }
        catch (UncheckedExecutionException e) {
            throw HyracksDataException.create(e.getCause());
        }
    }

    public static String getErrorMessage(Throwable th) {
        Throwable cause = ExceptionUtils.getRootCause(th);
        return cause.getMessage();
    }

    public static boolean matchingCause(Throwable e, Predicate<Throwable> test) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != null && cause != current) {
            if (test.test(cause)) {
                return true;
            }
            Throwable nextCause = current.getCause();
            current = cause;
            cause = nextCause;
        }
        return test.test(e);
    }

    public static Throwable unwrap(Throwable e) {
        Throwable current = e;
        Throwable cause = e.getCause();
        while (cause != current && cause instanceof IFormattedException) {
            current = cause;
            cause = current.getCause();
        }
        return current;
    }

    public static String getMessageOrToString(Throwable e) {
        return e instanceof IFormattedException ? e.getMessage() : e.toString();
    }

    public static boolean isErrorCode(HyracksDataException throwable, ErrorCode code) {
        return throwable.getError().isPresent() && throwable.getError().get() == code;
    }
}

