/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeDiskComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeWithBloomFilterDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.AbstractLSMWithBuddyDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;

public class LSMBTreeWithBuddyDiskComponent
extends AbstractLSMWithBuddyDiskComponent {
    private final BTree btree;
    private final BloomFilter bloomFilter;
    private final BTree buddyBtree;

    public LSMBTreeWithBuddyDiskComponent(AbstractLSMIndex lsmIndex, BTree btree, BTree buddyBtree, BloomFilter bloomFilter, ILSMComponentFilter filter) {
        super(lsmIndex, LSMBTreeDiskComponent.getMetadataPageManager(btree), filter);
        this.btree = btree;
        this.bloomFilter = bloomFilter;
        this.buddyBtree = buddyBtree;
    }

    public BTree getBuddyIndex() {
        return this.buddyBtree;
    }

    public long getComponentSize() {
        return LSMBTreeDiskComponent.getComponentSize(this.btree) + LSMBTreeWithBloomFilterDiskComponent.getComponentSize(this.bloomFilter) + this.buddyBtree.getFileReference().getFile().length();
    }

    public Set<String> getLSMComponentPhysicalFiles() {
        Set<String> files = LSMBTreeDiskComponent.getFiles(this.btree);
        LSMBTreeWithBloomFilterDiskComponent.addFiles(files, this.bloomFilter);
        files.add(this.buddyBtree.getFileReference().getFile().getAbsolutePath());
        return files;
    }

    public void validate() throws HyracksDataException {
        throw new UnsupportedOperationException("Validation not implemented for LSM B-Trees with Buddy B-Tree.");
    }

    public int getFileReferenceCount() {
        return LSMBTreeDiskComponent.getFileReferenceCount(this.btree);
    }

    public BTree getMetadataHolder() {
        return this.btree;
    }

    public BTree getIndex() {
        return this.btree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public IBufferCache getBloomFilterBufferCache() {
        return this.getMetadataHolder().getBufferCache();
    }
}

