/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.fulltext.AbstractFullTextFilterDescriptor;
import org.apache.asterix.runtime.fulltext.StopwordsFullTextFilterDescriptor;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.FullTextFilterType;

public class FullTextFilterMetadataEntityTupleTranslator
extends AbstractTupleTranslator<FullTextFilterMetadataEntity> {
    private static final int FULLTEXT_FILTER_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    protected final ArrayTupleReference tuple;
    protected final ISerializerDeserializer<AInt8> int8Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);

    protected FullTextFilterMetadataEntityTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FULL_TEXT_FILTER_DATASET, 2);
        this.tuple = getTuple ? new ArrayTupleReference() : null;
    }

    @Override
    protected FullTextFilterMetadataEntity createMetadataEntityFromARecord(ARecord aRecord) throws AlgebricksException {
        AString dataverseName = (AString)aRecord.getValueByPos(0);
        AString filterName = (AString)aRecord.getValueByPos(1);
        AString filterTypeAString = (AString)aRecord.getValueByPos(2);
        FullTextFilterType filterType = FullTextFilterType.getEnumIgnoreCase((String)filterTypeAString.getStringValue());
        switch (filterType) {
            case STOPWORDS: {
                return this.createStopwordsFilterDescriptorFromARecord(dataverseName, filterName, aRecord);
            }
        }
        throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{"Not supported yet"});
    }

    public FullTextFilterMetadataEntity createStopwordsFilterDescriptorFromARecord(AString dataverseName, AString name, ARecord aRecord) throws AlgebricksException {
        ImmutableList.Builder stopwordsBuilder = ImmutableList.builder();
        IACursor stopwordsCursor = ((AOrderedList)aRecord.getValueByPos(3)).getCursor();
        while (stopwordsCursor.next()) {
            stopwordsBuilder.add((Object)((AString)stopwordsCursor.get()).getStringValue());
        }
        StopwordsFullTextFilterDescriptor filterDescriptor = new StopwordsFullTextFilterDescriptor(DataverseName.createFromCanonicalForm((String)dataverseName.getStringValue()), name.getStringValue(), stopwordsBuilder.build());
        return new FullTextFilterMetadataEntity((AbstractFullTextFilterDescriptor)filterDescriptor);
    }

    private void writeKeyAndValue2FieldVariables(String key, String value) throws HyracksDataException {
        this.fieldName.reset();
        this.aString.setValue(key);
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        this.fieldValue.reset();
        this.aString.setValue(value);
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
    }

    private void writeOrderedList2RecordBuilder(String strFieldName, List<String> list) throws HyracksDataException {
        this.fieldName.reset();
        this.aString.setValue(strFieldName);
        this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)BuiltinType.ASTRING, null));
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        for (String s : list) {
            itemValue.reset();
            this.aString.setValue(s);
            this.stringSerde.serialize((Object)this.aString, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField((IValueReference)this.fieldName, (IValueReference)this.fieldValue);
    }

    private void writeStopwordFilterDescriptor(StopwordsFullTextFilterDescriptor stopwordsFullTextFilterDescriptor) throws HyracksDataException {
        this.writeOrderedList2RecordBuilder("StopwordList", stopwordsFullTextFilterDescriptor.getStopwordList());
    }

    private void writeFulltextFilter(AbstractFullTextFilterDescriptor filterDescriptor) throws AsterixException, HyracksDataException {
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getDataverseName().getCanonicalForm());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(filterDescriptor.getFilterType().getValue());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        switch (filterDescriptor.getFilterType()) {
            case STOPWORDS: {
                this.writeStopwordFilterDescriptor((StopwordsFullTextFilterDescriptor)filterDescriptor);
                break;
            }
            default: {
                throw new AsterixException(ErrorCode.METADATA_ERROR, new Serializable[]{"Not supported yet"});
            }
        }
    }

    private void writeIndex(String dataverseName, String filterName, ArrayTupleBuilder tupleBuilder) throws HyracksDataException {
        this.aString.setValue(dataverseName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
        this.aString.setValue(filterName);
        this.stringSerde.serialize((Object)this.aString, tupleBuilder.getDataOutput());
        tupleBuilder.addFieldEndOffset();
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FullTextFilterMetadataEntity filterMetadataEntity) throws HyracksDataException, AsterixException {
        this.tupleBuilder.reset();
        this.writeIndex(filterMetadataEntity.getFullTextFilter().getDataverseName().getCanonicalForm(), filterMetadataEntity.getFullTextFilter().getName(), this.tupleBuilder);
        this.recordBuilder.reset(MetadataRecordTypes.FULL_TEXT_FILTER_RECORDTYPE);
        this.writeFulltextFilter(filterMetadataEntity.getFullTextFilter());
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

